/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.product.handlers.ofsn;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.oodt.product.ProductException;
import org.apache.oodt.product.handlers.ofsn.OFSNGetHandler;

public class MD5GetHandler
implements OFSNGetHandler {
    private MessageDigest md = null;

    public MD5GetHandler() throws InstantiationException {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new InstantiationException(e.getMessage());
        }
    }

    public void configure(Properties conf) {
    }

    public byte[] retrieveChunk(String filepath, long offset, int length) throws ProductException {
        try {
            String hash = this.hashData(FileUtils.readFileToByteArray((File)new File(filepath)));
            byte[] retBytes = new byte[length];
            byte[] hashBytes = hash.getBytes();
            ByteArrayInputStream is = new ByteArrayInputStream(hashBytes);
            is.skip(offset);
            is.read(retBytes, 0, length);
            return retBytes;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ProductException("Error reading bytes from file: [" + filepath + "] MD5: Message: " + e.getMessage());
        }
    }

    public long sizeOf(String filepath) {
        try {
            String hash = this.hashData(FileUtils.readFileToByteArray((File)new File(filepath)));
            return hash.getBytes().length;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("MD5GetHandler <file>");
            System.exit(1);
        }
        String filepath = args[0];
        String hashString = new MD5GetHandler().hashData(FileUtils.readFileToByteArray((File)new File(filepath)));
        System.out.println(hashString);
    }

    private String hashData(byte[] dataToHash) {
        this.md.update(dataToHash, 0, dataToHash.length);
        byte[] hash = this.md.digest();
        return new String(Hex.encodeHex((byte[])hash));
    }
}

