/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.xmlquery;

import java.io.IOException;
import java.io.InputStream;
import org.apache.oodt.product.ProductException;
import org.apache.oodt.product.Retriever;

final class ChunkedProductInputStream
extends InputStream {
    private String id;
    private Retriever retriever;
    private long size;
    private byte[] block;
    private int blockIndex;
    private long productIndex = 0L;
    private boolean eof;
    private boolean open;
    private static final int BLOCK_SIZE = Integer.getInteger("org.apache.oodt.xmlquery.blockSize", 4096);

    ChunkedProductInputStream(String id, Retriever retriever, long size) {
        this.id = id;
        this.size = size;
        this.retriever = retriever;
        this.open = true;
        this.eof = false;
    }

    public int read() throws IOException {
        this.checkOpen();
        if (this.eof) {
            throw new IOException("End of file");
        }
        this.fetchBlock();
        if (this.eof) {
            return -1;
        }
        return this.block[this.blockIndex++];
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        this.checkOpen();
        if (offset < 0 || offset > b.length || length < 0 || offset + length > b.length || offset + length < 0) {
            throw new IllegalArgumentException("Illegal offset=" + offset + "/length=" + length + " for byte array of length " + b.length);
        }
        if (length == 0) {
            return 0;
        }
        if (this.eof) {
            throw new IOException("End of file");
        }
        this.fetchBlock();
        if (this.eof) {
            return -1;
        }
        int amount = Math.min(length, this.block.length - this.blockIndex);
        System.arraycopy(this.block, this.blockIndex, b, offset, amount);
        this.blockIndex += amount;
        return amount;
    }

    private void fetchBlock() throws IOException {
        if (this.block == null || this.blockIndex == this.block.length) {
            try {
                if (this.productIndex == this.size) {
                    this.block = null;
                    this.eof = true;
                } else {
                    int x = (int)Math.min((long)BLOCK_SIZE, this.size - this.productIndex);
                    this.block = this.retriever.retrieveChunk(this.id, this.productIndex, x);
                    this.blockIndex = 0;
                    this.productIndex += (long)this.block.length;
                }
            }
            catch (ProductException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    public int available() throws IOException {
        this.checkOpen();
        return this.block == null ? 0 : this.block.length - this.blockIndex;
    }

    public void close() throws IOException {
        this.checkOpen();
        try {
            this.retriever.close(this.id);
            this.open = false;
        }
        catch (ProductException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void mark(int limit) {
        throw new UnsupportedOperationException("Mark not supported");
    }

    public void reset() {
        throw new UnsupportedOperationException("Reset not supported");
    }

    public boolean markSuppoted() {
        return false;
    }

    private final void checkOpen() throws IOException {
        if (this.open) {
            return;
        }
        throw new IOException("Stream closed");
    }
}

