/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.product.handlers.ofsn.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.oodt.commons.xml.XMLUtils;
import org.apache.oodt.product.handlers.ofsn.OFSNHandlerConfig;
import org.apache.oodt.product.handlers.ofsn.metadata.OFSNMetKeys;
import org.apache.oodt.product.handlers.ofsn.metadata.OFSNXMLMetKeys;
import org.apache.oodt.product.handlers.ofsn.metadata.OODTMetKeys;
import org.apache.oodt.xmlquery.QueryElement;
import org.apache.oodt.xmlquery.XMLQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OFSNUtils
implements OODTMetKeys,
OFSNXMLMetKeys,
OFSNMetKeys {
    public static String extractFieldFromQuery(XMLQuery query, String name) {
        Iterator i = query.getWhereElementSet().iterator();
        while (i.hasNext()) {
            QueryElement element = (QueryElement)i.next();
            if (!element.getRole().equals("elemName") || !element.getValue().equals(name)) continue;
            QueryElement litElement = (QueryElement)i.next();
            return litElement.getValue();
        }
        return null;
    }

    public static Document getOFSNDoc(List<File> fileList, OFSNHandlerConfig cfg, String productRoot, boolean showDirSize, boolean showFileSize) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element root = document.createElement("dirResult");
            XMLUtils.addAttribute((Document)document, (Element)root, (String)"xmlns", (String)"http://oodt.jpl.nasa.gov/xml/namespaces/dirlist/1.0");
            document.appendChild(root);
            for (File file : fileList) {
                Element dirEntryElem = XMLUtils.addNode((Document)document, (Node)root, (String)"dirEntry");
                String ofsn = OFSNUtils.toOFSN(file.getAbsolutePath(), productRoot);
                String unixStyleOFSN = FilenameUtils.separatorsToUnix((String)ofsn);
                if (cfg.getType().equals("listing") && !Boolean.valueOf(cfg.getHandlerConf().getProperty("isSizeCmd")).booleanValue()) {
                    XMLUtils.addNode((Document)document, (Node)dirEntryElem, (String)"OFSN", (String)unixStyleOFSN);
                }
                long size = Long.MIN_VALUE;
                if (file.isDirectory()) {
                    if (showDirSize) {
                        size = FileUtils.sizeOfDirectory((File)file);
                    }
                } else if (showFileSize) {
                    size = file.length();
                }
                if (size == Long.MIN_VALUE) continue;
                XMLUtils.addNode((Document)document, (Node)dirEntryElem, (String)"fileSize", (String)String.valueOf(size));
            }
            return document;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String relativeize(String path, String productRoot) {
        return productRoot + (path.startsWith("/") ? path.substring(1) : path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File buildZipFile(String zipFileFullPath, File[] files) {
        byte[] buf = new byte[1024];
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(zipFileFullPath));
            for (File file : files) {
                int len;
                FileInputStream in = new FileInputStream(file);
                out.putNextEntry(new ZipEntry(file.getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ignore) {}
                out = null;
            }
        }
        return new File(zipFileFullPath);
    }

    private static String toOFSN(String absolutePath, String productRootPath) {
        if (absolutePath.startsWith(productRootPath)) {
            return absolutePath.substring(productRootPath.length());
        }
        return new File(absolutePath).getName();
    }
}

