/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesFactory;

public final class MimeTypeUtils {
    private static final String SEPARATOR = ";";
    private MimeTypes mimeTypes;
    private Tika tika = new Tika();
    private boolean mimeMagic;
    public static final String MIME_FILE_RES_PATH = "tika-mimetypes.xml";
    private static final Logger LOG = Logger.getLogger(MimeTypeUtils.class.getName());

    public MimeTypeUtils() {
        this(MimeTypeUtils.class.getResourceAsStream(MIME_FILE_RES_PATH), true);
    }

    public MimeTypeUtils(String filePath) throws FileNotFoundException {
        this(filePath, true);
    }

    public MimeTypeUtils(String filePath, boolean magic) throws FileNotFoundException {
        this(new FileInputStream(filePath), magic);
    }

    public MimeTypeUtils(InputStream mimeIs, boolean magic) {
        try {
            this.mimeTypes = MimeTypesFactory.create((InputStream)mimeIs);
            this.mimeMagic = magic;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to load MimeType Registry : " + e.getMessage(), e);
        }
    }

    public static String cleanMimeType(String origType) {
        if (origType == null) {
            return null;
        }
        String[] tokenizedMimeType = origType.split(SEPARATOR);
        if (tokenizedMimeType.length > 1) {
            return tokenizedMimeType[0];
        }
        return origType;
    }

    public String autoResolveContentType(String url, byte[] data) {
        return this.autoResolveContentType(null, url, data);
    }

    public String autoResolveContentType(String typeName, String url, byte[] data) {
        MimeType type = null;
        String cleanedMimeType = null;
        try {
            cleanedMimeType = MimeTypeUtils.cleanMimeType(typeName) != null ? this.mimeTypes.forName(MimeTypeUtils.cleanMimeType(typeName)).getName() : null;
        }
        catch (MimeTypeException mte) {
            // empty catch block
        }
        try {
            type = cleanedMimeType != null ? this.mimeTypes.forName(cleanedMimeType) : null;
        }
        catch (MimeTypeException e) {
            type = null;
        }
        if (type == null || type.getName().equals("application/octet-stream")) {
            try {
                type = this.mimeTypes.forName(this.tika.detect(url)) != null ? this.mimeTypes.forName(this.tika.detect(url)) : type;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.mimeMagic) {
            MimeType magicType;
            try {
                magicType = this.mimeTypes.forName(this.tika.detect(data));
            }
            catch (Exception e) {
                magicType = null;
            }
            if (magicType != null && !magicType.getName().equals("application/octet-stream") && type != null && !type.getName().equals(magicType.getName())) {
                type = magicType;
            }
            if (type == null) {
                try {
                    type = this.mimeTypes.forName("application/octet-stream");
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }
        return type.getName();
    }

    public String getMimeType(URL url) {
        try {
            return this.tika.detect(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getMimeType(String name) {
        try {
            return this.tika.detect(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getMimeType(File f) {
        try {
            return this.tika.detect(f);
        }
        catch (Exception e) {
            System.err.println("\n\n\n");
            e.printStackTrace();
            System.err.println("\n\n\n");
            return null;
        }
    }

    public String getMimeTypeByMagic(byte[] data) {
        try {
            return this.tika.detect(data);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getDescriptionForMimeType(String mimeType) {
        try {
            return this.mimeTypes.forName(mimeType).getDescription();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to get description for mimetype " + mimeType + " : " + e.getMessage());
            return null;
        }
    }

    public String getSuperTypeForMimeType(String mimeType) {
        try {
            MediaType mediaType = this.mimeTypes.getMediaTypeRegistry().getSupertype(this.mimeTypes.forName(mimeType).getType());
            if (mediaType != null) {
                return mediaType.getType() + "/" + mediaType.getSubtype();
            }
            return null;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to get super-type for mimetype " + mimeType + " : " + e.getMessage());
            return null;
        }
    }

    public boolean isMimeMagic() {
        return this.mimeMagic;
    }

    public void setMimeMagic(boolean mimeMagic) {
        this.mimeMagic = mimeMagic;
    }

    public static byte[] readMagicHeader(InputStream stream) throws IOException {
        return MimeTypeUtils.readMagicHeader(stream, 1024);
    }

    public static byte[] readMagicHeader(InputStream stream, int headerByteSize) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("InputStream is missing");
        }
        byte[] bytes = new byte[headerByteSize];
        int totalRead = 0;
        int lastRead = stream.read(bytes);
        while (lastRead != -1) {
            if ((totalRead += lastRead) == bytes.length) {
                return bytes;
            }
            lastRead = stream.read(bytes, totalRead, bytes.length - totalRead);
        }
        byte[] shorter = new byte[totalRead];
        System.arraycopy(bytes, 0, shorter, 0, totalRead);
        return shorter;
    }
}

