/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.extractors;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.apache.oodt.cas.metadata.MetExtractorConfig;
import org.apache.oodt.cas.metadata.MetExtractorConfigReader;
import org.apache.oodt.cas.metadata.exceptions.MetExtractorConfigReaderException;
import org.apache.oodt.cas.metadata.extractors.ExternConfigReaderMetKeys;
import org.apache.oodt.cas.metadata.extractors.ExternMetExtractorMetKeys;
import org.apache.oodt.cas.metadata.extractors.ExternalMetExtractorConfig;
import org.apache.oodt.cas.metadata.util.PathUtils;
import org.apache.oodt.commons.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ExternConfigReader
implements MetExtractorConfigReader,
ExternMetExtractorMetKeys,
ExternConfigReaderMetKeys {
    @Override
    public MetExtractorConfig parseConfigFile(File file) throws MetExtractorConfigReaderException {
        try {
            NodeList argNodes;
            Document doc = XMLUtils.getDocumentRoot((InputStream)new FileInputStream(file));
            ExternalMetExtractorConfig config = new ExternalMetExtractorConfig();
            Element docElem = doc.getDocumentElement();
            Element execElement = XMLUtils.getFirstElement((String)"exec", (Element)docElem);
            config.setWorkingDirPath(PathUtils.replaceEnvVariables(execElement.getAttribute("workingDir")));
            String metFileExt = PathUtils.replaceEnvVariables(execElement.getAttribute("metFileExt"));
            if (!metFileExt.equals("")) {
                config.setMetFileExt(metFileExt);
            }
            Element binPathElem = XMLUtils.getFirstElement((String)"extractorBinPath", (Element)execElement);
            String binPath = XMLUtils.getSimpleElementText((Element)binPathElem);
            if (Boolean.valueOf(binPathElem.getAttribute("envReplace")).booleanValue()) {
                binPath = PathUtils.replaceEnvVariables(binPath);
            }
            binPath = binPath.replaceAll("^\\s+", "").replaceAll("\\s+$", "").replaceAll("\\s", "\\\\ ");
            config.setExtractorBinPath(binPath);
            Element argsElem = XMLUtils.getFirstElement((String)"args", (Element)execElement);
            if (argsElem != null && (argNodes = argsElem.getElementsByTagName("arg")) != null && argNodes.getLength() > 0) {
                Vector<String> argVector = new Vector<String>();
                for (int i = 0; i < argNodes.getLength(); ++i) {
                    Element argElem = (Element)argNodes.item(i);
                    String argStr = null;
                    argStr = Boolean.valueOf(argElem.getAttribute("isDataFile").toLowerCase()) != false ? "<DATA_FILE_PLACE_HOLDER>" : (Boolean.valueOf(argElem.getAttribute("isMetFile").toLowerCase()) != false ? "<MET_FILE_PLACE_HOLDER>" : XMLUtils.getSimpleElementText((Element)argElem));
                    String appendExt = null;
                    appendExt = argElem.getAttribute("appendExt");
                    if (!appendExt.equals("")) {
                        argStr = argStr + "." + appendExt;
                    }
                    if (Boolean.valueOf(argElem.getAttribute("envReplace")).booleanValue()) {
                        argStr = PathUtils.replaceEnvVariables(argStr);
                    }
                    if (Boolean.valueOf(argElem.getAttribute("isPath")).booleanValue()) {
                        argStr = argStr.replaceAll("\\s", "\\\\ ");
                    }
                    argVector.add(argStr);
                }
                config.setArgList(argVector.toArray(new String[0]));
            }
            return config;
        }
        catch (Exception e) {
            throw new MetExtractorConfigReaderException("Failed to parser '" + file + "' : " + e.getMessage());
        }
    }
}

