/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.extractors;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.oodt.cas.metadata.AbstractMetExtractor;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.cas.metadata.exceptions.MetExtractionException;
import org.apache.oodt.cas.metadata.extractors.DataSourceMetExtractorConfig;
import org.apache.oodt.cas.metadata.extractors.DataSourceMetExtractorConfigReader;
import org.apache.oodt.commons.database.DatabaseConnectionBuilder;

public class DataSourceMetExtractor
extends AbstractMetExtractor {
    public DataSourceMetExtractor() {
        super(new DataSourceMetExtractorConfigReader());
    }

    @Override
    protected Metadata extrMetadata(File file) throws MetExtractionException {
        String key = this.getKey(file);
        DataSourceMetExtractorConfig dsConfig = (DataSourceMetExtractorConfig)this.config;
        DataSource dataSource = DatabaseConnectionBuilder.buildDataSource((String)dsConfig.getUserName(), (String)dsConfig.getPassword(), (String)dsConfig.getDriver(), (String)dsConfig.getDatabaseUrl());
        return this.getMetadata(dataSource, dsConfig.getQuery(), key);
    }

    @VisibleForTesting
    protected String getKey(File file) {
        return (String)Splitter.on((String)".").split((CharSequence)file.getName()).iterator().next();
    }

    @VisibleForTesting
    protected Metadata getMetadata(DataSource dataSource, String query, String key) throws MetExtractionException {
        String sqlQuery = String.format(query, key);
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = dataSource.getConnection();
            statement = conn.createStatement();
            rs = statement.executeQuery(sqlQuery);
            Metadata metadata = this.getMetadata(rs);
            return metadata;
        }
        catch (SQLException e) {
            throw new MetExtractionException(String.format("Failed to get metadaata for key '%s'", key), e);
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
            try {
                rs.close();
            }
            catch (Exception e) {}
        }
    }

    private Metadata getMetadata(ResultSet rs) throws SQLException {
        Metadata metadata = new Metadata();
        if (rs.next()) {
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                String metKey = rs.getMetaData().getColumnName(i + 1);
                String metVal = rs.getString(i + 1);
                metadata.addMetadata(metKey, metVal);
            }
        } else {
            throw new SQLException("Failed to find metadata for result set");
        }
        return metadata;
    }
}

