/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.util;

import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.oodt.cas.metadata.util.PathUtils;

public final class PropertiesUtils {
    public static String[] getProperties(String property, String[] defaultValues) {
        String[] values = PropertiesUtils.getProperties(property);
        if (values.length < 1) {
            values = new String[defaultValues.length];
            System.arraycopy(defaultValues, 0, values, 0, defaultValues.length);
        }
        return values;
    }

    public static String[] getProperties(String property) {
        Vector<String> propList = new Vector<String>();
        StringTokenizer st = new StringTokenizer(System.getProperty(property, ""), ",");
        while (st.hasMoreTokens()) {
            propList.add(PathUtils.replaceEnvVariables(st.nextToken().trim()));
        }
        return propList.toArray(new String[propList.size()]);
    }

    public static String getProperty(String property, String defaultValue) {
        return PropertiesUtils.getProperties(property, new String[]{defaultValue})[0];
    }

    public static String getProperty(String property) {
        return PropertiesUtils.getProperties(property)[0];
    }
}

