/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.extractors;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.cas.metadata.exceptions.MetExtractionException;
import org.apache.oodt.cas.metadata.exceptions.MetExtractorConfigReaderException;
import org.apache.oodt.cas.metadata.extractors.AbstractSAXConfigReader;
import org.apache.oodt.cas.metadata.extractors.CmdLineMetExtractor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProdTypePatternMetExtractor
extends CmdLineMetExtractor {
    private static final String PRODUCT_TYPE_MET_KEY = "ProductType";

    public ProdTypePatternMetExtractor() {
        super(new ConfigReader());
    }

    @Override
    protected Metadata extrMetadata(File file) throws MetExtractionException {
        Metadata met = new Metadata();
        ConfigReader mConfig = (ConfigReader)this.config;
        for (Pattern p : mConfig.getProdTypePatterns().keySet()) {
            Matcher m = p.matcher(file.getName());
            if (!m.matches()) continue;
            String prodType = mConfig.getProdTypePatterns().get(p);
            met.addMetadata(PRODUCT_TYPE_MET_KEY, prodType);
            List<String> elemList = mConfig.getProdTypeElements().get(prodType);
            for (int i = 0; i < m.groupCount(); ++i) {
                met.addMetadata(elemList.get(i), m.group(i + 1));
            }
        }
        return met;
    }

    public static void main(String[] args) throws Exception {
        ProdTypePatternMetExtractor.processMain(args, new ProdTypePatternMetExtractor());
    }

    static class ConfigReader
    extends AbstractSAXConfigReader {
        private static final String ELEMENT_TAG = "element";
        private static final String ELEMENT_NAME_ATTR = "name";
        private static final String ELEMENT_REGEXP_ATTR = "regexp";
        private static final String PRODUCT_TYPE_TAG = "product-type";
        private static final String PRODUCT_TYPE_NAME_ATTR = "name";
        private static final String PRODUCT_TYPE_TEMPLATE_ATTR = "template";
        private static final Pattern MET_TOKEN = Pattern.compile("\\[([A-Za-z]*)\\]");
        private final Map<Pattern, String> prodTypePatterns = new HashMap<Pattern, String>();
        private final Map<String, List<String>> prodTypeElements = new HashMap<String, List<String>>();
        private final Map<String, Pattern> elementPatterns = new HashMap<String, Pattern>();

        ConfigReader() {
        }

        Map<Pattern, String> getProdTypePatterns() {
            return this.prodTypePatterns;
        }

        Map<String, List<String>> getProdTypeElements() {
            return this.prodTypeElements;
        }

        void addProductType(String id, String template) {
            template = template.replaceAll("\\.", "\\\\.");
            Matcher m = MET_TOKEN.matcher(template);
            List<String> elemList = this.prodTypeElements.get(id);
            if (elemList == null) {
                elemList = new ArrayList<String>();
                this.prodTypeElements.put(id, elemList);
            }
            String newTemplate = template;
            while (m.find()) {
                String elem = m.group(1);
                String regex = this.elementPatterns.get(elem).toString();
                newTemplate = newTemplate.replaceAll("\\[" + elem + "\\]", "(" + regex + ")");
                elemList.add(elem);
            }
            this.prodTypePatterns.put(Pattern.compile(newTemplate), id);
        }

        void addElement(String name, String regexp) {
            this.elementPatterns.put(name, Pattern.compile(regexp));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(ELEMENT_TAG)) {
                String name = attributes.getValue("name");
                String regexp = attributes.getValue(ELEMENT_REGEXP_ATTR);
                this.addElement(name, regexp);
            } else if (qName.equals(PRODUCT_TYPE_TAG)) {
                String id = attributes.getValue("name");
                String template = attributes.getValue(PRODUCT_TYPE_TEMPLATE_ATTR);
                this.addProductType(id, template);
            }
        }

        @Override
        public AbstractSAXConfigReader parseConfigFile(File configFile) throws MetExtractorConfigReaderException {
            this.prodTypePatterns.clear();
            this.prodTypeElements.clear();
            this.elementPatterns.clear();
            return super.parseConfigFile(configFile);
        }
    }
}

