/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.preconditions;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.oodt.cas.metadata.preconditions.PreConditionComparator;
import org.apache.oodt.cas.metadata.preconditions.PreConditionOperatorMetKeys;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreCondEvalUtils
implements PreConditionOperatorMetKeys {
    private static Logger LOG = Logger.getLogger(PreCondEvalUtils.class.getName());
    private static ApplicationContext applicationContext;

    public PreCondEvalUtils(ApplicationContext applicationContext) {
        PreCondEvalUtils.applicationContext = applicationContext;
    }

    public boolean eval(List<String> preCondComparatorIds, File product) {
        for (String preCondComparatorId : preCondComparatorIds) {
            if (!((PreConditionComparator)applicationContext.getBean(preCondComparatorId, PreConditionComparator.class)).passes(product)) {
                LOG.log(Level.INFO, "Failed precondition comparator id " + preCondComparatorId);
                return false;
            }
            LOG.log(Level.INFO, "Passed precondition comparator id " + preCondComparatorId);
        }
        return true;
    }
}

