/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.extractors;

import java.io.File;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Logger;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.cas.metadata.exceptions.MetExtractionException;
import org.apache.oodt.cas.metadata.extractors.CmdLineMetExtractor;
import org.apache.oodt.cas.metadata.extractors.FilenameTokenConfig;
import org.apache.oodt.cas.metadata.extractors.FilenameTokenConfigReader;
import org.apache.oodt.cas.metadata.extractors.FilenameTokenExtractorMetKeys;
import org.apache.oodt.commons.date.DateUtils;

public class FilenameTokenMetExtractor
extends CmdLineMetExtractor
implements FilenameTokenExtractorMetKeys {
    private static final Logger LOG = Logger.getLogger(FilenameTokenMetExtractor.class.getName());

    public FilenameTokenMetExtractor() {
        super(new FilenameTokenConfigReader());
    }

    protected Metadata extrMetadata(File file) throws MetExtractionException {
        Metadata met = new Metadata();
        String filename = file.getName();
        if (((FilenameTokenConfig)this.config).hasTokenNameList()) {
            List<String> metKeyTokens = ((FilenameTokenConfig)this.config).getTokenMetKeyNames();
            String[] filenameToks = filename.split("\\.")[0].split(((FilenameTokenConfig)this.config).getTokenDelimeterScalar());
            for (int i = 0; i < filenameToks.length; ++i) {
                String keyName = metKeyTokens.get(i);
                String keyVal = filenameToks[i];
                if (keyName.equals("ProductionDateTime")) {
                    Calendar cal = GregorianCalendar.getInstance();
                    try {
                        cal.setTime(((FilenameTokenConfig)this.config).getDateFormatter().parse(keyVal));
                    }
                    catch (ParseException e) {
                        throw new MetExtractionException(e.getMessage());
                    }
                    keyVal = DateUtils.toString((Calendar)cal);
                }
                met.addMetadata(keyName, keyVal);
            }
        }
        Metadata commonMet = ((FilenameTokenConfig)this.config).getCommonMet();
        met.addMetadata(commonMet.getHashtable());
        met.addMetadata(((FilenameTokenConfig)this.config).getSubstringOffsetMet(file));
        met.addMetadata("Filename", file.getName());
        met.addMetadata("FileLocation", file.getParentFile().getAbsolutePath());
        return met;
    }

    public static void main(String[] args) throws Exception {
        FilenameTokenMetExtractor.processMain(args, new FilenameTokenMetExtractor());
    }
}

