/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.preconditions;

import java.io.File;
import org.apache.oodt.cas.metadata.exceptions.MetExtractionException;
import org.apache.oodt.cas.metadata.exceptions.PreconditionComparatorException;
import org.apache.oodt.commons.spring.SpringSetIdInjectionType;
import org.springframework.beans.factory.annotation.Required;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PreConditionComparator<CompareType>
implements SpringSetIdInjectionType {
    private String fileExtension;
    private String type;
    private CompareType compareItem;
    private String description;
    private String id;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean passes(File product) {
        try {
            if (this.fileExtension != null) {
                product = new File(product.getAbsolutePath() + "." + this.fileExtension);
            }
            return PreConditionComparator.eval(this.type, this.performCheck(product, this.compareItem));
        }
        catch (Exception e) {
            return false;
        }
    }

    protected abstract int performCheck(File var1, CompareType var2) throws PreconditionComparatorException;

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    @Required
    public void setType(String type) {
        this.type = type;
    }

    @Required
    public void setCompareItem(CompareType compareItem) {
        this.compareItem = compareItem;
    }

    private static boolean eval(String opKey, int preconditionResult) throws MetExtractionException {
        opKey = opKey.toUpperCase();
        if (preconditionResult == 0) {
            return "EQUAL_TO".equals(opKey);
        }
        if (preconditionResult > 0) {
            return "NOT_EQUAL_TO".equals(opKey) || "GREATER_THAN".equals(opKey);
        }
        if (preconditionResult < 0) {
            return "NOT_EQUAL_TO".equals(opKey) || "LESS_THAN".equals(opKey);
        }
        throw new MetExtractionException("evalType is not a valid type");
    }
}

