/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.extractors;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.cas.metadata.exceptions.MetExtractionException;
import org.apache.oodt.cas.metadata.extractors.CmdLineMetExtractor;
import org.apache.oodt.cas.metadata.extractors.FilenameTokenConfig;
import org.apache.oodt.cas.metadata.extractors.FilenameTokenConfigReader;
import org.apache.oodt.cas.metadata.extractors.FilenameTokenExtractorMetKeys;
import org.apache.oodt.cas.metadata.util.PathUtils;
import org.apache.oodt.pcs.input.PGEConfigurationFile;
import org.apache.oodt.pcs.input.PGEGroup;
import org.apache.oodt.pcs.input.PGEScalar;
import org.apache.oodt.pcs.input.PGEVector;

public class FilenameTokenMetExtractor
extends CmdLineMetExtractor
implements FilenameTokenExtractorMetKeys {
    private static final Logger LOG = Logger.getLogger(FilenameTokenMetExtractor.class.getName());

    public FilenameTokenMetExtractor() {
        super(new FilenameTokenConfigReader());
    }

    protected Metadata extrMetadata(File file) throws MetExtractionException {
        Metadata met = this.getCoreMet(file);
        this.addCommonMetadata(met);
        return met;
    }

    public static void main(String[] args) throws Exception {
        FilenameTokenMetExtractor.processMain(args, new FilenameTokenMetExtractor());
    }

    private Metadata getCoreMet(File file) {
        PGEGroup substrOffsetGroup = (PGEGroup)this.getConf().getPgeSpecificGroups().get("SubstringOffsetGroup");
        Metadata met = new Metadata();
        String filename = file.getName();
        for (PGEVector vec : substrOffsetGroup.getVectors().values()) {
            String metKeyName = vec.getName();
            LOG.log(Level.FINE, "Extracting key: [" + metKeyName + "]");
            int offset = Integer.valueOf((String)vec.getElements().get(0)) - 1;
            int length = Integer.valueOf((String)vec.getElements().get(1));
            String metVal = filename.substring(offset, offset + length).trim();
            met.addMetadata(metKeyName, metVal);
        }
        return met;
    }

    private void addCommonMetadata(Metadata met) {
        PGEGroup commonMetGroup = (PGEGroup)this.getConf().getPgeSpecificGroups().get("CommonMetadata");
        for (PGEScalar metScalar : commonMetGroup.getScalars().values()) {
            met.addMetadata(metScalar.getName(), PathUtils.replaceEnvVariables(metScalar.getValue(), met));
        }
    }

    private PGEConfigurationFile getConf() {
        return ((FilenameTokenConfig)this.config).getConf();
    }
}

