/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.extractors;

import java.io.File;
import java.util.logging.Level;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.cas.metadata.SerializableMetadata;
import org.apache.oodt.cas.metadata.exceptions.MetExtractionException;
import org.apache.oodt.cas.metadata.extractors.CmdLineMetExtractor;
import org.apache.oodt.cas.metadata.extractors.CopyAndRewriteConfig;
import org.apache.oodt.cas.metadata.extractors.CopyAndRewriteConfigReader;
import org.apache.oodt.cas.metadata.util.PathUtils;

public class CopyAndRewriteExtractor
extends CmdLineMetExtractor {
    private static final String FILENAME = "Filename";
    private static final String FILE_LOCATION = "FileLocation";
    private static CopyAndRewriteConfigReader reader = new CopyAndRewriteConfigReader();

    public CopyAndRewriteExtractor() {
        super(reader);
    }

    public Metadata extrMetadata(File file) throws MetExtractionException {
        if (this.config == null) {
            throw new MetExtractionException("No config file defined: unable to copy and rewrite metadata!");
        }
        SerializableMetadata met = null;
        try {
            met = new SerializableMetadata(new File(PathUtils.replaceEnvVariables(((CopyAndRewriteConfig)this.config).getProperty("orig.met.file.path"))).toURL().openStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetExtractionException("error parsing original met file: [" + ((CopyAndRewriteConfig)this.config).getProperty("orig.met.file.path") + "]: Message: " + e.getMessage());
        }
        this.addDefaultFields(file, met);
        int numOverrideFields = Integer.parseInt(((CopyAndRewriteConfig)this.config).getProperty("numRewriteFields"));
        LOG.log(Level.FINE, "Extracting metadata: num rewrite fields: [" + numOverrideFields + "]");
        for (int i = 0; i < numOverrideFields; ++i) {
            String rewriteFieldName = ((CopyAndRewriteConfig)this.config).getProperty("rewriteField" + (i + 1));
            String rewriteFieldStr = ((CopyAndRewriteConfig)this.config).getProperty(rewriteFieldName + ".pattern");
            LOG.log(Level.FINE, "Rewrite string: [" + rewriteFieldStr + "]");
            rewriteFieldStr = PathUtils.replaceEnvVariables(rewriteFieldStr, met);
            met.replaceMetadata(rewriteFieldName, rewriteFieldStr);
        }
        return met;
    }

    public static void main(String[] args) throws Exception {
        CopyAndRewriteExtractor.processMain(args, new CopyAndRewriteExtractor());
    }

    private void addDefaultFields(File file, Metadata met) {
        met.replaceMetadata(FILENAME, file.getName());
        met.replaceMetadata(FILE_LOCATION, file.getParentFile().getAbsolutePath());
    }
}

