/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ODataServiceVersion {
    private static final Pattern DATASERVICEVERSIONPATTERN = Pattern.compile("(\\p{Digit}+\\.\\p{Digit}+)(:?;.*)?");
    public static final String V10 = "1.0";
    public static final String V20 = "2.0";
    public static final String V30 = "3.0";

    public static boolean validateDataServiceVersion(String version) {
        Matcher matcher = DATASERVICEVERSIONPATTERN.matcher(version);
        if (matcher.matches()) {
            String possibleDataServiceVersion = matcher.group(1);
            return V10.equals(possibleDataServiceVersion) || V20.equals(possibleDataServiceVersion) || V30.equals(possibleDataServiceVersion);
        }
        throw new IllegalArgumentException(version);
    }

    public static boolean isBiggerThan(String actual, String comparedTo) {
        double other;
        if (!ODataServiceVersion.validateDataServiceVersion(comparedTo) || !ODataServiceVersion.validateDataServiceVersion(actual)) {
            throw new IllegalArgumentException("Illegal arguments: " + comparedTo + " and " + actual);
        }
        double me = Double.parseDouble(ODataServiceVersion.extractDataServiceVersionString(actual));
        return me > (other = Double.parseDouble(ODataServiceVersion.extractDataServiceVersionString(comparedTo)));
    }

    private static String extractDataServiceVersionString(String rawDataServiceVersion) {
        if (rawDataServiceVersion != null) {
            String[] pattern = rawDataServiceVersion.split(";");
            return pattern[0];
        }
        return null;
    }
}

