/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.olingo.odata2.api.edm;

/**
 * @org.apache.olingo.odata2.DoNotImplement
 * EdmTargetPath specifies the possible default targets for an EDM property which is mapped to an atom element.
 * 
 */
public class EdmTargetPath {

  public static final String SYNDICATION_AUTHORNAME = "SyndicationAuthorName";
  public static final String SYNDICATION_AUTHOREMAIL = "SyndicationAuthorEmail";
  public static final String SYNDICATION_AUTHORURI = "SyndicationAuthorUri";
  public static final String SYNDICATION_PUBLISHED = "SyndicationPublished";
  public static final String SYNDICATION_RIGHTS = "SyndicationRights";
  public static final String SYNDICATION_TITLE = "SyndicationTitle";
  public static final String SYNDICATION_UPDATED = "SyndicationUpdated";
  public static final String SYNDICATION_CONTRIBUTORNAME = "SyndicationContributorName";
  public static final String SYNDICATION_CONTRIBUTOREMAIL = "SyndicationContributorEmail";
  public static final String SYNDICATION_CONTRIBUTORURI = "SyndicationContributorUri";
  public static final String SYNDICATION_SOURCE = "SyndicationSource";
  public static final String SYNDICATION_SUMMARY = "SyndicationSummary";
}
