/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.tecsvc;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.edm.provider.EdmProvider;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.tecsvc.data.DataProvider;
import org.apache.olingo.server.tecsvc.processor.TechnicalProcessor;
import org.apache.olingo.server.tecsvc.provider.EdmTechProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TechnicalServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(TechnicalServlet.class);

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            OData odata = OData.newInstance();
            Edm edm = odata.createEdm((EdmProvider)new EdmTechProvider());
            HttpSession session = req.getSession(true);
            DataProvider dataProvider = (DataProvider)session.getAttribute(DataProvider.class.getName());
            if (dataProvider == null) {
                dataProvider = new DataProvider(edm);
                session.setAttribute(DataProvider.class.getName(), (Object)dataProvider);
                LOG.info("Created new data provider.");
            }
            ODataHttpHandler handler = odata.createHandler(edm);
            handler.register((Processor)new TechnicalProcessor(dataProvider));
            handler.process(req, resp);
        }
        catch (Exception e) {
            LOG.error("Server Error", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }
}

