/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.validator;

import java.util.HashMap;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourceSingleton;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;
import org.apache.olingo.server.core.uri.validator.UriValidationException;
import org.apache.olingo.server.core.uri.validator.UriValidator;

public class UriValidator {
    private boolean[][] decisionMatrix = new boolean[][]{{true, true, true, false, true, true, true, true, true, true, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, false, true, true, true, true, true, true, true, true}, {false, true, true, true, false, false, false, true, false, false, true, false}, {false, true, false, false, false, false, false, false, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false, false}, {true, true, true, false, true, true, true, true, true, true, true, true}, {true, false, false, false, false, false, true, false, false, false, false, false}, {false, true, true, false, false, false, false, true, false, false, true, false}, {false, true, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, true, true, false, true, true, false, true}, {false, true, false, false, false, false, false, false, false, false, false, false}, {false, true, true, false, false, false, false, true, false, false, true, false}, {true, true, true, false, true, true, false, false, true, true, true, true}, {true, false, false, false, false, false, true, false, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, true, false, false, true, true, false, true}, {true, false, false, false, false, false, true, false, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false, false}};
    private boolean[][] decisionMatrixForHttpMethod = new boolean[][]{{true, true, true, true, true, true, true, true, true, true, true, true}, {true, false, true, false, false, true, false, true, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false}};

    public void validate(UriInfo uriInfo, HttpMethod httpMethod) throws UriValidationException {
        this.validateForHttpMethod(uriInfo, httpMethod);
        this.validateQueryOptions(uriInfo);
        this.validateKeyPredicateTypes(uriInfo);
    }

    private ColumnIndex colIndex(SystemQueryOptionKind queryOptionKind) throws UriValidationException {
        ColumnIndex idx;
        switch (1.$SwitchMap$org$apache$olingo$server$api$uri$queryoption$SystemQueryOptionKind[queryOptionKind.ordinal()]) {
            case 1: {
                idx = ColumnIndex.filter;
                break;
            }
            case 2: {
                idx = ColumnIndex.format;
                break;
            }
            case 3: {
                idx = ColumnIndex.expand;
                break;
            }
            case 4: {
                idx = ColumnIndex.id;
                break;
            }
            case 5: {
                idx = ColumnIndex.count;
                break;
            }
            case 6: {
                idx = ColumnIndex.orderby;
                break;
            }
            case 7: {
                idx = ColumnIndex.search;
                break;
            }
            case 8: {
                idx = ColumnIndex.select;
                break;
            }
            case 9: {
                idx = ColumnIndex.skip;
                break;
            }
            case 10: {
                idx = ColumnIndex.skiptoken;
                break;
            }
            case 11: {
                idx = ColumnIndex.levels;
                break;
            }
            case 12: {
                idx = ColumnIndex.top;
                break;
            }
            default: {
                throw new UriValidationException("Unsupported option: " + queryOptionKind.toString(), (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.UNSUPPORTED_QUERY_OPTION, new String[]{queryOptionKind.toString()});
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForUriType(UriInfo uriInfo) throws UriValidationException {
        RowIndexForUriType idx;
        switch (1.$SwitchMap$org$apache$olingo$server$api$uri$UriInfoKind[uriInfo.getKind().ordinal()]) {
            case 1: {
                idx = RowIndexForUriType.all;
                break;
            }
            case 2: {
                idx = RowIndexForUriType.batch;
                break;
            }
            case 3: {
                idx = RowIndexForUriType.crossjoin;
                break;
            }
            case 4: {
                idx = RowIndexForUriType.entityId;
                break;
            }
            case 5: {
                idx = RowIndexForUriType.metadata;
                break;
            }
            case 6: {
                idx = this.rowIndexForResourceKind(uriInfo);
                break;
            }
            case 7: {
                idx = RowIndexForUriType.service;
                break;
            }
            default: {
                throw new UriValidationException("Unsupported uriInfo kind: " + uriInfo.getKind(), (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.UNSUPPORTED_URI_KIND, new String[]{uriInfo.getKind().toString()});
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForResourceKind(UriInfo uriInfo) throws UriValidationException {
        RowIndexForUriType idx;
        int lastPathSegmentIndex = uriInfo.getUriResourceParts().size() - 1;
        UriResource lastPathSegment = (UriResource)uriInfo.getUriResourceParts().get(lastPathSegmentIndex);
        switch (1.$SwitchMap$org$apache$olingo$server$api$uri$UriResourceKind[lastPathSegment.getKind().ordinal()]) {
            case 1: {
                idx = this.rowIndexForCount(uriInfo);
                break;
            }
            case 2: {
                idx = this.rowIndexForAction(lastPathSegment);
                break;
            }
            case 3: {
                idx = this.rowIndexForComplexProperty(lastPathSegment);
                break;
            }
            case 4: {
                idx = this.rowIndexForEntitySet(lastPathSegment);
                break;
            }
            case 5: {
                idx = this.rowIndexForFunction(lastPathSegment);
                break;
            }
            case 6: {
                idx = ((UriResourceNavigation)lastPathSegment).isCollection() ? RowIndexForUriType.entitySet : RowIndexForUriType.entity;
                break;
            }
            case 7: {
                idx = this.rowIndexForPrimitiveProperty(lastPathSegment);
                break;
            }
            case 8: {
                idx = this.rowIndexForRef(uriInfo, lastPathSegment);
                break;
            }
            case 9: {
                idx = RowIndexForUriType.service;
                break;
            }
            case 10: {
                idx = RowIndexForUriType.entity;
                break;
            }
            case 11: {
                idx = this.rowIndexForValue(uriInfo);
                break;
            }
            default: {
                throw new UriValidationException("Unsupported uriResource kind: " + lastPathSegment.getKind(), (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.UNSUPPORTED_URI_RESOURCE_KIND, new String[]{lastPathSegment.getKind().toString()});
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForValue(UriInfo uriInfo) throws UriValidationException {
        RowIndexForUriType idx;
        int secondLastPathSegmentIndex = uriInfo.getUriResourceParts().size() - 2;
        UriResource secondLastPathSegment = (UriResource)uriInfo.getUriResourceParts().get(secondLastPathSegmentIndex);
        switch (1.$SwitchMap$org$apache$olingo$server$api$uri$UriResourceKind[secondLastPathSegment.getKind().ordinal()]) {
            case 7: {
                idx = RowIndexForUriType.propertyPrimitiveValue;
                break;
            }
            case 4: {
                idx = RowIndexForUriType.mediaStream;
                break;
            }
            case 5: {
                EdmFunction function;
                UriResourceFunction uriFunction = (UriResourceFunction)secondLastPathSegment;
                EdmFunctionImport functionImport = uriFunction.getFunctionImport();
                if (functionImport != null) {
                    List functions = functionImport.getUnboundFunctions();
                    function = (EdmFunction)functions.get(0);
                } else {
                    function = uriFunction.getFunction();
                }
                EdmTypeKind functionReturnTypeKind = function.getReturnType().getType().getKind();
                boolean isFunctionCollection = function.getReturnType().isCollection();
                idx = this.determineReturnType(functionReturnTypeKind, isFunctionCollection);
                break;
            }
            case 2: {
                UriResourceAction uriAction = (UriResourceAction)secondLastPathSegment;
                EdmActionImport actionImport = uriAction.getActionImport();
                EdmAction action = actionImport != null ? actionImport.getUnboundAction() : uriAction.getAction();
                EdmTypeKind actionReturnTypeKind = action.getReturnType().getType().getKind();
                boolean isActionCollection = action.getReturnType().isCollection();
                idx = this.determineReturnType(actionReturnTypeKind, isActionCollection);
                break;
            }
            case 6: {
                UriResourceNavigation uriNavigation = (UriResourceNavigation)secondLastPathSegment;
                if (uriNavigation.isCollection()) {
                    idx = RowIndexForUriType.entitySet;
                    break;
                }
                idx = RowIndexForUriType.entity;
                break;
            }
            case 10: {
                UriResourceSingleton uriSingleton = (UriResourceSingleton)secondLastPathSegment;
                EdmSingleton singleton = uriSingleton.getSingleton();
                EdmTypeKind singletonReturnTypeKind = singleton.getEntityType().getKind();
                idx = this.determineReturnType(singletonReturnTypeKind, false);
                break;
            }
            default: {
                throw new UriValidationException("Unexpected kind in path segment before $value: " + secondLastPathSegment.getKind(), (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.UNALLOWED_KIND_BEFORE_VALUE, new String[]{secondLastPathSegment.toString()});
            }
        }
        return idx;
    }

    private RowIndexForUriType determineReturnType(EdmTypeKind functionReturnTypeKind, boolean isCollection) throws UriValidationException {
        RowIndexForUriType idx;
        switch (1.$SwitchMap$org$apache$olingo$commons$api$edm$constants$EdmTypeKind[functionReturnTypeKind.ordinal()]) {
            case 1: {
                idx = isCollection ? RowIndexForUriType.propertyComplexCollection : RowIndexForUriType.propertyComplex;
                break;
            }
            case 2: {
                idx = isCollection ? RowIndexForUriType.entitySet : RowIndexForUriType.entity;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                idx = isCollection ? RowIndexForUriType.propertyPrimitiveCollection : RowIndexForUriType.propertyPrimitive;
                break;
            }
            default: {
                throw new UriValidationException("Unsupported function return type: " + functionReturnTypeKind, (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.UNSUPPORTED_FUNCTION_RETURN_TYPE, new String[]{functionReturnTypeKind.toString()});
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForRef(UriInfo uriInfo, UriResource lastPathSegment) throws UriValidationException {
        int secondLastPathSegmentIndex = uriInfo.getUriResourceParts().size() - 2;
        UriResource secondLastPathSegment = (UriResource)uriInfo.getUriResourceParts().get(secondLastPathSegmentIndex);
        if (!(secondLastPathSegment instanceof UriResourcePartTyped)) {
            throw new UriValidationException("secondLastPathSegment not a class of UriResourcePartTyped: " + lastPathSegment.getClass(), (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.LAST_SEGMENT_NOT_TYPED, new String[]{lastPathSegment.toString()});
        }
        RowIndexForUriType idx = ((UriResourcePartTyped)secondLastPathSegment).isCollection() ? RowIndexForUriType.references : RowIndexForUriType.reference;
        return idx;
    }

    private RowIndexForUriType rowIndexForPrimitiveProperty(UriResource lastPathSegment) throws UriValidationException {
        if (!(lastPathSegment instanceof UriResourcePartTyped)) {
            throw new UriValidationException("lastPathSegment not a class of UriResourcePartTyped: " + lastPathSegment.getClass(), (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.LAST_SEGMENT_NOT_TYPED, new String[]{lastPathSegment.toString()});
        }
        RowIndexForUriType idx = ((UriResourcePartTyped)lastPathSegment).isCollection() ? RowIndexForUriType.propertyPrimitiveCollection : RowIndexForUriType.propertyPrimitive;
        return idx;
    }

    private RowIndexForUriType rowIndexForFunction(UriResource lastPathSegment) throws UriValidationException {
        RowIndexForUriType idx;
        UriResourceFunction urf = (UriResourceFunction)lastPathSegment;
        EdmReturnType rt = urf.getFunction().getReturnType();
        switch (1.$SwitchMap$org$apache$olingo$commons$api$edm$constants$EdmTypeKind[rt.getType().getKind().ordinal()]) {
            case 2: {
                if (((EdmEntityType)rt.getType()).hasStream()) {
                    idx = RowIndexForUriType.mediaStream;
                    break;
                }
                idx = rt.isCollection() ? RowIndexForUriType.entitySet : RowIndexForUriType.entity;
                break;
            }
            case 3: {
                idx = rt.isCollection() ? RowIndexForUriType.propertyPrimitiveCollection : RowIndexForUriType.propertyPrimitive;
                break;
            }
            case 1: {
                idx = rt.isCollection() ? RowIndexForUriType.propertyComplexCollection : RowIndexForUriType.propertyComplex;
                break;
            }
            default: {
                throw new UriValidationException("Unsupported function return type: " + rt.getType().getKind(), (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.UNSUPPORTED_FUNCTION_RETURN_TYPE, new String[]{rt.getType().getKind().toString()});
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForEntitySet(UriResource lastPathSegment) throws UriValidationException {
        if (!(lastPathSegment instanceof UriResourcePartTyped)) {
            throw new UriValidationException("lastPathSegment not a class of UriResourcePartTyped: " + lastPathSegment.getClass(), (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.LAST_SEGMENT_NOT_TYPED, new String[]{lastPathSegment.toString()});
        }
        RowIndexForUriType idx = ((UriResourcePartTyped)lastPathSegment).isCollection() ? RowIndexForUriType.entitySet : RowIndexForUriType.entity;
        return idx;
    }

    private RowIndexForUriType rowIndexForComplexProperty(UriResource lastPathSegment) throws UriValidationException {
        if (!(lastPathSegment instanceof UriResourcePartTyped)) {
            throw new UriValidationException("lastPathSegment not a class of UriResourcePartTyped: " + lastPathSegment.getClass(), (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.LAST_SEGMENT_NOT_TYPED, new String[]{lastPathSegment.toString()});
        }
        RowIndexForUriType idx = ((UriResourcePartTyped)lastPathSegment).isCollection() ? RowIndexForUriType.propertyComplexCollection : RowIndexForUriType.propertyComplex;
        return idx;
    }

    private RowIndexForUriType rowIndexForAction(UriResource lastPathSegment) throws UriValidationException {
        RowIndexForUriType idx;
        UriResourceAction ura = (UriResourceAction)lastPathSegment;
        EdmReturnType rt = ura.getAction().getReturnType();
        switch (1.$SwitchMap$org$apache$olingo$commons$api$edm$constants$EdmTypeKind[rt.getType().getKind().ordinal()]) {
            case 2: {
                if (((EdmEntityType)rt.getType()).hasStream()) {
                    idx = RowIndexForUriType.mediaStream;
                    break;
                }
                idx = rt.isCollection() ? RowIndexForUriType.entitySet : RowIndexForUriType.entity;
                break;
            }
            case 3: {
                idx = rt.isCollection() ? RowIndexForUriType.propertyPrimitiveCollection : RowIndexForUriType.propertyPrimitive;
                break;
            }
            case 1: {
                idx = rt.isCollection() ? RowIndexForUriType.propertyComplexCollection : RowIndexForUriType.propertyComplex;
                break;
            }
            default: {
                throw new UriValidationException("Unsupported action return type: " + rt.getType().getKind(), (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.UNSUPPORTED_ACTION_RETURN_TYPE, new String[]{rt.getType().getKind().toString()});
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForCount(UriInfo uriInfo) throws UriValidationException {
        RowIndexForUriType idx;
        int secondLastPathSegmentIndex = uriInfo.getUriResourceParts().size() - 2;
        UriResource secondLastPathSegment = (UriResource)uriInfo.getUriResourceParts().get(secondLastPathSegmentIndex);
        switch (1.$SwitchMap$org$apache$olingo$server$api$uri$UriResourceKind[secondLastPathSegment.getKind().ordinal()]) {
            case 4: {
                idx = RowIndexForUriType.entitySetCount;
                break;
            }
            case 3: {
                idx = RowIndexForUriType.propertyComplexCollectionCount;
                break;
            }
            case 7: {
                idx = RowIndexForUriType.propertyPrimitiveCollectionCount;
                break;
            }
            case 5: {
                EdmFunction function;
                UriResourceFunction uriFunction = (UriResourceFunction)secondLastPathSegment;
                EdmFunctionImport functionImport = uriFunction.getFunctionImport();
                if (functionImport != null) {
                    List functions = functionImport.getUnboundFunctions();
                    function = (EdmFunction)functions.get(0);
                } else {
                    function = uriFunction.getFunction();
                }
                EdmTypeKind functionReturnTypeKind = function.getReturnType().getType().getKind();
                boolean isCollection = function.getReturnType().isCollection();
                idx = this.determineReturnType(functionReturnTypeKind, isCollection);
                break;
            }
            default: {
                throw new UriValidationException("Illegal path part kind before $count: " + secondLastPathSegment.getKind(), (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.UNALLOWED_KIND_BEFORE_COUNT, new String[]{secondLastPathSegment.toString()});
            }
        }
        return idx;
    }

    private void validateQueryOptions(UriInfo uriInfo) throws UriValidationException {
        RowIndexForUriType row = this.rowIndexForUriType(uriInfo);
        for (SystemQueryOption option : uriInfo.getSystemQueryOptions()) {
            ColumnIndex col = this.colIndex(option.getKind());
            if (this.decisionMatrix[row.getIndex()][col.getIndex()]) continue;
            throw new UriValidationException("System query option not allowed: " + option.getName(), (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.SYSTEM_QUERY_OPTION_NOT_ALLOWED, new String[]{option.getName()});
        }
    }

    private void validateForHttpMethod(UriInfo uriInfo, HttpMethod httpMethod) throws UriValidationException {
        RowIndexForHttpMethod row = this.rowIndexForHttpMethod(httpMethod);
        for (SystemQueryOption option : uriInfo.getSystemQueryOptions()) {
            ColumnIndex col = this.colIndex(option.getKind());
            if (this.decisionMatrixForHttpMethod[row.getIndex()][col.getIndex()]) continue;
            throw new UriValidationException("System query option " + option.getName() + " not allowed for method " + httpMethod, (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.SYSTEM_QUERY_OPTION_NOT_ALLOWED_FOR_HTTP_METHOD, new String[]{option.getName(), httpMethod.toString()});
        }
    }

    private RowIndexForHttpMethod rowIndexForHttpMethod(HttpMethod httpMethod) throws UriValidationException {
        RowIndexForHttpMethod idx;
        switch (1.$SwitchMap$org$apache$olingo$commons$api$http$HttpMethod[httpMethod.ordinal()]) {
            case 1: {
                idx = RowIndexForHttpMethod.GET;
                break;
            }
            case 2: {
                idx = RowIndexForHttpMethod.POST;
                break;
            }
            case 3: {
                idx = RowIndexForHttpMethod.PUT;
                break;
            }
            case 4: {
                idx = RowIndexForHttpMethod.DELETE;
                break;
            }
            case 5: {
                idx = RowIndexForHttpMethod.PATCH;
                break;
            }
            case 6: {
                idx = RowIndexForHttpMethod.MERGE;
                break;
            }
            default: {
                throw new UriValidationException("HTTP method not supported: " + httpMethod, (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.UNSUPPORTED_HTTP_METHOD, new String[]{httpMethod.toString()});
            }
        }
        return idx;
    }

    private void validateKeyPredicateTypes(UriInfo uriInfo) throws UriValidationException {
        try {
            for (UriResource pathSegment : uriInfo.getUriResourceParts()) {
                if (pathSegment.getKind() != UriResourceKind.entitySet) continue;
                UriResourceEntitySet pathEntitySet = (UriResourceEntitySet)pathSegment;
                EdmEntityType type = pathEntitySet.getEntityType();
                List keys = type.getKeyPropertyRefs();
                List keyPredicates = pathEntitySet.getKeyPredicates();
                if (null == keyPredicates) continue;
                HashMap<String, EdmKeyPropertyRef> edmKeys = new HashMap<String, EdmKeyPropertyRef>();
                for (EdmKeyPropertyRef key : keys) {
                    edmKeys.put(key.getKeyPropertyName(), key);
                    String alias = key.getAlias();
                    if (null == alias) continue;
                    edmKeys.put(alias, key);
                }
                for (UriParameter keyPredicate : keyPredicates) {
                    String edmLiteral;
                    EdmKeyPropertyRef edmKey;
                    String name = keyPredicate.getName();
                    String alias = keyPredicate.getAlias();
                    String value = keyPredicate.getText();
                    if (alias != null) {
                        value = uriInfo.getValueForAlias(alias);
                    }
                    if ((edmKey = (EdmKeyPropertyRef)edmKeys.get(name)) == null) {
                        throw new UriValidationException("Unknown key property: " + name, (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.INVALID_KEY_PROPERTY, new String[]{name});
                    }
                    EdmType edmType = edmKey.getProperty().getType();
                    EdmPrimitiveType edmPrimitiveType = (EdmPrimitiveType)edmType;
                    boolean isValid = edmPrimitiveType.validate(edmLiteral = edmPrimitiveType.fromUriLiteral(value), edmKey.getProperty().isNullable(), edmKey.getProperty().getMaxLength(), edmKey.getProperty().getPrecision(), edmKey.getProperty().getScale(), edmKey.getProperty().isUnicode());
                    if (isValid) continue;
                    throw new UriValidationException("PrimitiveTypeException", (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.INVALID_KEY_PROPERTY, new String[0]);
                }
            }
        }
        catch (EdmPrimitiveTypeException e) {
            throw new UriValidationException("PrimitiveTypeException", (Throwable)e, (ODataTranslatedException.MessageKey)UriValidationException.MessageKeys.INVALID_KEY_PROPERTY, new String[0]);
        }
    }
}

