/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.uri.UriInfoKind;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.expression.MethodKind;
import org.apache.olingo.server.core.uri.UriInfoImpl;
import org.apache.olingo.server.core.uri.UriParameterImpl;
import org.apache.olingo.server.core.uri.UriResourceActionImpl;
import org.apache.olingo.server.core.uri.UriResourceComplexPropertyImpl;
import org.apache.olingo.server.core.uri.UriResourceCountImpl;
import org.apache.olingo.server.core.uri.UriResourceEntitySetImpl;
import org.apache.olingo.server.core.uri.UriResourceFunctionImpl;
import org.apache.olingo.server.core.uri.UriResourceImpl;
import org.apache.olingo.server.core.uri.UriResourceItImpl;
import org.apache.olingo.server.core.uri.UriResourceLambdaAllImpl;
import org.apache.olingo.server.core.uri.UriResourceLambdaAnyImpl;
import org.apache.olingo.server.core.uri.UriResourceLambdaVarImpl;
import org.apache.olingo.server.core.uri.UriResourceNavigationPropertyImpl;
import org.apache.olingo.server.core.uri.UriResourcePrimitivePropertyImpl;
import org.apache.olingo.server.core.uri.UriResourceRefImpl;
import org.apache.olingo.server.core.uri.UriResourceRootImpl;
import org.apache.olingo.server.core.uri.UriResourceSingletonImpl;
import org.apache.olingo.server.core.uri.UriResourceStartingTypeFilterImpl;
import org.apache.olingo.server.core.uri.UriResourceTypedImpl;
import org.apache.olingo.server.core.uri.UriResourceValueImpl;
import org.apache.olingo.server.core.uri.UriResourceWithKeysImpl;
import org.apache.olingo.server.core.uri.antlr.UriParserBaseVisitor;
import org.apache.olingo.server.core.uri.antlr.UriParserParser;
import org.apache.olingo.server.core.uri.parser.UriContext;
import org.apache.olingo.server.core.uri.parser.UriParseTreeVisitor;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.queryoption.CountOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.ExpandItemImpl;
import org.apache.olingo.server.core.uri.queryoption.ExpandOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.FilterOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.LevelsOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.OrderByItemImpl;
import org.apache.olingo.server.core.uri.queryoption.OrderByOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.QueryOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SelectItemImpl;
import org.apache.olingo.server.core.uri.queryoption.SelectOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SkipOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SkipTokenOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SystemQueryOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.TopOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.BinaryImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.EnumerationImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.ExpressionImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.LiteralImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.MemberImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.MethodImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.TypeLiteralImpl;

public class UriParseTreeVisitor
extends UriParserBaseVisitor<Object> {
    public UriContext context = null;
    public Edm edm;
    public EdmEntityContainer edmEntityContainer;

    public UriParseTreeVisitor(Edm edm, UriContext context) {
        this.edm = edm;
        this.context = context;
        this.edmEntityContainer = edm.getEntityContainer(null);
    }

    protected Object aggregateResult(Object aggregate, Object nextResult) {
        if (aggregate != null) {
            return aggregate;
        }
        return nextResult;
    }

    private FullQualifiedName getFullNameFromContext(UriParserParser.NamespaceContext vNS, String odi) {
        String namespace = vNS.getText();
        namespace = namespace.substring(0, namespace.length() - 1);
        return new FullQualifiedName(namespace, odi);
    }

    private UriContext.LambdaVariables getLambdaVar(String odi) {
        for (UriContext.LambdaVariables item : this.context.allowedLambdaVariables) {
            if (!item.name.equals(odi)) continue;
            return item;
        }
        return null;
    }

    TypeInformation getTypeInformation(UriResource lastResourcePart) {
        TypeInformation typeInformation = new TypeInformation(this);
        if (lastResourcePart instanceof UriResourceWithKeysImpl) {
            UriResourceWithKeysImpl lastPartWithKeys = (UriResourceWithKeysImpl)lastResourcePart;
            typeInformation.type = lastPartWithKeys.getTypeFilterOnEntry() != null ? lastPartWithKeys.getTypeFilterOnEntry() : (lastPartWithKeys.getTypeFilterOnCollection() != null ? lastPartWithKeys.getTypeFilterOnCollection() : lastPartWithKeys.getType());
            typeInformation.isCollection = lastPartWithKeys.isCollection();
        } else if (lastResourcePart instanceof UriResourceTypedImpl) {
            UriResourceTypedImpl lastPartTyped = (UriResourceTypedImpl)lastResourcePart;
            typeInformation.type = lastPartTyped.getTypeFilter() != null ? lastPartTyped.getTypeFilter() : lastPartTyped.getType();
            typeInformation.isCollection = lastPartTyped.isCollection();
        }
        return typeInformation;
    }

    public UriResourceTypedImpl readResourcePathSegment(UriParserParser.PathSegmentContext ctx) {
        UriResourceFunctionImpl pathInfoFunction;
        FullQualifiedName fullBindingTypeName;
        EdmAction action;
        EdmComplexType filterComplexType;
        boolean checkFirst = false;
        if (this.context.contextUriInfo.getLastResourcePart() == null || this.context.contextUriInfo.getLastResourcePart() instanceof UriResourceRootImpl) {
            checkFirst = true;
        }
        String odi = ctx.vODI.getText();
        if (checkFirst && ctx.vNS == null) {
            EdmEntitySet edmEntitySet = this.edmEntityContainer.getEntitySet(odi);
            if (edmEntitySet != null) {
                UriResourceEntitySetImpl uriResource = new UriResourceEntitySetImpl().setEntitSet(edmEntitySet);
                this.context.contextUriInfo.addResourcePart((UriResourceImpl)uriResource);
                return null;
            }
            EdmSingleton edmSingleton = this.edmEntityContainer.getSingleton(odi);
            if (edmSingleton != null) {
                UriResourceSingletonImpl uriResource = new UriResourceSingletonImpl().setSingleton(edmSingleton);
                this.context.contextUriInfo.addResourcePart((UriResourceImpl)uriResource);
                return null;
            }
            EdmActionImport edmActionImport = this.edmEntityContainer.getActionImport(odi);
            if (edmActionImport != null) {
                UriResourceActionImpl uriResource = new UriResourceActionImpl().setActionImport(edmActionImport);
                this.context.contextUriInfo.addResourcePart((UriResourceImpl)uriResource);
                return null;
            }
            EdmFunctionImport edmFunctionImport = this.edmEntityContainer.getFunctionImport(odi);
            if (edmFunctionImport != null) {
                this.context.contextReadingFunctionParameters = true;
                List parameters = (List)((UriParserParser.NameValueOptListContext)ctx.vlNVO.get(0)).accept((ParseTreeVisitor)this);
                this.context.contextReadingFunctionParameters = false;
                ctx.vlNVO.remove(0);
                UriResourceFunctionImpl uriResource = new UriResourceFunctionImpl().setFunctionImport(edmFunctionImport, parameters);
                ArrayList<String> names = new ArrayList<String>();
                for (UriParameterImpl item : parameters) {
                    names.add(item.getName());
                }
                EdmFunction function = edmFunctionImport.getUnboundFunction(names);
                if (function == null) {
                    String tmp = "";
                    for (String name : names) {
                        tmp = tmp + (tmp.length() != 0 ? "," : "") + name;
                    }
                    throw this.wrap((UriParserException)new UriParserSemanticException("Function of functionimport '" + edmFunctionImport.getName() + "' with parameters [" + tmp + "] not found", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
                }
                uriResource.setFunction(edmFunctionImport.getUnboundFunction(names));
                this.context.contextUriInfo.addResourcePart((UriResourceImpl)uriResource);
                return null;
            }
        }
        TypeInformation source = null;
        UriResource lastResourcePart = this.context.contextUriInfo.getLastResourcePart();
        if (lastResourcePart == null) {
            if (this.context.contextTypes.size() == 0) {
                throw this.wrap((UriParserException)new UriParserSemanticException("Resource part '" + odi + "' can only applied on typed " + "resource parts", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            source = (TypeInformation)this.context.contextTypes.peek();
        } else {
            source = this.getTypeInformation(lastResourcePart);
            if (source.type == null) {
                throw this.wrap((UriParserException)new UriParserSemanticException("Resource part '" + odi + "' can only applied on typed " + "resource parts", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
        }
        if (ctx.vNS == null) {
            UriContext.LambdaVariables lVar = this.getLambdaVar(odi);
            if (lVar != null) {
                UriResourceLambdaVarImpl lambdaResource = new UriResourceLambdaVarImpl();
                lambdaResource.setVariableText(lVar.name);
                lambdaResource.setType(lVar.type);
                lambdaResource.setCollection(lVar.isCollection);
                this.context.contextUriInfo.addResourcePart((UriResourceImpl)lambdaResource);
                return null;
            }
            if (!(source.type instanceof EdmStructuredType)) {
                throw this.wrap((UriParserException)new UriParserSemanticException("Can not parse'" + odi + "'Previous path segment not a structural type.", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            EdmStructuredType structType = (EdmStructuredType)source.type;
            EdmElement property = structType.getProperty(odi);
            if (property == null) {
                throw this.wrap((UriParserException)new UriParserSemanticException("Property '" + odi + "' not found in type '" + structType.getNamespace() + "." + structType.getName() + "'", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            if (property instanceof EdmProperty) {
                if (((EdmProperty)property).isPrimitive()) {
                    UriResourcePrimitivePropertyImpl simpleResource = new UriResourcePrimitivePropertyImpl().setProperty((EdmProperty)property);
                    this.context.contextUriInfo.addResourcePart((UriResourceImpl)simpleResource);
                    return null;
                }
                UriResourceComplexPropertyImpl complexResource = new UriResourceComplexPropertyImpl().setProperty((EdmProperty)property);
                this.context.contextUriInfo.addResourcePart((UriResourceImpl)complexResource);
                return null;
            }
            if (property instanceof EdmNavigationProperty) {
                UriResourceNavigationPropertyImpl navigationResource = new UriResourceNavigationPropertyImpl().setNavigationProperty((EdmNavigationProperty)property);
                this.context.contextUriInfo.addResourcePart((UriResourceImpl)navigationResource);
                return null;
            }
            throw this.wrap((UriParserException)new UriParserSemanticException("Unkown type for property '" + property + "'", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
        }
        FullQualifiedName fullFilterName = this.getFullNameFromContext(ctx.vNS, odi);
        if (source.type instanceof EdmEntityType) {
            EdmEntityType filterEntityType = this.edm.getEntityType(fullFilterName);
            if (filterEntityType != null) {
                if (!filterEntityType.compatibleTo(source.type)) {
                    throw this.wrap((UriParserException)new UriParserSemanticException("Entity typefilter not compatible to previous path segment: " + fullFilterName.toString(), (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
                }
                if (lastResourcePart == null) {
                    UriResourceStartingTypeFilterImpl uriResource = new UriResourceStartingTypeFilterImpl().setType((EdmType)filterEntityType).setCollection(source.isCollection);
                    if (source.isCollection) {
                        uriResource.setCollectionTypeFilter((EdmType)filterEntityType);
                    } else {
                        uriResource.setEntryTypeFilter((EdmType)filterEntityType);
                    }
                    this.context.contextUriInfo.addResourcePart((UriResourceImpl)uriResource);
                    return null;
                }
                if (lastResourcePart instanceof UriResourceWithKeysImpl) {
                    UriResourceWithKeysImpl lastPartWithKeys = (UriResourceWithKeysImpl)lastResourcePart;
                    if (!lastPartWithKeys.isCollection()) {
                        if (lastPartWithKeys.getTypeFilterOnEntry() != null) {
                            throw this.wrap((UriParserException)new UriParserSemanticException("Entry typefilters are not chainable, used '" + this.getName((EdmType)filterEntityType) + "' behind '" + this.getName(lastPartWithKeys.getTypeFilterOnEntry()) + "'", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
                        }
                        lastPartWithKeys.setEntryTypeFilter((EdmType)filterEntityType);
                        return null;
                    }
                    if (lastPartWithKeys.getTypeFilterOnCollection() != null) {
                        throw this.wrap((UriParserException)new UriParserSemanticException("Collection typefilters are not chainable, used '" + this.getName((EdmType)filterEntityType) + "' behind '" + this.getName(lastPartWithKeys.getTypeFilterOnCollection()) + "'", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
                    }
                    lastPartWithKeys.setCollectionTypeFilter((EdmType)filterEntityType);
                    return null;
                }
                if (lastResourcePart instanceof UriResourceTypedImpl) {
                    UriResourceTypedImpl lastPartTyped = (UriResourceTypedImpl)lastResourcePart;
                    if (lastPartTyped.getTypeFilter() != null) {
                        throw this.wrap((UriParserException)new UriParserSemanticException("Typefilters are not chainable, used '" + this.getName((EdmType)filterEntityType) + "' behind '" + this.getName(lastPartTyped.getTypeFilter()) + "'", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
                    }
                    lastPartTyped.setTypeFilter((EdmStructuredType)filterEntityType);
                    return null;
                }
                throw this.wrap((UriParserException)new UriParserSemanticException("Path segment before '" + this.getName((EdmType)filterEntityType) + "' not typed", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
        } else if (source.type instanceof EdmComplexType && (filterComplexType = this.edm.getComplexType(fullFilterName)) != null) {
            if (!filterComplexType.compatibleTo(source.type)) {
                throw this.wrap((UriParserException)new UriParserSemanticException("Complex typefilter '" + this.getName(source.type) + "'not compatible type of previous path segment '" + this.getName((EdmType)filterComplexType) + "'", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            if (lastResourcePart == null) {
                UriResourceStartingTypeFilterImpl uriResource = new UriResourceStartingTypeFilterImpl().setType((EdmType)filterComplexType).setCollection(source.isCollection);
                if (source.isCollection) {
                    uriResource.setCollectionTypeFilter((EdmType)filterComplexType);
                } else {
                    uriResource.setEntryTypeFilter((EdmType)filterComplexType);
                }
                this.context.contextUriInfo.addResourcePart((UriResourceImpl)uriResource);
                return null;
            }
            if (lastResourcePart instanceof UriResourceWithKeysImpl) {
                UriResourceWithKeysImpl lastPartWithKeys = (UriResourceWithKeysImpl)lastResourcePart;
                if (!lastPartWithKeys.isCollection()) {
                    if (lastPartWithKeys.getTypeFilterOnEntry() != null) {
                        throw this.wrap((UriParserException)new UriParserSemanticException("Entry typefilters are not chainable, used '" + this.getName((EdmType)filterComplexType) + "' behind '" + this.getName(lastPartWithKeys.getTypeFilterOnEntry()) + "'", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
                    }
                    lastPartWithKeys.setEntryTypeFilter((EdmType)filterComplexType);
                    return null;
                }
                if (lastPartWithKeys.getTypeFilterOnCollection() != null) {
                    throw this.wrap((UriParserException)new UriParserSemanticException("Collection typefilters are not chainable, used '" + this.getName((EdmType)filterComplexType) + "' behind '" + this.getName(lastPartWithKeys.getTypeFilterOnCollection()) + "'", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
                }
                lastPartWithKeys.setCollectionTypeFilter((EdmType)filterComplexType);
                return null;
            }
            if (lastResourcePart instanceof UriResourceTypedImpl) {
                UriResourceTypedImpl lastPartTyped = (UriResourceTypedImpl)lastResourcePart;
                if (lastPartTyped.getTypeFilter() != null) {
                    throw this.wrap((UriParserException)new UriParserSemanticException("Typefilters are not chainable, used '" + this.getName((EdmType)filterComplexType) + "' behind '" + this.getName(lastPartTyped.getTypeFilter()) + "'", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
                }
                lastPartTyped.setTypeFilter((EdmStructuredType)filterComplexType);
                return null;
            }
            throw this.wrap((UriParserException)new UriParserSemanticException("Path segment before '" + this.getName((EdmType)filterComplexType) + "' not typed", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
        }
        if ((action = this.edm.getBoundAction(fullFilterName, fullBindingTypeName = new FullQualifiedName(source.type.getNamespace(), source.type.getName()), Boolean.valueOf(source.isCollection))) != null) {
            UriResourceActionImpl pathInfoAction = new UriResourceActionImpl();
            pathInfoAction.setAction(action);
            this.context.contextUriInfo.addResourcePart((UriResourceImpl)pathInfoAction);
            return null;
        }
        if (ctx.vlNVO.size() == 0) {
            throw this.wrap((UriParserException)new UriParserSemanticException("Expected function parameters for '" + fullBindingTypeName.toString() + "'", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
        }
        this.context.contextReadingFunctionParameters = true;
        List parameters = (List)((UriParserParser.NameValueOptListContext)ctx.vlNVO.get(0)).accept((ParseTreeVisitor)this);
        this.context.contextReadingFunctionParameters = false;
        ArrayList<String> names = new ArrayList<String>();
        for (UriParameterImpl item : parameters) {
            names.add(item.getName());
        }
        EdmFunction function = this.edm.getBoundFunction(fullFilterName, fullBindingTypeName, Boolean.valueOf(source.isCollection), names);
        if (function != null) {
            pathInfoFunction = new UriResourceFunctionImpl().setFunction(function).setParameters(parameters);
            this.context.contextUriInfo.addResourcePart((UriResourceImpl)pathInfoFunction);
            ctx.vlNVO.remove(0);
            return null;
        }
        function = this.edm.getUnboundFunction(fullFilterName, names);
        if (function != null) {
            pathInfoFunction = new UriResourceFunctionImpl().setFunction(function).setParameters(parameters);
            this.context.contextUriInfo.addResourcePart((UriResourceImpl)pathInfoFunction);
            ctx.vlNVO.remove(0);
            return null;
        }
        throw this.wrap((UriParserException)new UriParserSemanticException("Unknown resource path segment:" + fullFilterName.toString(), (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
    }

    private String getName(EdmType type) {
        return type.getNamespace() + "." + type.getName();
    }

    public Object visitAllEOF(UriParserParser.AllEOFContext ctx) {
        UriInfoImpl crossJoin;
        this.context.contextUriInfo = crossJoin = new UriInfoImpl().setKind(UriInfoKind.all);
        return null;
    }

    public Object visitAllExpr(UriParserParser.AllExprContext ctx) {
        UriResourceLambdaAllImpl all = new UriResourceLambdaAllImpl();
        UriResource obj = this.context.contextUriInfo.getLastResourcePart();
        if (!(obj instanceof UriResourcePartTyped)) {
            throw this.wrap((UriParserException)new UriParserSemanticException("any only allowed on typed path segments", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
        }
        UriContext.LambdaVariables var = new UriContext.LambdaVariables();
        var.name = ctx.vLV.getText();
        var.type = this.getTypeInformation((UriResource)obj).type;
        var.isCollection = false;
        all.setLamdaVariable(ctx.vLV.getText());
        this.context.allowedLambdaVariables.push(var);
        all.setExpression((ExpressionImpl)ctx.vLE.accept((ParseTreeVisitor)this));
        this.context.allowedLambdaVariables.pop();
        return all;
    }

    public ExpressionImpl visitAltAdd(UriParserParser.AltAddContext ctx) {
        BinaryImpl binary = new BinaryImpl();
        int tokenIndex = ctx.vO.getType();
        if (tokenIndex == 53) {
            binary.setOperator(BinaryOperatorKind.ADD);
        } else if (tokenIndex == 54) {
            binary.setOperator(BinaryOperatorKind.SUB);
        }
        binary.setLeftOperand((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
        binary.setRightOperand((ExpressionImpl)ctx.vE2.accept((ParseTreeVisitor)this));
        return binary;
    }

    public Object visitAltAll(UriParserParser.AltAllContext ctx) {
        UriInfoImpl uriInfoImplpath = new UriInfoImpl().setKind(UriInfoKind.resource);
        uriInfoImplpath.addResourcePart((UriResourceImpl)super.visitAltAll(ctx));
        EdmType startType = this.removeUriResourceStartingTypeFilterImpl(uriInfoImplpath);
        MemberImpl ret = new MemberImpl();
        ret.setResourcePath((UriInfoResource)uriInfoImplpath);
        if (startType != null) {
            ret.setTypeFilter(startType);
        }
        return ret;
    }

    private EdmType removeUriResourceStartingTypeFilterImpl(UriInfoImpl uriInfoImplpath) {
        List segments = uriInfoImplpath.getUriResourceParts();
        if (segments.size() == 0) {
            return null;
        }
        UriResource segment = (UriResource)segments.get(0);
        if (segment instanceof UriResourceStartingTypeFilterImpl) {
            UriResourceStartingTypeFilterImpl startingTypeFilter = (UriResourceStartingTypeFilterImpl)segment;
            EdmType type = null;
            type = startingTypeFilter.getTypeFilterOnEntry() != null ? startingTypeFilter.getTypeFilterOnEntry() : (startingTypeFilter.getTypeFilterOnCollection() != null ? startingTypeFilter.getTypeFilterOnCollection() : startingTypeFilter.getType());
            uriInfoImplpath.removeResourcePart(0);
            return type;
        }
        return null;
    }

    public ExpressionImpl visitAltAnd(UriParserParser.AltAndContext ctx) {
        BinaryImpl binary = new BinaryImpl();
        binary.setOperator(BinaryOperatorKind.AND);
        binary.setLeftOperand((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
        binary.setRightOperand((ExpressionImpl)ctx.vE2.accept((ParseTreeVisitor)this));
        return binary;
    }

    public Object visitAltAny(UriParserParser.AltAnyContext ctx) {
        UriInfoImpl uriInfoImplpath = new UriInfoImpl().setKind(UriInfoKind.resource);
        uriInfoImplpath.addResourcePart((UriResourceImpl)super.visitAltAny(ctx));
        EdmType startType = this.removeUriResourceStartingTypeFilterImpl(uriInfoImplpath);
        MemberImpl ret = new MemberImpl();
        ret.setResourcePath((UriInfoResource)uriInfoImplpath);
        if (startType != null) {
            ret.setTypeFilter(startType);
        }
        return ret;
    }

    public Object visitBatchEOF(UriParserParser.BatchEOFContext ctx) {
        this.context.contextUriInfo = new UriInfoImpl().setKind(UriInfoKind.batch);
        return null;
    }

    public ExpressionImpl visitAltComparism(UriParserParser.AltComparismContext ctx) {
        BinaryImpl binary = new BinaryImpl();
        int tokenIndex = ctx.vO.getType();
        if (tokenIndex == 57) {
            binary.setOperator(BinaryOperatorKind.GT);
        } else if (tokenIndex == 58) {
            binary.setOperator(BinaryOperatorKind.GE);
        } else if (tokenIndex == 59) {
            binary.setOperator(BinaryOperatorKind.LT);
        } else if (tokenIndex == 60) {
            binary.setOperator(BinaryOperatorKind.LE);
        }
        binary.setLeftOperand((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
        binary.setRightOperand((ExpressionImpl)ctx.vE2.accept((ParseTreeVisitor)this));
        return binary;
    }

    public Object visitEntityEOF(UriParserParser.EntityEOFContext ctx) {
        String odi = ctx.vODI.getText();
        FullQualifiedName fullName = this.getFullNameFromContext(ctx.vNS, odi);
        EdmEntityType type = this.edm.getEntityType(fullName);
        if (type == null) {
            throw this.wrap((UriParserException)new UriParserSemanticException("Expected EntityTypeName", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
        }
        this.context.contextUriInfo.setEntityTypeCast(type);
        this.context.contextTypes.push(new TypeInformation(this, (EdmType)this.context.contextUriInfo.getEntityTypeCast(), true));
        return null;
    }

    public ExpressionImpl visitAltEquality(UriParserParser.AltEqualityContext ctx) {
        BinaryImpl binary = new BinaryImpl();
        int tokenIndex = ctx.vO.getType();
        if (tokenIndex == 62) {
            binary.setOperator(BinaryOperatorKind.EQ);
        } else {
            binary.setOperator(BinaryOperatorKind.NE);
        }
        binary.setLeftOperand((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
        binary.setRightOperand((ExpressionImpl)ctx.vE2.accept((ParseTreeVisitor)this));
        return binary;
    }

    public Object visitAltHas(UriParserParser.AltHasContext ctx) {
        BinaryImpl binary = new BinaryImpl();
        binary.setOperator(BinaryOperatorKind.HAS);
        binary.setLeftOperand((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
        binary.setRightOperand((ExpressionImpl)ctx.vE2.accept((ParseTreeVisitor)this));
        return binary;
    }

    public Object visitMetadataEOF(UriParserParser.MetadataEOFContext ctx) {
        UriInfoImpl uriInfo;
        this.context.contextUriInfo = uriInfo = new UriInfoImpl().setKind(UriInfoKind.metadata);
        return null;
    }

    public ExpressionImpl visitAltMult(UriParserParser.AltMultContext ctx) {
        BinaryImpl binary = new BinaryImpl();
        int tokenIndex = ctx.vO.getType();
        if (tokenIndex == 49) {
            binary.setOperator(BinaryOperatorKind.MUL);
        } else if (tokenIndex == 50) {
            binary.setOperator(BinaryOperatorKind.DIV);
        } else {
            binary.setOperator(BinaryOperatorKind.MOD);
        }
        binary.setLeftOperand((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
        binary.setRightOperand((ExpressionImpl)ctx.vE2.accept((ParseTreeVisitor)this));
        return binary;
    }

    public ExpressionImpl visitAltOr(UriParserParser.AltOrContext ctx) {
        BinaryImpl binary = new BinaryImpl();
        binary.setOperator(BinaryOperatorKind.OR);
        binary.setLeftOperand((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
        binary.setRightOperand((ExpressionImpl)ctx.vE2.accept((ParseTreeVisitor)this));
        return binary;
    }

    public Object visitAnyExpr(UriParserParser.AnyExprContext ctx) {
        UriResourceLambdaAnyImpl any = new UriResourceLambdaAnyImpl();
        if (ctx.vLV != null) {
            UriResourceImpl lastResourcePart = (UriResourceImpl)this.context.contextUriInfo.getLastResourcePart();
            if (!(lastResourcePart instanceof UriResourcePartTyped)) {
                throw this.wrap((UriParserException)new UriParserSemanticException("any only allowed on typed path segments", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            UriContext.LambdaVariables var = new UriContext.LambdaVariables();
            var.name = ctx.vLV.getText();
            var.type = this.getTypeInformation((UriResource)lastResourcePart).type;
            var.isCollection = false;
            any.setLamdaVariable(ctx.vLV.getText());
            this.context.allowedLambdaVariables.push(var);
            any.setExpression((ExpressionImpl)ctx.vLE.accept((ParseTreeVisitor)this));
            this.context.allowedLambdaVariables.pop();
        }
        return any;
    }

    public Object visitBooleanNonCase(UriParserParser.BooleanNonCaseContext ctx) {
        String text = ctx.getText().toLowerCase();
        if (text.equals("false")) {
            return new LiteralImpl().setText("false").setType((EdmType)EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Boolean));
        }
        return new LiteralImpl().setText("true").setType((EdmType)EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Boolean));
    }

    public ExpressionImpl visitCastExpr(UriParserParser.CastExprContext ctx) {
        MethodImpl method = new MethodImpl();
        if (ctx.vE1 != null) {
            ExpressionImpl onExpression = (ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this);
            method.addParameter(onExpression);
        }
        String namespace = ctx.vNS.getText();
        namespace = namespace.substring(0, namespace.length() - 1);
        FullQualifiedName fullName = new FullQualifiedName(namespace, ctx.vODI.getText());
        EdmType type = this.getType(fullName);
        method.setMethod(MethodKind.CAST);
        method.addParameter((ExpressionImpl)new TypeLiteralImpl().setType(type));
        return method;
    }

    private EdmType getType(FullQualifiedName fullName) {
        EdmPrimitiveTypeKind typeKind;
        EdmEntityType type = null;
        type = this.edm.getEntityType(fullName);
        if (type != null) {
            return type;
        }
        type = this.edm.getComplexType(fullName);
        if (type != null) {
            return type;
        }
        type = this.edm.getEnumType(fullName);
        if (type != null) {
            return type;
        }
        if (fullName.getNamespace().equals("Edm") && (type = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)(typeKind = EdmPrimitiveTypeKind.valueOf((String)fullName.getName())))) != null) {
            return type;
        }
        return null;
    }

    public ExpressionImpl visitCeilingMethodCallExpr(UriParserParser.CeilingMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.CEILING).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public ExpressionImpl visitConcatMethodCallExpr(UriParserParser.ConcatMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.CONCAT).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this)).addParameter((ExpressionImpl)ctx.vE2.accept((ParseTreeVisitor)this));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object visitConstSegment(UriParserParser.ConstSegmentContext ctx) {
        UriInfoImpl uriInfoResource = this.context.contextUriInfo;
        UriResource pathInfo = uriInfoResource.getLastResourcePart();
        if (ctx.vV != null) {
            if (!(pathInfo instanceof UriResourcePartTyped)) throw this.wrap((UriParserException)new UriParserSemanticException("$value only allowed on typed path segments", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            if (((UriResourcePartTyped)pathInfo).isCollection()) {
                throw this.wrap((UriParserException)new UriParserSemanticException("$value only allowed on typed path segments", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            this.context.contextUriInfo.addResourcePart((UriResourceImpl)new UriResourceValueImpl());
            return null;
        }
        if (ctx.vC != null) {
            if (!(pathInfo instanceof UriResourcePartTyped)) throw this.wrap((UriParserException)new UriParserSemanticException("$count only allowed on typed properties", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            if (!((UriResourcePartTyped)pathInfo).isCollection()) throw this.wrap((UriParserException)new UriParserSemanticException("$count only allowed on collection properties", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            this.context.contextUriInfo.addResourcePart((UriResourceImpl)new UriResourceCountImpl());
            return null;
        } else if (ctx.vR != null) {
            if (!(pathInfo instanceof UriResourcePartTyped)) throw this.wrap((UriParserException)new UriParserSemanticException("$ref only allowed on typed properties", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            EdmType type = ((UriResourcePartTyped)pathInfo).getType();
            if (!(type instanceof EdmEntityType)) throw this.wrap((UriParserException)new UriParserSemanticException("$ref only allowed on endity types", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            this.context.contextUriInfo.addResourcePart((UriResourceImpl)new UriResourceRefImpl());
            return null;
        } else if (ctx.vAll != null) {
            this.context.contextUriInfo.addResourcePart((UriResourceImpl)((UriResourceLambdaAllImpl)ctx.vAll.accept((ParseTreeVisitor)this)));
            return null;
        } else {
            if (ctx.vAny == null) return null;
            this.context.contextUriInfo.addResourcePart((UriResourceImpl)((UriResourceLambdaAnyImpl)ctx.vAny.accept((ParseTreeVisitor)this)));
        }
        return null;
    }

    public ExpressionImpl visitContainsMethodCallExpr(UriParserParser.ContainsMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.CONTAINS).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this)).addParameter((ExpressionImpl)ctx.vE2.accept((ParseTreeVisitor)this));
    }

    public Object visitCrossjoinEOF(UriParserParser.CrossjoinEOFContext ctx) {
        UriInfoImpl crossJoin = new UriInfoImpl().setKind(UriInfoKind.crossjoin);
        for (UriParserParser.OdataIdentifierContext obj : ctx.vlODI) {
            crossJoin.addEntitySetName(obj.getText());
        }
        this.context.contextUriInfo = crossJoin;
        return null;
    }

    public Object visitDateMethodCallExpr(UriParserParser.DateMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.DATE).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public ExpressionImpl visitDayMethodCallExpr(UriParserParser.DayMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.DAY).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public ExpressionImpl visitGeoDistanceMethodCallExpr(UriParserParser.GeoDistanceMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.GEODISTANCE).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this)).addParameter((ExpressionImpl)ctx.vE2.accept((ParseTreeVisitor)this));
    }

    public Object visitEndsWithMethodCallExpr(UriParserParser.EndsWithMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.ENDSWITH).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this)).addParameter((ExpressionImpl)ctx.vE2.accept((ParseTreeVisitor)this));
    }

    public Object visitEnumLit(UriParserParser.EnumLitContext ctx) {
        String[] values;
        EnumerationImpl enum1 = new EnumerationImpl();
        String odi = ctx.vODI.getText();
        FullQualifiedName fullName = this.getFullNameFromContext(ctx.vNS, odi);
        EdmEnumType edmEnumType = this.edm.getEnumType(fullName);
        enum1.setType(edmEnumType);
        String valueString = ctx.vValues.getText();
        valueString = valueString.substring(1, valueString.length() - 1);
        for (String item : values = valueString.split(",")) {
            enum1.addValue(item);
        }
        return enum1;
    }

    public Object visitExpandItems(UriParserParser.ExpandItemsContext ctx) {
        ExpandOptionImpl expand = new ExpandOptionImpl();
        expand.setText(ctx.getText());
        for (UriParserParser.ExpandItemContext eI : ctx.vlEI) {
            expand.addExpandItem((ExpandItemImpl)eI.accept((ParseTreeVisitor)this));
        }
        return expand;
    }

    public Object visitExpandItem(UriParserParser.ExpandItemContext ctx) {
        ExpandItemImpl expandItem = null;
        if (ctx.vS != null) {
            expandItem = new ExpandItemImpl().setIsStar(true);
            if (ctx.vR != null) {
                expandItem.setIsRef(true);
            } else if (ctx.vM != null) {
                LevelsOptionImpl levels = new LevelsOptionImpl().setMax();
                levels.setText(ctx.vM.getText());
                expandItem.setSystemQueryOption((SystemQueryOptionImpl)levels);
            } else if (ctx.vL != null) {
                LevelsOptionImpl levels = new LevelsOptionImpl();
                String text = ctx.vL.getText();
                levels.setText(text);
                levels.setValue(Integer.parseInt(text));
                expandItem.setSystemQueryOption((SystemQueryOptionImpl)levels);
            }
        } else if (ctx.vEP != null) {
            expandItem = (ExpandItemImpl)ctx.vEP.accept((ParseTreeVisitor)this);
            if (ctx.vEPE != null) {
                ExpandItemImpl contextExpandItemPathBU = this.context.contextExpandItemPath;
                this.context.contextExpandItemPath = expandItem;
                List list = (List)ctx.vEPE.accept((ParseTreeVisitor)this);
                for (SystemQueryOptionImpl option : list) {
                    expandItem.setSystemQueryOption(option);
                }
                this.context.contextExpandItemPath = contextExpandItemPathBU;
            }
        }
        return expandItem;
    }

    public Object visitExpandPath(UriParserParser.ExpandPathContext ctx) {
        ExpandItemImpl expandItem = new ExpandItemImpl();
        this.context.contextUriInfo.getLastResourcePart();
        ExpandItemImpl contextExpandItemPathBU = this.context.contextExpandItemPath;
        UriInfoImpl uriInfoResourceBU = this.context.contextUriInfo;
        this.context.contextExpandItemPath = expandItem;
        this.context.contextUriInfo = new UriInfoImpl().setKind(UriInfoKind.resource);
        super.visitExpandPath(ctx);
        EdmType startType = this.removeUriResourceStartingTypeFilterImpl(this.context.contextUriInfo);
        expandItem.setResourcePath((UriInfoResource)this.context.contextUriInfo);
        if (startType != null) {
            expandItem.setTypeFilter(startType);
        }
        this.context.contextUriInfo = uriInfoResourceBU;
        this.context.contextExpandItemPath = contextExpandItemPathBU;
        return expandItem;
    }

    public Object visitExpandPathExtension(UriParserParser.ExpandPathExtensionContext ctx) {
        UriInfoImpl resourcePath;
        UriResourceTypedImpl lastSegment;
        ArrayList<SystemQueryOptionImpl> list = new ArrayList<SystemQueryOptionImpl>();
        EdmType targetType = null;
        boolean isColl = false;
        if (this.context.contextExpandItemPath == null) {
            lastSegment = (UriResourceTypedImpl)this.context.contextUriInfo.getLastResourcePart();
            targetType = this.getTypeInformation((UriResource)lastSegment).type;
            isColl = lastSegment.isCollection();
        } else if (this.context.contextExpandItemPath.getResourcePath() == null) {
            lastSegment = (UriResourceTypedImpl)this.context.contextUriInfo.getLastResourcePart();
            targetType = this.getTypeInformation((UriResource)lastSegment).type;
            isColl = lastSegment.isCollection();
        } else {
            UriInfoImpl info = (UriInfoImpl)this.context.contextExpandItemPath.getResourcePath();
            targetType = this.getTypeInformation((UriResource)info.getLastResourcePart()).type;
            isColl = ((UriResourcePartTyped)info.getLastResourcePart()).isCollection();
        }
        this.context.contextTypes.push(new TypeInformation(this, targetType, isColl));
        if (ctx.vC != null) {
            resourcePath = (UriInfoImpl)this.context.contextExpandItemPath.getResourcePath();
            resourcePath.addResourcePart((UriResourceImpl)new UriResourceCountImpl());
            for (UriParserParser.ExpandCountOptionContext s : ctx.vlEOC) {
                list.add((SystemQueryOptionImpl)s.accept((ParseTreeVisitor)this));
            }
        } else if (ctx.vR != null) {
            resourcePath = (UriInfoImpl)this.context.contextExpandItemPath.getResourcePath();
            resourcePath.addResourcePart((UriResourceImpl)new UriResourceRefImpl());
            for (UriParserParser.ExpandRefOptionContext s : ctx.vlEOR) {
                list.add((SystemQueryOptionImpl)s.accept((ParseTreeVisitor)this));
            }
        } else {
            for (UriParserParser.ExpandOptionContext s : ctx.vlEO) {
                list.add((SystemQueryOptionImpl)s.accept((ParseTreeVisitor)this));
            }
        }
        this.context.contextTypes.pop();
        return list;
    }

    public Object visitFilter(UriParserParser.FilterContext ctx) {
        FilterOptionImpl filter = new FilterOptionImpl().setExpression((ExpressionImpl)((ParseTree)ctx.children.get(2)).accept((ParseTreeVisitor)this));
        return filter;
    }

    public Object visitFilterExpressionEOF(UriParserParser.FilterExpressionEOFContext ctx) {
        FilterOptionImpl filter = new FilterOptionImpl().setExpression((ExpressionImpl)((ParseTree)ctx.children.get(0)).accept((ParseTreeVisitor)this));
        return filter;
    }

    public ExpressionImpl visitFloorMethodCallExpr(UriParserParser.FloorMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.FLOOR).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public ExpressionImpl visitFractionalsecondsMethodCallExpr(UriParserParser.FractionalsecondsMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.FRACTIONALSECONDS).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public ExpressionImpl visitGeoLengthMethodCallExpr(UriParserParser.GeoLengthMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.GEOLENGTH).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public ExpressionImpl visitHourMethodCallExpr(UriParserParser.HourMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.HOUR).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public ExpressionImpl visitIndexOfMethodCallExpr(UriParserParser.IndexOfMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.INDEXOF).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this)).addParameter((ExpressionImpl)ctx.vE2.accept((ParseTreeVisitor)this));
    }

    public Object visitInlinecount(UriParserParser.InlinecountContext ctx) {
        CountOptionImpl inlineCount = new CountOptionImpl();
        String text = ((ParseTree)ctx.children.get(2)).getText();
        return inlineCount.setValue(text.toLowerCase().equals("true")).setText(text);
    }

    public ExpressionImpl visitGeoIntersectsMethodCallExpr(UriParserParser.GeoIntersectsMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.GEOINTERSECTS).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this)).addParameter((ExpressionImpl)ctx.vE2.accept((ParseTreeVisitor)this));
    }

    public ExpressionImpl visitIsofExpr(UriParserParser.IsofExprContext ctx) {
        MethodImpl method = new MethodImpl();
        if (ctx.vE1 != null) {
            ExpressionImpl onExpression = (ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this);
            method.addParameter(onExpression);
        }
        String namespace = ctx.vNS.getText();
        namespace = namespace.substring(0, namespace.length() - 1);
        FullQualifiedName fullName = new FullQualifiedName(namespace, ctx.vODI.getText());
        EdmType type = this.getType(fullName);
        method.setMethod(MethodKind.ISOF);
        method.addParameter((ExpressionImpl)new TypeLiteralImpl().setType(type));
        return method;
    }

    public ExpressionImpl visitLengthMethodCallExpr(UriParserParser.LengthMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.LENGTH).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public Object visitLevels(UriParserParser.LevelsContext ctx) {
        LevelsOptionImpl levels = new LevelsOptionImpl();
        String text = ((ParseTree)ctx.children.get(2)).getText();
        if (text.equals("max")) {
            levels.setMax();
        } else {
            levels.setValue(Integer.parseInt(text));
        }
        levels.setText(text);
        return levels;
    }

    public ExpressionImpl visitMaxDateTimeMethodCallExpr(UriParserParser.MaxDateTimeMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.MAXDATETIME);
    }

    public Object visitMemberExpr(UriParserParser.MemberExprContext ctx) {
        UriInfoImpl uriInfoImplpath = new UriInfoImpl().setKind(UriInfoKind.resource);
        TypeInformation lastTypeInfo = (TypeInformation)this.context.contextTypes.peek();
        if (ctx.vIt != null || ctx.vIts != null) {
            UriResourceItImpl pathInfoIT = new UriResourceItImpl();
            pathInfoIT.setType(lastTypeInfo.type);
            pathInfoIT.setCollection(lastTypeInfo.isCollection);
            uriInfoImplpath.addResourcePart((UriResourceImpl)pathInfoIT);
        }
        if (ctx.vPs != null) {
            UriInfoImpl backupUriInfoPath = this.context.contextUriInfo;
            this.context.contextUriInfo = uriInfoImplpath;
            ctx.vPs.accept((ParseTreeVisitor)this);
            this.context.contextUriInfo = backupUriInfoPath;
        }
        if (ctx.vALL != null) {
            uriInfoImplpath.addResourcePart((UriResourceImpl)ctx.vALL.accept((ParseTreeVisitor)this));
        }
        if (ctx.vANY != null) {
            uriInfoImplpath.addResourcePart((UriResourceImpl)ctx.vANY.accept((ParseTreeVisitor)this));
        }
        EdmType startType = this.removeUriResourceStartingTypeFilterImpl(uriInfoImplpath);
        MemberImpl ret = new MemberImpl();
        ret.setResourcePath((UriInfoResource)uriInfoImplpath);
        if (startType != null) {
            ret.setTypeFilter(startType);
        }
        return ret;
    }

    public ExpressionImpl visitMinDateTimeMethodCallExpr(UriParserParser.MinDateTimeMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.MINDATETIME);
    }

    public ExpressionImpl visitMinuteMethodCallExpr(UriParserParser.MinuteMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.MINUTE).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public ExpressionImpl visitMonthMethodCallExpr(UriParserParser.MonthMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.MONTH).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public Object visitNameValueOptList(UriParserParser.NameValueOptListContext ctx) {
        if (ctx.vVO != null) {
            String valueText = ctx.vVO.getText();
            ExpressionImpl expression = null;
            try {
                expression = (ExpressionImpl)ctx.vVO.accept((ParseTreeVisitor)this);
            }
            catch (Exception ex) {
                throw this.wrap((UriParserException)new UriParserSemanticException("Invalid key value: " + valueText, (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            UriResource last = this.context.contextUriInfo.getLastResourcePart();
            if (!(last instanceof UriResourcePartTyped)) {
                throw this.wrap((UriParserException)new UriParserSemanticException("Paramterslist on untyped resource path segement not allowed", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            EdmEntityType lastType = (EdmEntityType)((UriResourcePartTyped)last).getType();
            List lastKeyPredicates = lastType.getKeyPredicateNames();
            if (lastKeyPredicates.size() == 1) {
                String keyName = (String)lastKeyPredicates.get(0);
                ArrayList<UriParameterImpl> list = new ArrayList<UriParameterImpl>();
                list.add(new UriParameterImpl().setName(keyName).setText(valueText).setExpression(expression));
                return list;
            }
            if (!(this.context.contextUriInfo.getLastResourcePart() instanceof UriResourceNavigationPropertyImpl)) {
                throw this.wrap((UriParserException)new UriParserSemanticException("Not enougth keyproperties defined", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            UriResourceNavigationPropertyImpl lastNav = (UriResourceNavigationPropertyImpl)last;
            EdmNavigationProperty partner = lastNav.getProperty().getPartner();
            if (partner == null) {
                throw this.wrap((UriParserException)new UriParserSemanticException("Not enougth keyproperties defined", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            ArrayList<UriParameterImpl> list = new ArrayList<UriParameterImpl>();
            String missedKey = null;
            for (String item : lastKeyPredicates) {
                String property = partner.getReferencingPropertyName(item);
                if (property != null) {
                    list.add(new UriParameterImpl().setName(item).setRefencedProperty(property));
                    continue;
                }
                if (missedKey == null) {
                    missedKey = item;
                    continue;
                }
                throw this.wrap((UriParserException)new UriParserSemanticException("Not enougth referntial contrains defined", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            list.add(new UriParameterImpl().setName(missedKey).setText(valueText).setExpression(expression));
            return list;
        }
        if (ctx.vNVL != null) {
            ArrayList<UriParameterImpl> list = new ArrayList<UriParameterImpl>();
            for (UriParserParser.NameValuePairContext c : ctx.vNVL.vlNVP) {
                list.add((UriParameterImpl)c.accept((ParseTreeVisitor)this));
            }
            if (this.context.contextReadingFunctionParameters) {
                return list;
            }
            UriResource last = this.context.contextUriInfo.getLastResourcePart();
            if (!(last instanceof UriResourcePartTyped)) {
                throw this.wrap((UriParserException)new UriParserSemanticException("Parameterslist on untyped resource path segement not allowed", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            EdmEntityType lastType = (EdmEntityType)((UriResourcePartTyped)last).getType();
            List lastKeyPredicates = lastType.getKeyPredicateNames();
            if (list.size() == lastKeyPredicates.size()) {
                return list;
            }
            if (!(this.context.contextUriInfo.getLastResourcePart() instanceof UriResourceNavigationPropertyImpl)) {
                throw this.wrap((UriParserException)new UriParserSemanticException("Not enougth keyproperties defined", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            UriResourceNavigationPropertyImpl lastNav = (UriResourceNavigationPropertyImpl)last;
            EdmNavigationProperty partner = lastNav.getProperty().getPartner();
            if (partner == null) {
                throw this.wrap((UriParserException)new UriParserSemanticException("Not enougth keyproperties defined", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            for (String key : lastKeyPredicates) {
                String property;
                boolean found = false;
                for (UriParameterImpl item : list) {
                    if (!item.getName().equals(key)) continue;
                    found = true;
                    break;
                }
                if (found || (property = partner.getReferencingPropertyName(key)) == null) continue;
                list.add(0, new UriParameterImpl().setName(key).setRefencedProperty(property));
            }
            if (list.size() == lastKeyPredicates.size()) {
                return list;
            }
            throw this.wrap((UriParserException)new UriParserSemanticException("Not enougth keyproperties defined", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
        }
        return new ArrayList();
    }

    public UriParameterImpl visitNameValuePair(UriParserParser.NameValuePairContext ctx) {
        UriParameterImpl uriParameter = new UriParameterImpl();
        uriParameter.setName(ctx.vODI.getText());
        if (ctx.vCOM != null) {
            uriParameter.setText(ctx.vCOM.getText());
            uriParameter.setExpression((ExpressionImpl)ctx.vCOM.accept((ParseTreeVisitor)this));
        } else {
            uriParameter.setAlias("@" + ctx.vALI.getText());
        }
        return uriParameter;
    }

    public Object visitNaninfinity(UriParserParser.NaninfinityContext ctx) {
        return new LiteralImpl().setType((EdmType)EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Decimal)).setText(ctx.getText());
    }

    public ExpressionImpl visitNowMethodCallExpr(UriParserParser.NowMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.NOW);
    }

    public Object visitNullrule(UriParserParser.NullruleContext ctx) {
        return new LiteralImpl().setText("null");
    }

    public Object visitOrderBy(UriParserParser.OrderByContext ctx) {
        OrderByOptionImpl orderBy = new OrderByOptionImpl();
        for (UriParserParser.OrderByItemContext item : ((UriParserParser.OrderListContext)ctx.getChild((int)2)).vlOI) {
            OrderByItemImpl oItem = (OrderByItemImpl)item.accept((ParseTreeVisitor)this);
            orderBy.addOrder(oItem);
        }
        return orderBy;
    }

    public Object visitOrderByEOF(UriParserParser.OrderByEOFContext ctx) {
        OrderByOptionImpl orderBy = new OrderByOptionImpl();
        for (UriParserParser.OrderByItemContext item : ((UriParserParser.OrderListContext)ctx.getChild((int)0)).vlOI) {
            OrderByItemImpl oItem = (OrderByItemImpl)item.accept((ParseTreeVisitor)this);
            orderBy.addOrder(oItem);
        }
        return orderBy;
    }

    public Object visitOrderByItem(UriParserParser.OrderByItemContext ctx) {
        OrderByItemImpl oItem = new OrderByItemImpl();
        if (ctx.vD != null) {
            oItem.setDescending(true);
        }
        oItem.setExpression((ExpressionImpl)ctx.vC.accept((ParseTreeVisitor)this));
        return oItem;
    }

    public Object visitPathSegment(UriParserParser.PathSegmentContext ctx) {
        this.readResourcePathSegment(ctx);
        UriResourceImpl pathInfoSegment = (UriResourceImpl)this.context.contextUriInfo.getLastResourcePart();
        if (ctx.vlNVO.size() > 0) {
            if (pathInfoSegment instanceof UriResourceWithKeysImpl) {
                List list = (List)((UriParserParser.NameValueOptListContext)ctx.vlNVO.get(0)).accept((ParseTreeVisitor)this);
                ((UriResourceWithKeysImpl)pathInfoSegment).setKeyPredicates(list);
            } else {
                throw this.wrap((UriParserException)new UriParserSemanticException("Key properties not allowed", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
        }
        return pathInfoSegment;
    }

    public Object visitPathSegments(UriParserParser.PathSegmentsContext ctx) {
        for (UriParserParser.PathSegmentContext it : ctx.vlPS) {
            it.accept((ParseTreeVisitor)this);
        }
        if (ctx.vCS != null) {
            ctx.vCS.accept((ParseTreeVisitor)this);
        }
        return null;
    }

    public Object visitPrimitiveLiteral(UriParserParser.PrimitiveLiteralContext ctx) {
        ParseTree child1 = (ParseTree)ctx.children.get(0);
        if (child1 instanceof UriParserParser.EnumLitContext || child1 instanceof UriParserParser.BooleanNonCaseContext || child1 instanceof UriParserParser.NullruleContext || child1 instanceof UriParserParser.NaninfinityContext) {
            return child1.accept((ParseTreeVisitor)this);
        }
        return new LiteralImpl().setText(ctx.getText());
    }

    public Object visitQueryOptions(UriParserParser.QueryOptionsContext ctx) {
        ArrayList<QueryOptionImpl> qpList = new ArrayList<QueryOptionImpl>();
        for (UriParserParser.QueryOptionContext entityOption : ctx.vlQO) {
            qpList.add((QueryOptionImpl)entityOption.accept((ParseTreeVisitor)this));
        }
        return qpList;
    }

    public Object visitRootExpr(UriParserParser.RootExprContext ctx) {
        UriResource lastResource = this.context.contextUriInfo.getLastResourcePart();
        if (!(lastResource instanceof UriResourcePartTyped)) {
            throw this.wrap((UriParserException)new UriParserSemanticException("Resource path not typed", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
        }
        UriResourcePartTyped lastType = (UriResourcePartTyped)lastResource;
        UriResourceRootImpl pathInfoRoot = new UriResourceRootImpl();
        pathInfoRoot.setCollection(lastType.isCollection());
        pathInfoRoot.setType(this.getTypeInformation((UriResource)lastType).type);
        UriInfoImpl uriInfoImplpath = new UriInfoImpl().setKind(UriInfoKind.resource);
        uriInfoImplpath.addResourcePart((UriResourceImpl)pathInfoRoot);
        if (ctx.vPs != null) {
            UriInfoImpl backupUriInfoPath = this.context.contextUriInfo;
            this.context.contextUriInfo = uriInfoImplpath;
            ctx.vPs.accept((ParseTreeVisitor)this);
            this.context.contextUriInfo = backupUriInfoPath;
        }
        return new MemberImpl().setResourcePath((UriInfoResource)uriInfoImplpath);
    }

    public ExpressionImpl visitRoundMethodCallExpr(UriParserParser.RoundMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.ROUND).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public ExpressionImpl visitSecondMethodCallExpr(UriParserParser.SecondMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.SECOND).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public Object visitSelect(UriParserParser.SelectContext ctx) {
        ArrayList<SelectItemImpl> selectItems = new ArrayList<SelectItemImpl>();
        for (UriParserParser.SelectItemContext si : ctx.vlSI) {
            selectItems.add((SelectItemImpl)si.accept((ParseTreeVisitor)this));
        }
        return new SelectOptionImpl().setSelectItems(selectItems).setText(((ParseTree)ctx.children.get(2)).getText());
    }

    public Object visitSelectEOF(UriParserParser.SelectEOFContext ctx) {
        ArrayList<SelectItemImpl> selectItems = new ArrayList<SelectItemImpl>();
        for (UriParserParser.SelectItemContext si : ctx.vlSI) {
            selectItems.add((SelectItemImpl)si.accept((ParseTreeVisitor)this));
        }
        return new SelectOptionImpl().setSelectItems(selectItems).setText(ctx.getText());
    }

    public Object visitSelectItem(UriParserParser.SelectItemContext ctx) {
        SelectItemImpl selectItem;
        this.context.contextSelectItem = selectItem = new SelectItemImpl();
        for (UriParserParser.SelectSegmentContext si : ctx.vlSS) {
            si.accept((ParseTreeVisitor)this);
        }
        this.context.contextSelectItem = null;
        return selectItem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object visitSelectSegment(UriParserParser.SelectSegmentContext ctx) {
        EdmFunction function;
        EdmType prevType;
        if (ctx.vS != null) {
            if (ctx.vNS != null) {
                String namespace = ctx.vNS.getText();
                namespace = namespace.substring(0, namespace.length() - 1);
                FullQualifiedName fullName = new FullQualifiedName(namespace, "*");
                this.context.contextSelectItem.addAllOperationsInSchema(fullName);
                return null;
            } else {
                this.context.contextSelectItem.setStar(true);
            }
            return null;
        }
        String odi = ctx.vODI.getText();
        if (ctx.vNS == null) {
            EdmType prevType2 = null;
            if (this.context.contextSelectItem.getResourcePath() == null) {
                prevType2 = ((TypeInformation)this.context.contextTypes.peek()).type;
            } else {
                UriInfoImpl uriInfo = (UriInfoImpl)this.context.contextSelectItem.getResourcePath();
                UriResource last = uriInfo.getLastResourcePart();
                prevType2 = this.getTypeInformation((UriResource)last).type;
                if (prevType2 == null) {
                    throw this.wrap((UriParserException)new UriParserSemanticException("prev segement not typed", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
                }
            }
            if (!(prevType2 instanceof EdmStructuredType)) {
                throw this.wrap((UriParserException)new UriParserSemanticException("Previous select item is not a structural type", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            EdmStructuredType structType = (EdmStructuredType)prevType2;
            EdmElement element = structType.getProperty(odi);
            if (element == null) {
                throw this.wrap((UriParserException)new UriParserSemanticException("Previous select item has not property: " + odi, (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            if (!(element instanceof EdmProperty)) throw this.wrap((UriParserException)new UriParserSemanticException("Only Simple and Complex properties within select allowed", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            EdmProperty property = (EdmProperty)element;
            if (property.isPrimitive()) {
                UriResourcePrimitivePropertyImpl simple = new UriResourcePrimitivePropertyImpl();
                simple.setProperty(property);
                UriInfoImpl uriInfo = (UriInfoImpl)this.context.contextSelectItem.getResourcePath();
                if (uriInfo == null) {
                    uriInfo = new UriInfoImpl().setKind(UriInfoKind.resource);
                    uriInfo.addResourcePart((UriResourceImpl)simple);
                    EdmType startType = this.removeUriResourceStartingTypeFilterImpl(uriInfo);
                    if (startType != null) {
                        this.context.contextSelectItem.setTypeFilter(startType);
                    }
                    this.context.contextSelectItem.setResourcePath((UriInfoResource)uriInfo);
                    return this;
                } else {
                    uriInfo.addResourcePart((UriResourceImpl)simple);
                }
                return this;
            }
            UriInfoImpl uriInfo = (UriInfoImpl)this.context.contextSelectItem.getResourcePath();
            UriResourceComplexPropertyImpl complex = new UriResourceComplexPropertyImpl();
            complex.setProperty(property);
            if (uriInfo == null) {
                uriInfo = new UriInfoImpl().setKind(UriInfoKind.resource);
                uriInfo.addResourcePart((UriResourceImpl)complex);
                EdmType startType = this.removeUriResourceStartingTypeFilterImpl(uriInfo);
                if (startType != null) {
                    this.context.contextSelectItem.setTypeFilter(startType);
                }
                this.context.contextSelectItem.setResourcePath((UriInfoResource)uriInfo);
                return this;
            } else {
                uriInfo.addResourcePart((UriResourceImpl)complex);
            }
            return this;
        }
        String namespace = ctx.vNS.getText();
        namespace = namespace.substring(0, namespace.length() - 1);
        FullQualifiedName fullName = new FullQualifiedName(namespace, odi);
        if (this.context.contextSelectItem.getResourcePath() == null) {
            prevType = ((TypeInformation)this.context.contextTypes.peek()).type;
            if (prevType instanceof EdmComplexType) {
                EdmComplexType ct = this.edm.getComplexType(fullName);
                if (ct != null && ct.compatibleTo(prevType)) {
                    UriResourceStartingTypeFilterImpl resourcePart = new UriResourceStartingTypeFilterImpl();
                    resourcePart.setCollectionTypeFilter((EdmType)ct);
                    UriInfoImpl uriInfo = new UriInfoImpl().setKind(UriInfoKind.resource);
                    uriInfo.addResourcePart((UriResourceImpl)resourcePart);
                    EdmType startType = this.removeUriResourceStartingTypeFilterImpl(uriInfo);
                    if (startType != null) {
                        this.context.contextSelectItem.setTypeFilter(startType);
                    }
                    this.context.contextSelectItem.setResourcePath((UriInfoResource)uriInfo);
                    return this;
                }
            } else {
                if (!(prevType instanceof EdmEntityType)) throw this.wrap((UriParserException)new UriParserSemanticException("prev segement must be comlex of entity type", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
                EdmEntityType et = this.edm.getEntityType(fullName);
                if (et != null && et.compatibleTo(prevType)) {
                    UriResourceStartingTypeFilterImpl resourcePart = new UriResourceStartingTypeFilterImpl();
                    resourcePart.setCollectionTypeFilter((EdmType)et);
                    UriInfoImpl uriInfo = new UriInfoImpl().setKind(UriInfoKind.resource);
                    uriInfo.addResourcePart((UriResourceImpl)resourcePart);
                    EdmType startType = this.removeUriResourceStartingTypeFilterImpl(uriInfo);
                    if (startType != null) {
                        this.context.contextSelectItem.setTypeFilter(startType);
                    }
                    this.context.contextSelectItem.setResourcePath((UriInfoResource)uriInfo);
                    return this;
                }
            }
        } else {
            UriInfoImpl uriInfo = (UriInfoImpl)this.context.contextSelectItem.getResourcePath();
            UriResource last = uriInfo.getLastResourcePart();
            if (!(last instanceof UriResourceTypedImpl)) {
                throw this.wrap((UriParserException)new UriParserSemanticException("prev segement typed", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            EdmType prevType3 = this.getTypeInformation((UriResource)last).type;
            if (prevType3 instanceof EdmComplexType) {
                EdmComplexType ct = this.edm.getComplexType(fullName);
                if (ct != null && ct.compatibleTo(prevType3)) {
                    UriResourceStartingTypeFilterImpl resourcePart = new UriResourceStartingTypeFilterImpl();
                    resourcePart.setCollectionTypeFilter((EdmType)ct);
                    uriInfo.addResourcePart((UriResourceImpl)resourcePart);
                    return this;
                }
            } else {
                if (!(prevType3 instanceof EdmEntityType)) throw this.wrap((UriParserException)new UriParserSemanticException("prev segement must be comlex of entity type", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
                throw this.wrap((UriParserException)new UriParserSemanticException("Error", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
        }
        prevType = null;
        if (this.context.contextSelectItem.getResourcePath() == null) {
            prevType = ((TypeInformation)this.context.contextTypes.peek()).type;
        } else {
            UriInfoImpl uriInfo = (UriInfoImpl)this.context.contextSelectItem.getResourcePath();
            UriResource last = uriInfo.getLastResourcePart();
            if (!(last instanceof UriResourceTypedImpl)) {
                throw this.wrap((UriParserException)new UriParserSemanticException("prev segement typed", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]));
            }
            prevType = this.getTypeInformation((UriResource)last).type;
        }
        FullQualifiedName finalTypeName = new FullQualifiedName(prevType.getNamespace(), prevType.getName());
        EdmAction action = this.edm.getBoundAction(fullName, finalTypeName, null);
        if (action != null) {
            UriResourceActionImpl uriAction = new UriResourceActionImpl();
            uriAction.setAction(action);
            UriInfoImpl resourcePath = (UriInfoImpl)this.context.contextSelectItem.getResourcePath();
            resourcePath.addResourcePart((UriResourceImpl)uriAction);
        }
        if ((function = this.edm.getBoundFunction(fullName, finalTypeName, null, null)) == null) return null;
        UriResourceFunctionImpl uriFunction = new UriResourceFunctionImpl();
        uriFunction.setFunction(function);
        UriInfoImpl resourcePath = (UriInfoImpl)this.context.contextSelectItem.getResourcePath();
        resourcePath.addResourcePart((UriResourceImpl)uriFunction);
        return null;
    }

    public Object visitSkip(UriParserParser.SkipContext ctx) {
        SkipOptionImpl skiptoken = new SkipOptionImpl();
        String text = ((ParseTree)ctx.children.get(2)).getText();
        return skiptoken.setValue(Integer.parseInt(text)).setText(text);
    }

    public Object visitSkiptoken(UriParserParser.SkiptokenContext ctx) {
        SkipTokenOptionImpl skiptoken = new SkipTokenOptionImpl();
        String text = ((ParseTree)ctx.children.get(2)).getText();
        return skiptoken.setValue(text).setText(text);
    }

    public ExpressionImpl visitStartsWithMethodCallExpr(UriParserParser.StartsWithMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.STARTSWITH).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this)).addParameter((ExpressionImpl)ctx.vE2.accept((ParseTreeVisitor)this));
    }

    public ExpressionImpl visitSubstringMethodCallExpr(UriParserParser.SubstringMethodCallExprContext ctx) {
        MethodImpl ret = new MethodImpl();
        ret.setMethod(MethodKind.SUBSTRING);
        ret.addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
        ret.addParameter((ExpressionImpl)ctx.vE2.accept((ParseTreeVisitor)this));
        if (ctx.vE3 != null) {
            ret.addParameter((ExpressionImpl)ctx.vE3.accept((ParseTreeVisitor)this));
        }
        return ret;
    }

    public ExpressionImpl visitTimeMethodCallExpr(UriParserParser.TimeMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.TIME).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public Object visitTop(UriParserParser.TopContext ctx) {
        TopOptionImpl top = new TopOptionImpl();
        String text = ((ParseTree)ctx.children.get(2)).getText();
        return top.setValue(Integer.parseInt(text)).setText(text);
    }

    public ExpressionImpl visitToLowerMethodCallExpr(UriParserParser.ToLowerMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.TOLOWER).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public ExpressionImpl visitTotalOffsetMinutesMethodCallExpr(UriParserParser.TotalOffsetMinutesMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.TOTALOFFSETMINUTES).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public ExpressionImpl visitTotalsecondsMethodCallExpr(UriParserParser.TotalsecondsMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.TOTALSECONDS).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public ExpressionImpl visitToUpperMethodCallExpr(UriParserParser.ToUpperMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.TOUPPER).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public ExpressionImpl visitTrimMethodCallExpr(UriParserParser.TrimMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.TRIM).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    public ExpressionImpl visitYearMethodCallExpr(UriParserParser.YearMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.YEAR).addParameter((ExpressionImpl)ctx.vE1.accept((ParseTreeVisitor)this));
    }

    private ParseCancellationException wrap(UriParserException uriParserException) {
        return new ParseCancellationException((Throwable)uriParserException);
    }
}

