/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoKind;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;
import org.apache.olingo.server.core.uri.UriInfoImpl;
import org.apache.olingo.server.core.uri.antlr.UriLexer;
import org.apache.olingo.server.core.uri.antlr.UriParserParser;
import org.apache.olingo.server.core.uri.parser.CheckFullContextListener;
import org.apache.olingo.server.core.uri.parser.Parser;
import org.apache.olingo.server.core.uri.parser.RawUri;
import org.apache.olingo.server.core.uri.parser.UriContext;
import org.apache.olingo.server.core.uri.parser.UriDecoder;
import org.apache.olingo.server.core.uri.parser.UriParseTreeVisitor;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.queryoption.CountOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.CustomQueryOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.ExpandOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.FilterOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.FormatOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.IdOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.OrderByOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.QueryOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SelectOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SkipOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SkipTokenOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SystemQueryOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.TopOptionImpl;

public class Parser {
    int logLevel = 0;

    public Parser setLogLevel(int logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public UriInfo parseUri(String input, Edm edm) throws UriParserException {
        boolean readQueryParameter = false;
        boolean readFragment = false;
        UriContext context = new UriContext();
        UriParseTreeVisitor uriParseTreeVisitor = new UriParseTreeVisitor(edm, context);
        try {
            UriParserParser.AllEOFContext ctxResourcePathEOF;
            RawUri uri = UriDecoder.decodeUri((String)input, (int)0);
            String firstSegment = "";
            if (uri.pathSegmentListDecoded.size() > 0) {
                firstSegment = (String)uri.pathSegmentListDecoded.get(0);
            }
            if (firstSegment.length() == 0) {
                readQueryParameter = true;
                context.contextUriInfo = new UriInfoImpl().setKind(UriInfoKind.service);
            } else if (firstSegment.startsWith("$batch")) {
                UriParserParser.BatchEOFContext ctxBatchEOF = (UriParserParser.BatchEOFContext)this.parseRule((String)uri.pathSegmentListDecoded.get(0), ParserEntryRules.Batch);
                uriParseTreeVisitor.visitBatchEOF(ctxBatchEOF);
                readQueryParameter = true;
            } else if (firstSegment.startsWith("$metadata")) {
                UriParserParser.MetadataEOFContext ctxMetadataEOF = (UriParserParser.MetadataEOFContext)this.parseRule((String)uri.pathSegmentListDecoded.get(0), ParserEntryRules.Metadata);
                uriParseTreeVisitor.visitMetadataEOF(ctxMetadataEOF);
                readQueryParameter = true;
                readFragment = true;
            } else if (firstSegment.startsWith("$entity")) {
                context.contextUriInfo = new UriInfoImpl().setKind(UriInfoKind.entityId);
                if (uri.pathSegmentListDecoded.size() > 1) {
                    UriParserParser.EntityEOFContext ctxEntityEOF = (UriParserParser.EntityEOFContext)this.parseRule((String)uri.pathSegmentListDecoded.get(1), ParserEntryRules.Entity);
                    uriParseTreeVisitor.visitEntityEOF(ctxEntityEOF);
                }
                readQueryParameter = true;
            } else if (firstSegment.startsWith("$all")) {
                ctxResourcePathEOF = (UriParserParser.AllEOFContext)this.parseRule((String)uri.pathSegmentListDecoded.get(0), ParserEntryRules.All);
                uriParseTreeVisitor.visitAllEOF(ctxResourcePathEOF);
                readQueryParameter = true;
            } else if (firstSegment.startsWith("$crossjoin")) {
                ctxResourcePathEOF = (UriParserParser.CrossjoinEOFContext)this.parseRule((String)uri.pathSegmentListDecoded.get(0), ParserEntryRules.CrossJoin);
                uriParseTreeVisitor.visitCrossjoinEOF((UriParserParser.CrossjoinEOFContext)ctxResourcePathEOF);
                readQueryParameter = true;
            } else {
                ArrayList<UriParserParser.PathSegmentEOFContext> ctxPathSegments = new ArrayList<UriParserParser.PathSegmentEOFContext>();
                for (String pathSegment : uri.pathSegmentListDecoded) {
                    UriParserParser.PathSegmentEOFContext ctxPathSegment = (UriParserParser.PathSegmentEOFContext)this.parseRule(pathSegment, ParserEntryRules.PathSegment);
                    ctxPathSegments.add(ctxPathSegment);
                }
                context.contextUriInfo = new UriInfoImpl().setKind(UriInfoKind.resource);
                for (UriParserParser.PathSegmentEOFContext ctxPathSegment : ctxPathSegments) {
                    uriParseTreeVisitor.visitPathSegmentEOF(ctxPathSegment);
                }
                UriResource lastSegment = context.contextUriInfo.getLastResourcePart();
                if (lastSegment instanceof UriResourcePartTyped) {
                    UriResourcePartTyped typed = (UriResourcePartTyped)lastSegment;
                    UriParseTreeVisitor.TypeInformation myType = uriParseTreeVisitor.getTypeInformation((UriResource)typed);
                    UriParseTreeVisitor uriParseTreeVisitor2 = uriParseTreeVisitor;
                    uriParseTreeVisitor2.getClass();
                    UriParseTreeVisitor.TypeInformation typeInfo = new UriParseTreeVisitor.TypeInformation(uriParseTreeVisitor2, myType.type, typed.isCollection());
                    context.contextTypes.push(typeInfo);
                }
                readQueryParameter = true;
            }
            if (readQueryParameter) {
                for (RawUri.QueryOption option : uri.queryOptionListDecoded) {
                    UriParserParser.FilterExpressionEOFContext ctxFilterExpression;
                    if (!option.name.startsWith("$")) {
                        CustomQueryOptionImpl customOption = new CustomQueryOptionImpl();
                        customOption.setName(option.name);
                        customOption.setText(option.value);
                        context.contextUriInfo.addCustomQueryOption((QueryOptionImpl)customOption);
                        continue;
                    }
                    if (option.name.equals(SystemQueryOptionKind.FILTER.toString())) {
                        ctxFilterExpression = (UriParserParser.FilterExpressionEOFContext)this.parseRule(option.value, ParserEntryRules.FilterExpression);
                        FilterOptionImpl filterOption = (FilterOptionImpl)uriParseTreeVisitor.visitFilterExpressionEOF(ctxFilterExpression);
                        context.contextUriInfo.setSystemQueryOption((SystemQueryOptionImpl)filterOption);
                        continue;
                    }
                    if (option.name.equals(SystemQueryOptionKind.FORMAT.toString())) {
                        FormatOptionImpl formatOption = new FormatOptionImpl();
                        formatOption.setName(option.name);
                        formatOption.setText(option.value);
                        if (!(option.value.equalsIgnoreCase(ODataFormat.JSON.name()) || option.value.equalsIgnoreCase(ODataFormat.XML.name()) || option.value.equalsIgnoreCase(ODataFormat.ATOM.name()) || this.isFormatSyntaxValid(option))) {
                            throw new UriParserSemanticException("Illegal value of $format option!", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]);
                        }
                        formatOption.setFormat(option.value);
                        context.contextUriInfo.setSystemQueryOption((SystemQueryOptionImpl)formatOption);
                        continue;
                    }
                    if (option.name.equals(SystemQueryOptionKind.EXPAND.toString())) {
                        UriParserParser.ExpandItemsEOFContext ctxExpandItems = (UriParserParser.ExpandItemsEOFContext)this.parseRule(option.value, ParserEntryRules.ExpandItems);
                        ExpandOptionImpl expandOption = (ExpandOptionImpl)uriParseTreeVisitor.visitExpandItemsEOF(ctxExpandItems);
                        context.contextUriInfo.setSystemQueryOption((SystemQueryOptionImpl)expandOption);
                        continue;
                    }
                    if (option.name.equals(SystemQueryOptionKind.ID.toString())) {
                        IdOptionImpl idOption = new IdOptionImpl();
                        idOption.setName(option.name);
                        idOption.setText(option.value);
                        idOption.setValue(option.value);
                        context.contextUriInfo.setSystemQueryOption((SystemQueryOptionImpl)idOption);
                        continue;
                    }
                    if (option.name.equals(SystemQueryOptionKind.LEVELS.toString())) {
                        throw new UriParserSyntaxException("System query option '$levels' is allowed only inside '$expand'!", (ODataTranslatedException.MessageKey)UriParserSyntaxException.MessageKeys.TEST, new String[0]);
                    }
                    if (option.name.equals(SystemQueryOptionKind.ORDERBY.toString())) {
                        ctxFilterExpression = (UriParserParser.OrderByEOFContext)this.parseRule(option.value, ParserEntryRules.Orderby);
                        OrderByOptionImpl orderByOption = (OrderByOptionImpl)uriParseTreeVisitor.visitOrderByEOF((UriParserParser.OrderByEOFContext)ctxFilterExpression);
                        context.contextUriInfo.setSystemQueryOption((SystemQueryOptionImpl)orderByOption);
                        continue;
                    }
                    if (option.name.equals(SystemQueryOptionKind.SEARCH.toString())) {
                        throw new RuntimeException("System query option '$search' not implemented!");
                    }
                    if (option.name.equals(SystemQueryOptionKind.SELECT.toString())) {
                        UriParserParser.SelectEOFContext ctxSelectEOF = (UriParserParser.SelectEOFContext)this.parseRule(option.value, ParserEntryRules.Select);
                        SelectOptionImpl selectOption = (SelectOptionImpl)uriParseTreeVisitor.visitSelectEOF(ctxSelectEOF);
                        context.contextUriInfo.setSystemQueryOption((SystemQueryOptionImpl)selectOption);
                        continue;
                    }
                    if (option.name.equals(SystemQueryOptionKind.SKIP.toString())) {
                        SkipOptionImpl skipOption = new SkipOptionImpl();
                        skipOption.setName(option.name);
                        skipOption.setText(option.value);
                        try {
                            skipOption.setValue(Integer.parseInt(option.value));
                        }
                        catch (NumberFormatException e) {
                            throw new UriParserSemanticException("Illegal value of $skip option!", (Throwable)e, (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]);
                        }
                        context.contextUriInfo.setSystemQueryOption((SystemQueryOptionImpl)skipOption);
                        continue;
                    }
                    if (option.name.equals(SystemQueryOptionKind.SKIPTOKEN.toString())) {
                        SkipTokenOptionImpl skipTokenOption = new SkipTokenOptionImpl();
                        skipTokenOption.setName(option.name);
                        skipTokenOption.setText(option.value);
                        skipTokenOption.setValue(option.value);
                        context.contextUriInfo.setSystemQueryOption((SystemQueryOptionImpl)skipTokenOption);
                        continue;
                    }
                    if (option.name.equals(SystemQueryOptionKind.TOP.toString())) {
                        TopOptionImpl topOption = new TopOptionImpl();
                        topOption.setName(option.name);
                        topOption.setText(option.value);
                        try {
                            topOption.setValue(Integer.parseInt(option.value));
                        }
                        catch (NumberFormatException e) {
                            throw new UriParserSemanticException("Illegal value of $top option!", (Throwable)e, (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]);
                        }
                        context.contextUriInfo.setSystemQueryOption((SystemQueryOptionImpl)topOption);
                        continue;
                    }
                    if (option.name.equals(SystemQueryOptionKind.COUNT.toString())) {
                        CountOptionImpl inlineCountOption = new CountOptionImpl();
                        inlineCountOption.setName(option.name);
                        inlineCountOption.setText(option.value);
                        if (!option.value.equals("true") && !option.value.equals("false")) {
                            throw new UriParserSemanticException("Illegal value of $count option!", (ODataTranslatedException.MessageKey)UriParserSemanticException.MessageKeys.TEST, new String[0]);
                        }
                        inlineCountOption.setValue(Boolean.parseBoolean(option.value));
                        context.contextUriInfo.setSystemQueryOption((SystemQueryOptionImpl)inlineCountOption);
                        continue;
                    }
                    throw new UriParserSyntaxException("Unknown system query option!", (ODataTranslatedException.MessageKey)UriParserSyntaxException.MessageKeys.TEST, new String[0]);
                }
            }
            if (readFragment) {
                context.contextUriInfo.setFragment(uri.fragment);
            }
            return context.contextUriInfo;
        }
        catch (ParseCancellationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UriParserException) {
                throw (UriParserException)cause;
            }
            return null;
        }
    }

    private boolean isFormatSyntaxValid(RawUri.QueryOption option) {
        int index = option.value.indexOf(47);
        return index > 0 && index < option.value.length() - 1 && index == option.value.lastIndexOf(47);
    }

    private ParserRuleContext parseRule(String input, ParserEntryRules entryPoint) throws UriParserSyntaxException {
        UriParserParser parser = null;
        UriLexer lexer = null;
        UriParserParser.AllEOFContext ret = null;
        try {
            if (this.logLevel > 0) {
                lexer = new UriLexer((CharStream)new ANTLRInputStream(input));
                this.showTokens(input, lexer.getAllTokens());
            }
            lexer = new UriLexer((CharStream)new ANTLRInputStream(input));
            parser = new UriParserParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            this.addStage1ErrorStategy(parser);
            this.addStage1ErrorListener(parser);
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            switch (1.$SwitchMap$org$apache$olingo$server$core$uri$parser$Parser$ParserEntryRules[entryPoint.ordinal()]) {
                case 1: {
                    ret = parser.allEOF();
                    break;
                }
                case 2: {
                    ret = parser.batchEOF();
                    break;
                }
                case 3: {
                    ret = parser.crossjoinEOF();
                    break;
                }
                case 4: {
                    ret = parser.metadataEOF();
                    break;
                }
                case 5: {
                    ret = parser.pathSegmentEOF();
                    break;
                }
                case 6: {
                    lexer.mode(0);
                    ret = parser.filterExpressionEOF();
                    break;
                }
                case 7: {
                    lexer.mode(0);
                    ret = parser.orderByEOF();
                    break;
                }
                case 8: {
                    lexer.mode(0);
                    ret = parser.expandItemsEOF();
                    break;
                }
                case 9: {
                    ret = parser.entityEOF();
                    break;
                }
                case 10: {
                    ret = parser.selectEOF();
                    break;
                }
            }
        }
        catch (ParseCancellationException hardException) {
            try {
                lexer = new UriLexer((CharStream)new ANTLRInputStream(input));
                parser = new UriParserParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
                this.addStage2ErrorStategy(parser);
                this.addStage2ErrorListener(parser);
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                switch (1.$SwitchMap$org$apache$olingo$server$core$uri$parser$Parser$ParserEntryRules[entryPoint.ordinal()]) {
                    case 1: {
                        ret = parser.allEOF();
                        break;
                    }
                    case 2: {
                        ret = parser.batchEOF();
                        break;
                    }
                    case 3: {
                        ret = parser.crossjoinEOF();
                        break;
                    }
                    case 4: {
                        ret = parser.metadataEOF();
                        break;
                    }
                    case 5: {
                        ret = parser.pathSegmentEOF();
                        break;
                    }
                    case 6: {
                        lexer.mode(0);
                        ret = parser.filterExpressionEOF();
                        break;
                    }
                    case 7: {
                        lexer.mode(0);
                        ret = parser.orderByEOF();
                        break;
                    }
                    case 8: {
                        lexer.mode(0);
                        ret = parser.expandItemsEOF();
                        break;
                    }
                    case 9: {
                        ret = parser.entityEOF();
                        break;
                    }
                    case 10: {
                        ret = parser.selectEOF();
                        break;
                    }
                }
            }
            catch (Exception weakException) {
                throw new UriParserSyntaxException("Error in syntax", (Throwable)weakException, (ODataTranslatedException.MessageKey)UriParserSyntaxException.MessageKeys.TEST, new String[0]);
            }
        }
        catch (Exception hardException) {
            throw new UriParserSyntaxException("Error in syntax", (Throwable)hardException, (ODataTranslatedException.MessageKey)UriParserSyntaxException.MessageKeys.TEST, new String[0]);
        }
        return ret;
    }

    protected void addStage1ErrorStategy(UriParserParser parser) {
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
    }

    protected void addStage2ErrorStategy(UriParserParser parser) {
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
    }

    protected void addStage1ErrorListener(UriParserParser parser) {
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new CheckFullContextListener());
    }

    protected void addStage2ErrorListener(UriParserParser parser) {
        parser.removeErrorListeners();
    }

    public void showTokens(String input, List<? extends Token> list) {
        boolean first = true;
        System.out.println("input: " + input);
        String nL = "\n";
        String out = "[" + nL;
        for (Token token : list) {
            int index;
            if (!first) {
                out = out + ",";
                first = false;
            }
            if ((index = token.getType()) != -1) {
                out = out + "\"" + token.getText() + "\"" + "     " + UriLexer.tokenNames[index] + nL;
                continue;
            }
            out = out + "\"" + token.getText() + "\"" + "     " + index + nL;
        }
        out = out + ']';
        System.out.println("tokens: " + out);
    }
}

