/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.olingo.server.core.serializer.utils.CircleStreamBuffer;

public class CircleStreamBuffer {
    private static final int NEW_BUFFER_RESIZE_FACTOR = 2;
    private static final int READ_EOF = -1;
    private static final int DEFAULT_CAPACITY = 8192;
    private static final int MAX_CAPACITY = 262144;
    private int currentAllocateCapacity = 8192;
    private boolean writeMode = true;
    private boolean writeClosed = false;
    private boolean readClosed = false;
    private Queue<ByteBuffer> bufferQueue = new LinkedBlockingQueue();
    private ByteBuffer currentWriteBuffer;
    private InternalInputStream inStream;
    private InternalOutputStream outStream;

    public CircleStreamBuffer() {
        this(8192);
    }

    public CircleStreamBuffer(int bufferSize) {
        this.currentAllocateCapacity = bufferSize;
        this.createNewWriteBuffer();
        this.inStream = new InternalInputStream(this);
        this.outStream = new InternalOutputStream(this);
    }

    public InputStream getInputStream() {
        return this.inStream;
    }

    public OutputStream getOutputStream() {
        return this.outStream;
    }

    public void closeWrite() {
        this.writeClosed = true;
    }

    public void closeRead() {
        this.readClosed = true;
        ByteBuffer buffer = (ByteBuffer)this.bufferQueue.poll();
        while (buffer != null) {
            buffer.clear();
            buffer = (ByteBuffer)this.bufferQueue.poll();
        }
    }

    public void close() {
        this.closeWrite();
        this.closeRead();
    }

    private int remaining() throws IOException {
        if (this.writeMode) {
            return this.currentWriteBuffer.remaining();
        }
        ByteBuffer toRead = this.getReadBuffer();
        if (toRead == null) {
            return 0;
        }
        return toRead.remaining();
    }

    private ByteBuffer getReadBuffer() throws IOException {
        if (this.readClosed) {
            throw new IOException("Tried to read from closed stream.");
        }
        boolean next = false;
        ByteBuffer tmp = null;
        if (this.writeMode) {
            this.writeMode = false;
            next = true;
        } else {
            tmp = (ByteBuffer)this.bufferQueue.peek();
            if (tmp != null && !tmp.hasRemaining()) {
                tmp = (ByteBuffer)this.bufferQueue.poll();
                next = true;
            }
        }
        if (next) {
            tmp = (ByteBuffer)this.bufferQueue.peek();
            if (tmp != null) {
                tmp.flip();
            }
            tmp = this.getReadBuffer();
        }
        return tmp;
    }

    private int read(byte[] b, int off, int len) throws IOException {
        ByteBuffer readBuffer = this.getReadBuffer();
        if (readBuffer == null) {
            return -1;
        }
        int toReadLength = readBuffer.remaining();
        if (len < toReadLength) {
            toReadLength = len;
        }
        readBuffer.get(b, off, toReadLength);
        return toReadLength;
    }

    private int read() throws IOException {
        ByteBuffer readBuffer = this.getReadBuffer();
        if (readBuffer == null) {
            return -1;
        }
        return readBuffer.get();
    }

    private void write(byte[] data, int off, int len) throws IOException {
        ByteBuffer writeBuffer = this.getWriteBuffer(len);
        writeBuffer.put(data, off, len);
    }

    private ByteBuffer getWriteBuffer(int size) throws IOException {
        if (this.writeClosed) {
            throw new IOException("Tried to write into closed stream.");
        }
        if (this.writeMode) {
            if (this.remaining() < size) {
                this.createNewWriteBuffer(size);
            }
        } else {
            this.writeMode = true;
            this.createNewWriteBuffer();
        }
        return this.currentWriteBuffer;
    }

    private void write(int b) throws IOException {
        ByteBuffer writeBuffer = this.getWriteBuffer(1);
        writeBuffer.put((byte)b);
    }

    private void createNewWriteBuffer() {
        this.createNewWriteBuffer(this.currentAllocateCapacity);
    }

    private void createNewWriteBuffer(int requestedCapacity) {
        ByteBuffer b = this.allocateBuffer(requestedCapacity);
        this.bufferQueue.add(b);
        this.currentWriteBuffer = b;
    }

    private ByteBuffer allocateBuffer(int requestedCapacity) {
        int allocateCapacity = requestedCapacity;
        if (allocateCapacity < this.currentAllocateCapacity) {
            allocateCapacity = this.currentAllocateCapacity * 2;
        }
        if (allocateCapacity > 262144) {
            allocateCapacity = 262144;
        }
        this.currentAllocateCapacity = allocateCapacity;
        return ByteBuffer.allocate(allocateCapacity);
    }

    static /* synthetic */ int access$000(CircleStreamBuffer x0) throws IOException {
        return x0.remaining();
    }

    static /* synthetic */ int access$100(CircleStreamBuffer x0) throws IOException {
        return x0.read();
    }

    static /* synthetic */ int access$200(CircleStreamBuffer x0, byte[] x1, int x2, int x3) throws IOException {
        return x0.read(x1, x2, x3);
    }

    static /* synthetic */ void access$300(CircleStreamBuffer x0, int x1) throws IOException {
        x0.write(x1);
    }

    static /* synthetic */ void access$400(CircleStreamBuffer x0, byte[] x1, int x2, int x3) throws IOException {
        x0.write(x1, x2, x3);
    }
}

