/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.edm.provider;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmMember;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.AbstractEdmEnumType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.edm.provider.EnumMember;
import org.apache.olingo.server.api.edm.provider.EnumType;
import org.apache.olingo.server.core.edm.provider.EdmMemberImpl;

public class EdmEnumTypeImpl
extends AbstractEdmEnumType {
    private final EdmPrimitiveType underlyingType;
    private final EnumType enumType;
    private List<EdmMember> members;

    public EdmEnumTypeImpl(Edm edm, FullQualifiedName enumName, EnumType enumType) {
        super(edm, enumName, enumType.isFlags());
        this.underlyingType = enumType.getUnderlyingType() == null ? EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int32) : EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.valueOf((String)enumType.getUnderlyingType().getName()));
        this.enumType = enumType;
    }

    public EdmPrimitiveType getUnderlyingType() {
        return this.underlyingType;
    }

    protected List<? extends EdmMember> getMembers() {
        if (this.members == null) {
            this.members = new ArrayList(this.enumType.getMembers().size());
            for (EnumMember member : this.enumType.getMembers()) {
                this.members.add(new EdmMemberImpl(this.edm, this.getFullQualifiedName(), member.getName(), member.getValue()));
            }
        }
        return this.members;
    }
}

