/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.processor.DefaultProcessor;
import org.apache.olingo.server.api.processor.EntityCollectionProcessor;
import org.apache.olingo.server.api.processor.EntityProcessor;
import org.apache.olingo.server.api.processor.ExceptionProcessor;
import org.apache.olingo.server.api.processor.MetadataProcessor;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.api.processor.ServiceDocumentProcessor;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.core.ContentNegotiator;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.DefaultRedirectProcessor;
import org.apache.olingo.server.core.ODataExceptionHelper;
import org.apache.olingo.server.core.ODataHandler;
import org.apache.olingo.server.core.RedirectProcessor;
import org.apache.olingo.server.core.uri.parser.Parser;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.validator.UriValidationException;
import org.apache.olingo.server.core.uri.validator.UriValidator;

public class ODataHandler {
    private final OData odata;
    private final Edm edm;
    private final Map<Class<? extends Processor>, Processor> processors = new HashMap();

    public ODataHandler(OData server, Edm edm) {
        this.odata = server;
        this.edm = edm;
        this.register((Processor)new DefaultProcessor());
        this.register((Processor)new DefaultRedirectProcessor());
    }

    public ODataResponse process(ODataRequest request) {
        ContentType requestedContentType = null;
        ODataResponse response = new ODataResponse();
        try {
            this.processInternal(request, requestedContentType, response);
        }
        catch (UriParserException e) {
            e.printStackTrace();
        }
        catch (ContentNegotiatorException e) {
            Locale requestedLocale = null;
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject((ODataTranslatedException)((Object)e), (int)HttpStatusCode.NOT_ACCEPTABLE.getStatusCode(), requestedLocale);
            this.handleException(request, response, serverError, requestedContentType);
        }
        catch (ODataTranslatedException e) {
            Locale requestedLocale = null;
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject((ODataTranslatedException)e, (int)response.getStatusCode(), requestedLocale);
            this.handleException(request, response, serverError, requestedContentType);
        }
        catch (ODataApplicationException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject((ODataApplicationException)e);
            this.handleException(request, response, serverError, requestedContentType);
        }
        catch (Exception e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject((Exception)e, (int)response.getStatusCode());
            this.handleException(request, response, serverError, requestedContentType);
        }
        return response;
    }

    private void processInternal(ODataRequest request, ContentType requestedContentType, ODataResponse response) throws ODataTranslatedException, UriParserException, UriValidationException, ContentNegotiatorException, ODataApplicationException {
        this.validateODataVersion(request, response);
        Parser parser = new Parser();
        String odUri = request.getRawODataPath() + (request.getRawQueryPath() == null ? "" : "?" + request.getRawQueryPath());
        UriInfo uriInfo = parser.parseUri(odUri, this.edm);
        UriValidator validator = new UriValidator();
        validator.validate(uriInfo, request.getMethod());
        switch (1.$SwitchMap$org$apache$olingo$server$api$uri$UriInfoKind[uriInfo.getKind().ordinal()]) {
            case 1: {
                MetadataProcessor mp = (MetadataProcessor)this.selectProcessor(MetadataProcessor.class, response);
                requestedContentType = ContentNegotiator.doContentNegotiation((FormatOption)uriInfo.getFormatOption(), (ODataRequest)request, (Processor)mp, MetadataProcessor.class);
                mp.readMetadata(request, response, uriInfo, requestedContentType);
                break;
            }
            case 2: {
                if ("".equals(request.getRawODataPath())) {
                    RedirectProcessor rdp = (RedirectProcessor)this.selectProcessor(RedirectProcessor.class, response);
                    rdp.redirect(request, response);
                    break;
                }
                ServiceDocumentProcessor sdp = (ServiceDocumentProcessor)this.selectProcessor(ServiceDocumentProcessor.class, response);
                requestedContentType = ContentNegotiator.doContentNegotiation((FormatOption)uriInfo.getFormatOption(), (ODataRequest)request, (Processor)sdp, ServiceDocumentProcessor.class);
                sdp.readServiceDocument(request, response, uriInfo, requestedContentType);
                break;
            }
            case 3: {
                this.handleResourceDispatching(request, response, uriInfo);
                break;
            }
            default: {
                response.setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
                throw new ODataTranslatedException("not implemented", (ODataTranslatedException.MessageKey)ODataTranslatedException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
        }
    }

    private void handleException(ODataRequest request, ODataResponse response, ODataServerError serverError, ContentType requestedContentType) {
        ExceptionProcessor exceptionProcessor;
        try {
            exceptionProcessor = (ExceptionProcessor)this.selectProcessor(ExceptionProcessor.class, response);
        }
        catch (ODataTranslatedException e) {
            exceptionProcessor = new DefaultProcessor();
        }
        if (requestedContentType == null) {
            requestedContentType = ODataFormat.JSON.getContentType(ODataServiceVersion.V40);
        }
        exceptionProcessor.processException(request, response, serverError, requestedContentType);
    }

    private void handleResourceDispatching(ODataRequest request, ODataResponse response, UriInfo uriInfo) throws ODataTranslatedException {
        int lastPathSegmentIndex = uriInfo.getUriResourceParts().size() - 1;
        UriResource lastPathSegment = (UriResource)uriInfo.getUriResourceParts().get(lastPathSegmentIndex);
        ContentType requestedContentType = null;
        switch (1.$SwitchMap$org$apache$olingo$server$api$uri$UriResourceKind[lastPathSegment.getKind().ordinal()]) {
            case 1: {
                if (((UriResourcePartTyped)lastPathSegment).isCollection()) {
                    if (request.getMethod().equals((Object)HttpMethod.GET)) {
                        EntityCollectionProcessor cp = (EntityCollectionProcessor)this.selectProcessor(EntityCollectionProcessor.class, response);
                        requestedContentType = ContentNegotiator.doContentNegotiation((FormatOption)uriInfo.getFormatOption(), (ODataRequest)request, (Processor)cp, EntityCollectionProcessor.class);
                        cp.readCollection(request, response, uriInfo, requestedContentType);
                        break;
                    }
                    response.setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
                    throw new ODataTranslatedException("not implemented", (ODataTranslatedException.MessageKey)ODataTranslatedException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
                }
                if (request.getMethod().equals((Object)HttpMethod.GET)) {
                    EntityProcessor ep = (EntityProcessor)this.selectProcessor(EntityProcessor.class, response);
                    requestedContentType = ContentNegotiator.doContentNegotiation((FormatOption)uriInfo.getFormatOption(), (ODataRequest)request, (Processor)ep, EntityProcessor.class);
                    ep.readEntity(request, response, uriInfo, requestedContentType);
                    break;
                }
                response.setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
                throw new ODataTranslatedException("not implemented", (ODataTranslatedException.MessageKey)ODataTranslatedException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
            case 2: {
                if (((UriResourceNavigation)lastPathSegment).isCollection()) {
                    if (request.getMethod().equals((Object)HttpMethod.GET)) {
                        EntityCollectionProcessor cp = (EntityCollectionProcessor)this.selectProcessor(EntityCollectionProcessor.class, response);
                        requestedContentType = ContentNegotiator.doContentNegotiation((FormatOption)uriInfo.getFormatOption(), (ODataRequest)request, (Processor)cp, EntityCollectionProcessor.class);
                        cp.readCollection(request, response, uriInfo, requestedContentType);
                        break;
                    }
                    response.setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
                    throw new ODataTranslatedException("not implemented", (ODataTranslatedException.MessageKey)ODataTranslatedException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
                }
                if (request.getMethod().equals((Object)HttpMethod.GET)) {
                    EntityProcessor ep = (EntityProcessor)this.selectProcessor(EntityProcessor.class, response);
                    requestedContentType = ContentNegotiator.doContentNegotiation((FormatOption)uriInfo.getFormatOption(), (ODataRequest)request, (Processor)ep, EntityProcessor.class);
                    ep.readEntity(request, response, uriInfo, requestedContentType);
                    break;
                }
                response.setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
                throw new ODataTranslatedException("not implemented", (ODataTranslatedException.MessageKey)ODataTranslatedException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
            default: {
                response.setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
                throw new ODataTranslatedException("not implemented", (ODataTranslatedException.MessageKey)ODataTranslatedException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
        }
    }

    private void validateODataVersion(ODataRequest request, ODataResponse response) throws ODataTranslatedException {
        String maxVersion = request.getHeader("OData-MaxVersion");
        response.setHeader("OData-Version", ODataServiceVersion.V40.toString());
        if (maxVersion != null && ODataServiceVersion.isBiggerThan((String)ODataServiceVersion.V40.toString(), (String)maxVersion)) {
            response.setStatusCode(400);
            throw new ODataTranslatedException("ODataVersion not supported: " + maxVersion, (ODataTranslatedException.MessageKey)ODataTranslatedException.MessageKeys.ODATA_VERSION_NOT_SUPPORTED, new String[]{maxVersion});
        }
    }

    private <T extends Processor> T selectProcessor(Class<T> cls, ODataResponse response) throws ODataTranslatedException {
        Processor p = (Processor)this.processors.get(cls);
        if (p == null) {
            response.setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
            throw new ODataTranslatedException("Processor: " + cls.getName() + " not registered.", (ODataTranslatedException.MessageKey)ODataTranslatedException.MessageKeys.PROCESSOR_NOT_IMPLEMENTED, new String[]{cls.getName()});
        }
        return (T)p;
    }

    public void register(Processor processor) {
        processor.init(this.odata, this.edm);
        for (Class<?> cls : processor.getClass().getInterfaces()) {
            if (!Processor.class.isAssignableFrom(cls) || cls == Processor.class) continue;
            Class<?> procClass = cls;
            this.processors.put(procClass, processor);
        }
    }
}

