/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.api;

import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.olingo.commons.api.ODataException;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataTranslatedException
extends ODataException {
    private static final long serialVersionUID = -1210541002198287561L;
    private static final Logger log = LoggerFactory.getLogger(ODataTranslatedException.class);
    private static final String BUNDLE_NAME = "i18n";
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private MessageKey messageKey;
    private Object[] parameters;

    public ODataTranslatedException(String developmentMessage, MessageKey messageKey, String ... parameters) {
        super(developmentMessage);
        this.messageKey = messageKey;
        this.parameters = parameters;
    }

    public ODataTranslatedException(String developmentMessage, Throwable cause, MessageKey messageKey, String ... parameters) {
        super(developmentMessage, cause);
        this.messageKey = messageKey;
        this.parameters = parameters;
    }

    public String getLocalizedMessage() {
        return this.getTranslatedMessage(DEFAULT_LOCALE).getMessage();
    }

    public String toString() {
        return this.getMessage();
    }

    public MessageKey getMessageKey() {
        return this.messageKey;
    }

    public ODataErrorMessage getTranslatedMessage(Locale locale) {
        if (this.messageKey == null) {
            return new ODataErrorMessage(this, this.getMessage(), DEFAULT_LOCALE);
        }
        ResourceBundle bundle = this.createResourceBundle(locale);
        if (bundle == null) {
            return new ODataErrorMessage(this, this.getMessage(), DEFAULT_LOCALE);
        }
        return this.buildMessage(bundle, locale);
    }

    private ResourceBundle createResourceBundle(Locale locale) {
        ResourceBundle bundle = null;
        try {
            bundle = locale == null ? ResourceBundle.getBundle(BUNDLE_NAME, DEFAULT_LOCALE) : ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return bundle;
    }

    private ODataErrorMessage buildMessage(ResourceBundle bundle, Locale locale) {
        String message = null;
        try {
            message = bundle.getString(((Object)((Object)this)).getClass().getSimpleName() + '.' + this.messageKey);
            StringBuilder builder = new StringBuilder();
            Formatter f = new Formatter(builder, locale);
            f.format(message, this.parameters);
            f.close();
            Locale usedLocale = bundle.getLocale();
            if (usedLocale == Locale.ROOT || Locale.ROOT.equals(usedLocale)) {
                usedLocale = DEFAULT_LOCALE;
            }
            return new ODataErrorMessage(this, builder.toString(), usedLocale);
        }
        catch (MissingResourceException e) {
            return new ODataErrorMessage(this, "Missing message for key '" + this.messageKey + "'!", DEFAULT_LOCALE);
        }
        catch (MissingFormatArgumentException e) {
            return new ODataErrorMessage(this, "Missing replacement for place holder in message '" + message + "' for following arguments '" + Arrays.toString(this.parameters) + "'!", DEFAULT_LOCALE);
        }
    }
}

