/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.fit.utils.ConstantKey;
import org.apache.olingo.fit.utils.Constants;

public class XMLEventReaderWrapper
implements XMLEventReader {
    private static final Charset ENCODING = Charset.forName("UTF-8");
    public static final String CONTENT = "CONTENT_TAG";
    public final String CONTENT_STAG;
    public static final String CONTENT_ETAG = "</CONTENT_TAG>";
    private final XMLEventReader wrapped;
    private XMLEvent nextGivenEvent = null;

    public XMLEventReaderWrapper(InputStream stream, ODataServiceVersion version) throws IOException, XMLStreamException {
        StringBuilder startBuilder = new StringBuilder();
        startBuilder.append("<").append(CONTENT).append(" xmlns:m").append("=\"").append(Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.METADATA_NS)).append("\"").append(" xmlns:d").append("=\"").append(Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.DATASERVICES_NS)).append("\"").append(" xmlns:georss").append("=\"").append(Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.GEORSS_NS)).append("\"").append(" xmlns:gml").append("=\"").append(Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.GML_NS)).append("\"").append(">");
        this.CONTENT_STAG = startBuilder.toString();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream((this.CONTENT_STAG + IOUtils.toString((InputStream)stream, (Charset)ENCODING).replaceAll("^<\\?xml.*\\?>", "") + CONTENT_ETAG).getBytes(ENCODING)), Constants.DECODER);
        this.wrapped = factory.createXMLEventReader(reader);
        this.init();
    }

    private void init() {
        try {
            do {
                this.nextGivenEvent = this.wrapped.nextEvent();
            } while (this.nextGivenEvent.isStartDocument() || this.nextGivenEvent.isStartElement() && CONTENT.equals(this.nextGivenEvent.asStartElement().getName().getLocalPart()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        XMLEvent event = this.nextGivenEvent;
        if (!this.isValidEvent(event)) {
            throw new IllegalStateException("No event found");
        }
        this.nextGivenEvent = this.wrapped.hasNext() ? this.wrapped.nextEvent() : null;
        return event;
    }

    @Override
    public boolean hasNext() {
        return this.isValidEvent(this.nextGivenEvent);
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        return this.wrapped.peek();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return this.wrapped.getElementText();
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        XMLEvent tagEvent = this.wrapped.nextTag();
        if (this.isValidEvent(tagEvent)) {
            return tagEvent;
        }
        return null;
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        return this.wrapped.getProperty(string);
    }

    @Override
    public void close() throws XMLStreamException {
        this.wrapped.close();
    }

    @Override
    public Object next() {
        return this.wrapped.next();
    }

    @Override
    public void remove() {
        this.wrapped.remove();
    }

    private boolean isValidEvent(XMLEvent event) {
        return event != null && (!event.isEndElement() || !CONTENT.equals(event.asEndElement().getName().getLocalPart()));
    }
}

