/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.fit.utils.Constants;
import org.apache.olingo.fit.utils.XMLEventReaderWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLElement {
    private static final Logger LOG = LoggerFactory.getLogger(XMLElement.class);
    private StartElement start;
    private EndElement end;
    private ByteArrayOutputStream content = new ByteArrayOutputStream();

    public StartElement getStart() {
        return this.start;
    }

    public void setStart(StartElement start) {
        this.start = start;
    }

    public EndElement getEnd() {
        return this.end;
    }

    public void setEnd(EndElement end) {
        this.end = end;
    }

    public InputStream getContent() throws XMLStreamException {
        return new ByteArrayInputStream(this.content.toByteArray());
    }

    public XMLEventReader getContentReader(ODataServiceVersion version) throws XMLStreamException, IOException {
        return new XMLEventReaderWrapper(this.getContent(), version);
    }

    public void setContent(InputStream content) throws IOException {
        this.content.reset();
        InputStreamReader reader = new InputStreamReader(content, Constants.ENCODING);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.content, Constants.ENCODING);
        IOUtils.copyLarge((Reader)reader, (Writer)writer);
        writer.flush();
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((InputStream)content);
    }

    public InputStream toStream() {
        ByteArrayInputStream res;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, Constants.ENCODING);
            this.getStart().writeAsEncodedUnicode(osw);
            IOUtils.copy((InputStream)this.getContent(), (Writer)osw, (Charset)Constants.ENCODING);
            this.getEnd().writeAsEncodedUnicode(osw);
            osw.flush();
            osw.close();
            res = new ByteArrayInputStream(bos.toByteArray());
        }
        catch (IOException e) {
            LOG.error("Error serializing element", (Throwable)e);
            res = null;
        }
        catch (XMLStreamException e) {
            LOG.error("Error serializing element", (Throwable)e);
            res = null;
        }
        return res;
    }
}

