/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.utils;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class NavigationLinks {
    private final Map<String, List<InputStream>> inlines = new HashMap();
    private final Map<String, List<String>> links = new HashMap();

    public NavigationLinks addInlines(String name, InputStream inline) {
        return this.addInlines(name, Collections.singletonList(inline));
    }

    public NavigationLinks addInlines(String name, List<InputStream> inline) {
        List<InputStream> inlineStreams;
        if (this.inlines.containsKey(name)) {
            inlineStreams = (List)this.inlines.get(name);
        } else {
            inlineStreams = new ArrayList();
            this.inlines.put(name, inlineStreams);
        }
        inlineStreams.addAll(inline);
        return this;
    }

    public NavigationLinks addLinks(String name, String uri) {
        return this.addLinks(name, Collections.singletonList(uri));
    }

    public NavigationLinks addLinks(String name, List<String> uris) {
        List<String> current;
        if (this.links.containsKey(name)) {
            current = (List)this.links.get(name);
        } else {
            current = new ArrayList();
            this.links.put(name, current);
        }
        current.addAll(uris);
        return this;
    }

    public Set<String> getInlineNames() {
        return Collections.unmodifiableSet(this.inlines.keySet());
    }

    public Set<String> getLinkNames() {
        return Collections.unmodifiableSet(this.links.keySet());
    }

    public List<InputStream> getInlines(String name) {
        return Collections.unmodifiableList((List)this.inlines.get(name));
    }

    public List<String> getLinks(String name) {
        return Collections.unmodifiableList((List)this.links.get(name));
    }

    public Iterable<Map.Entry<String, List<InputStream>>> getInlines() {
        return this.inlines.entrySet();
    }

    public Iterable<Map.Entry<String, List<String>>> getLinks() {
        return this.links.entrySet();
    }

    public boolean contains(String name) {
        return this.links.containsKey(name) || this.inlines.containsKey(name);
    }

    public NavigationLinks remove(String name) {
        this.removeLink(name);
        this.removeInlines(name);
        return this;
    }

    public NavigationLinks removeLink(String name) {
        this.links.remove(name);
        return this;
    }

    public NavigationLinks removeInlines(String name) {
        if (this.inlines.containsKey(name)) {
            for (InputStream is : (List)this.inlines.get(name)) {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        this.links.remove(name);
        return this;
    }
}

