/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.fit.metadata.Metadata;
import org.apache.olingo.fit.utils.Accept;
import org.apache.olingo.fit.utils.Commons;
import org.apache.olingo.fit.utils.ConstantKey;
import org.apache.olingo.fit.utils.Constants;
import org.apache.olingo.fit.utils.FSManager;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class Commons {
    protected static final Logger LOG = LoggerFactory.getLogger(Commons.class);
    private static final EnumMap<ODataServiceVersion, Metadata> METADATA = new EnumMap(ODataServiceVersion.class);
    protected static final Pattern MULTIKEY_PATTERN = Pattern.compile("(.*=.*,?)+");
    protected static final Map<String, Integer> SEQUENCE = new HashMap();
    protected static final Map<String, Pair<String, EdmPrimitiveTypeKind>> MEDIA_CONTENT = new HashMap();

    public static Metadata getMetadata(ODataServiceVersion version) {
        if (!METADATA.containsKey(version)) {
            InputStream is = Commons.class.getResourceAsStream("/" + version.name() + "/metadata.xml");
            METADATA.put(version, new Metadata(is, version));
        }
        return (Metadata)METADATA.get(version);
    }

    public static Map<String, Pair<String, EdmPrimitiveTypeKind>> getMediaContent() {
        return MEDIA_CONTENT;
    }

    public static String getEntityURI(String entitySetName, String entityKey) {
        return entitySetName + (StringUtils.isNotBlank((String)entityKey) ? "(" + entityKey + ")" : "");
    }

    public static String getEntityBasePath(String entitySetName, String entityKey) {
        return entitySetName + File.separatorChar + (StringUtils.isNotBlank((String)entityKey) ? Commons.getEntityKey((String)entityKey) + File.separatorChar : "");
    }

    public static String getLinksURI(String entitySetName, String entityId, String linkName) throws IOException {
        return Commons.getEntityURI((String)entitySetName, (String)entityId) + "/" + linkName;
    }

    public static String getLinksPath(String entitySetName, String entityId, String linkName, Accept accept) throws IOException {
        return Commons.getLinksPath((ODataServiceVersion)ODataServiceVersion.V30, (String)Commons.getEntityBasePath((String)entitySetName, (String)entityId), (String)linkName, (Accept)accept);
    }

    public static String getLinksPath(ODataServiceVersion version, String basePath, String linkName, Accept accept) throws IOException {
        try {
            return FSManager.instance((ODataServiceVersion)version).getAbsolutePath(basePath + Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.LINKS_FILE_PATH) + File.separatorChar + linkName, accept);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static String getEntityKey(String entityId) {
        if (MULTIKEY_PATTERN.matcher(entityId).matches()) {
            String[] keys = entityId.split(",");
            StringBuilder keyBuilder = new StringBuilder();
            for (String part : keys) {
                if (keyBuilder.length() > 0) {
                    keyBuilder.append(" ");
                }
                keyBuilder.append(part.split("=")[1].replaceAll("'", "").trim());
            }
            return keyBuilder.toString();
        }
        return entityId.trim();
    }

    public static InputStream getLinksAsATOM(ODataServiceVersion version, Map.Entry<String, Collection<String>> link) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        builder.append("<links xmlns=\"").append(Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.DATASERVICES_NS)).append("\">");
        for (String uri : link.getValue()) {
            builder.append("<uri>");
            if (URI.create(uri).isAbsolute()) {
                builder.append(uri);
            } else {
                builder.append(Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.DEFAULT_SERVICE_URL)).append(uri);
            }
            builder.append("</uri>");
        }
        builder.append("</links>");
        return IOUtils.toInputStream((String)builder.toString(), (Charset)Constants.ENCODING);
    }

    public static InputStream getLinksAsJSON(ODataServiceVersion version, String entitySetName, Map.Entry<String, Collection<String>> link) throws IOException {
        ObjectNode links = new ObjectNode(JsonNodeFactory.instance);
        links.put(Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.JSON_ODATAMETADATA_NAME), Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.ODATA_METADATA_PREFIX) + entitySetName + "/$links/" + link.getKey());
        ArrayNode uris = new ArrayNode(JsonNodeFactory.instance);
        for (String uri : link.getValue()) {
            String absoluteURI = URI.create(uri).isAbsolute() ? uri : Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.DEFAULT_SERVICE_URL) + uri;
            uris.add((JsonNode)new ObjectNode(JsonNodeFactory.instance).put("url", absoluteURI));
        }
        if (uris.size() == 1) {
            links.setAll((ObjectNode)uris.get(0));
        } else {
            links.set("value", (JsonNode)uris);
        }
        return IOUtils.toInputStream((String)links.toString(), (Charset)Constants.ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream changeFormat(InputStream is, ODataServiceVersion version, Accept target) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)is, (OutputStream)bos);
            IOUtils.closeQuietly((InputStream)is);
            ObjectMapper mapper = new ObjectMapper(new JsonFactory().configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, true));
            JsonNode node = Commons.changeFormat((ObjectNode)((ObjectNode)mapper.readTree((InputStream)new ByteArrayInputStream(bos.toByteArray()))), (ODataServiceVersion)version, (Accept)target);
            InputStream inputStream = IOUtils.toInputStream((String)node.toString(), (Charset)Constants.ENCODING);
            return inputStream;
        }
        catch (Exception e) {
            LOG.error("Error changing format", (Throwable)e);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public static JsonNode changeFormat(ObjectNode node, ODataServiceVersion version, Accept target) {
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        switch (1.$SwitchMap$org$apache$olingo$fit$utils$Accept[target.ordinal()]) {
            case 1: {
                toBeRemoved.add(Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.JSON_ODATAMETADATA_NAME));
            }
            case 2: {
                toBeRemoved.add(Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.JSON_EDITLINK_NAME));
                toBeRemoved.add(Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.JSON_ID_NAME));
                toBeRemoved.add(Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.JSON_TYPE_NAME));
                Iterator fields = node.fields();
                while (fields.hasNext()) {
                    Map.Entry field = (Map.Entry)fields.next();
                    if (((String)field.getKey()).endsWith(Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.JSON_MEDIA_SUFFIX)) || ((String)field.getKey()).endsWith(Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.JSON_NAVIGATION_SUFFIX)) || ((String)field.getKey()).endsWith(Constants.get((ODataServiceVersion)version, (ConstantKey)ConstantKey.JSON_TYPE_SUFFIX))) {
                        toBeRemoved.add((String)field.getKey());
                        continue;
                    }
                    if (((JsonNode)field.getValue()).isObject()) {
                        Commons.changeFormat((ObjectNode)((ObjectNode)field.getValue()), (ODataServiceVersion)version, (Accept)target);
                        continue;
                    }
                    if (!((JsonNode)field.getValue()).isArray()) continue;
                    Iterator subItor = ((JsonNode)field.getValue()).elements();
                    while (subItor.hasNext()) {
                        JsonNode subNode = (JsonNode)subItor.next();
                        if (!subNode.isObject()) continue;
                        Commons.changeFormat((ObjectNode)((ObjectNode)subNode), (ODataServiceVersion)version, (Accept)target);
                    }
                }
            }
            case 3: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(target.name());
            }
        }
        node.remove(toBeRemoved);
        return node;
    }

    public static String getETag(String basePath, ODataServiceVersion version) throws Exception {
        try {
            InputStream is = FSManager.instance((ODataServiceVersion)version).readFile(basePath + "etag", Accept.TEXT);
            if (is.available() <= 0) {
                return null;
            }
            String etag = IOUtils.toString((InputStream)is);
            IOUtils.closeQuietly((InputStream)is);
            return etag;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map.Entry<String, String> parseEntityURI(String uri) {
        String eid;
        String es;
        String relPath = uri.substring(uri.lastIndexOf("/"));
        int branchIndex = relPath.indexOf(40);
        if (branchIndex > -1) {
            es = relPath.substring(0, branchIndex);
            eid = relPath.substring(branchIndex + 1, relPath.indexOf(41));
        } else {
            es = relPath;
            eid = null;
        }
        return new AbstractMap.SimpleEntry<String, Object>(es, eid);
    }

    static {
        SEQUENCE.put("Customer", 1000);
        SEQUENCE.put("CustomerInfo", 1000);
        SEQUENCE.put("Car", 1000);
        SEQUENCE.put("Message", 1000);
        SEQUENCE.put("OrderDetails", 1000);
        SEQUENCE.put("Order", 1000);
        SEQUENCE.put("Product", 1000);
        SEQUENCE.put("ComputerDetail", 1000);
        SEQUENCE.put("AllGeoTypesSet", 1000);
        SEQUENCE.put("Orders", 1000);
        SEQUENCE.put("Customers", 1000);
        SEQUENCE.put("Person", 1000);
        SEQUENCE.put("RowIndex", 1000);
        SEQUENCE.put("Products", 1000);
        SEQUENCE.put("ProductDetails", 1000);
        SEQUENCE.put("PersonDetails", 1000);
        SEQUENCE.put("PaymentInstrument", 10192);
        SEQUENCE.put("People", 1000);
        MEDIA_CONTENT.put("CustomerInfo", new ImmutablePair((Object)"CustomerInfoId", (Object)EdmPrimitiveTypeKind.Int32));
        MEDIA_CONTENT.put("Car", new ImmutablePair((Object)"VIN", (Object)EdmPrimitiveTypeKind.Int32));
        MEDIA_CONTENT.put("Car/Photo", null);
        MEDIA_CONTENT.put("PersonDetails/Photo", null);
        MEDIA_CONTENT.put("Advertisements", new ImmutablePair((Object)"ID", (Object)EdmPrimitiveTypeKind.Guid));
    }
}

