/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.serialization.ODataDeserializer;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;
import org.apache.olingo.commons.api.serialization.ODataSerializer;
import org.apache.olingo.commons.api.serialization.ODataSerializerException;
import org.apache.olingo.commons.core.serialization.AtomSerializer;
import org.apache.olingo.commons.core.serialization.JsonDeserializer;
import org.apache.olingo.commons.core.serialization.JsonSerializer;
import org.apache.olingo.fit.UnsupportedMediaTypeException;
import org.apache.olingo.fit.metadata.Metadata;
import org.apache.olingo.fit.metadata.NavigationProperty;
import org.apache.olingo.fit.serializer.FITAtomDeserializer;
import org.apache.olingo.fit.utils.Accept;
import org.apache.olingo.fit.utils.Commons;
import org.apache.olingo.fit.utils.ConstantKey;
import org.apache.olingo.fit.utils.Constants;
import org.apache.olingo.fit.utils.FSManager;
import org.apache.olingo.fit.utils.LinkInfo;
import org.apache.olingo.fit.utils.NavigationLinks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUtilities {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractUtilities.class);
    protected static final Pattern ENTITY_URI_PATTERN = Pattern.compile(".*\\/.*\\(.*\\)");
    public static final String MULTIPART_CONTENT_TYPE = "multipart/mixed";
    public static final String ITEM_CONTENT_TYPE = "application/http";
    public static final String BOUNDARY = "boundary";
    protected final ODataServiceVersion version;
    protected final Metadata metadata;
    protected final FSManager fsManager;
    protected final ODataDeserializer atomDeserializer;
    protected final ODataDeserializer jsonDeserializer;
    protected final ODataSerializer atomSerializer;
    protected final ODataSerializer jsonSerializer;

    public AbstractUtilities(ODataServiceVersion version, Metadata metadata) throws IOException {
        this.version = version;
        this.metadata = metadata;
        this.fsManager = FSManager.instance((ODataServiceVersion)version);
        this.atomDeserializer = new FITAtomDeserializer(version);
        this.jsonDeserializer = new JsonDeserializer(version, true);
        this.atomSerializer = new AtomSerializer(version, true);
        this.jsonSerializer = new JsonSerializer(version, true);
    }

    public boolean isMediaContent(String entityName) {
        return Commons.MEDIA_CONTENT.containsKey(entityName);
    }

    protected abstract InputStream addLinks(String var1, String var2, InputStream var3, Set<String> var4) throws Exception;

    protected abstract Set<String> retrieveAllLinkNames(InputStream var1) throws Exception;

    protected abstract NavigationLinks retrieveNavigationInfo(String var1, InputStream var2) throws Exception;

    protected abstract InputStream normalizeLinks(String var1, String var2, InputStream var3, NavigationLinks var4) throws Exception;

    public InputStream saveSingleEntity(String key, String entitySetName, InputStream is, NavigationLinks links) throws Exception {
        String path = entitySetName + File.separatorChar + Commons.getEntityKey((String)key) + File.separatorChar + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY);
        InputStream normalized = this.normalizeLinks(entitySetName, key, is, links);
        FileObject fo = this.fsManager.putInMemory(normalized, this.fsManager.getAbsolutePath(path, this.getDefaultFormat()));
        return fo.getContent().getInputStream();
    }

    private InputStream toInputStream(Entity entry) throws ODataSerializerException {
        StringWriter writer = new StringWriter();
        this.atomSerializer.write((Writer)writer, (Object)entry);
        return IOUtils.toInputStream((String)writer.toString(), (Charset)Constants.ENCODING);
    }

    public InputStream addOrReplaceEntity(String key, String entitySetName, InputStream is, Entity entry) throws Exception {
        Set linksToBeKept;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)bos);
        IOUtils.closeQuietly((InputStream)is);
        Map navigationProperties = this.metadata.getNavigationProperties(entitySetName);
        try {
            linksToBeKept = new HashSet(navigationProperties.keySet());
        }
        catch (NullPointerException e) {
            linksToBeKept = Collections.emptySet();
        }
        for (String availableLink : new HashSet(linksToBeKept)) {
            try {
                this.fsManager.resolve(Commons.getLinksPath((String)entitySetName, (String)key, (String)availableLink, (Accept)Accept.JSON_FULLMETA));
            }
            catch (Exception e) {
                linksToBeKept.remove(availableLink);
            }
        }
        for (String linkName : this.retrieveAllLinkNames((InputStream)new ByteArrayInputStream(bos.toByteArray()))) {
            linksToBeKept.remove(linkName);
        }
        String entityKey = key == null ? this.getDefaultEntryKey(entitySetName, entry) : key;
        String path = Commons.getEntityBasePath((String)entitySetName, (String)entityKey);
        NavigationLinks links = this.retrieveNavigationInfo(entitySetName, (InputStream)new ByteArrayInputStream(bos.toByteArray()));
        InputStream createdEntity = this.saveSingleEntity(entityKey, entitySetName, (InputStream)new ByteArrayInputStream(bos.toByteArray()), links);
        bos.reset();
        IOUtils.copy((InputStream)createdEntity, (OutputStream)bos);
        InputStream normalizedEntity = this.addLinks(entitySetName, entityKey, (InputStream)new ByteArrayInputStream(bos.toByteArray()), linksToBeKept);
        IOUtils.closeQuietly((OutputStream)bos);
        FileObject fo = this.fsManager.putInMemory(normalizedEntity, this.fsManager.getAbsolutePath(path + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY), this.getDefaultFormat()));
        for (Map.Entry link : links.getLinks()) {
            this.putLinksInMemory(path, entitySetName, entityKey, (String)link.getKey(), (Collection)link.getValue());
        }
        ArrayList<String> hrefs = new ArrayList<String>();
        for (Link link : entry.getNavigationLinks()) {
            NavigationProperty navProp = navigationProperties == null ? null : (NavigationProperty)navigationProperties.get(link.getTitle());
            if (navProp == null) continue;
            String inlineEntitySetName = navProp.getTarget();
            if (link.getInlineEntity() != null) {
                String inlineEntryKey = this.getDefaultEntryKey(inlineEntitySetName, link.getInlineEntity());
                this.addOrReplaceEntity(inlineEntryKey, inlineEntitySetName, this.toInputStream(link.getInlineEntity()), link.getInlineEntity());
                hrefs.add(inlineEntitySetName + "(" + inlineEntryKey + ")");
            } else if (link.getInlineEntitySet() != null) {
                for (Entity subentry : link.getInlineEntitySet().getEntities()) {
                    String inlineEntryKey = this.getDefaultEntryKey(inlineEntitySetName, subentry);
                    this.addOrReplaceEntity(inlineEntryKey, inlineEntitySetName, this.toInputStream(subentry), subentry);
                    hrefs.add(inlineEntitySetName + "(" + inlineEntryKey + ")");
                }
            }
            if (hrefs.isEmpty()) continue;
            this.putLinksInMemory(path, entitySetName, entityKey, link.getTitle(), hrefs);
        }
        return fo.getContent().getInputStream();
    }

    public void addMediaEntityValue(String entitySetName, String entityKey, InputStream is) throws Exception {
        String path = Commons.getEntityBasePath((String)entitySetName, (String)entityKey);
        this.fsManager.putInMemory(is, this.fsManager.getAbsolutePath(path + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.MEDIA_CONTENT_FILENAME), null));
        IOUtils.closeQuietly((InputStream)is);
    }

    public void putLinksInMemory(String basePath, String entitySetName, String entityKey, String linkName, Collection<String> links) throws Exception {
        HashSet<String> uris = new HashSet<String>();
        Map navigationProperties = this.metadata.getNavigationProperties(entitySetName);
        if (navigationProperties.get(linkName) != null && ((NavigationProperty)navigationProperties.get(linkName)).isEntitySet()) {
            try {
                Map.Entry currents = this.extractLinkURIs(entitySetName, entityKey, linkName);
                uris.addAll((Collection)currents.getValue());
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        uris.addAll(links);
        this.putLinksInMemory(basePath, entitySetName, linkName, uris);
    }

    public void putLinksInMemory(String basePath, String entitySetName, String linkName, Collection<String> uris) throws Exception {
        this.fsManager.putInMemory(Commons.getLinksAsJSON((ODataServiceVersion)this.version, (String)entitySetName, new AbstractMap.SimpleEntry<String, Collection<String>>(linkName, uris)), Commons.getLinksPath((ODataServiceVersion)this.version, (String)basePath, (String)linkName, (Accept)Accept.JSON_FULLMETA));
        this.fsManager.putInMemory(Commons.getLinksAsATOM((ODataServiceVersion)this.version, new AbstractMap.SimpleEntry<String, Collection<String>>(linkName, uris)), Commons.getLinksPath((ODataServiceVersion)this.version, (String)basePath, (String)linkName, (Accept)Accept.XML));
    }

    public Response createResponse(String location, InputStream entity, String etag, Accept accept) {
        return this.createResponse(location, entity, etag, accept, null);
    }

    public Response createAsyncResponse(String location) {
        Response.ResponseBuilder builder = Response.accepted();
        if (this.version.compareTo((Enum)ODataServiceVersion.V30) <= 0) {
            builder.header(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_SERVICE_VERSION), (Object)(this.version.toString() + ";"));
        }
        builder.header("Location", (Object)location);
        builder.header("Preference-Applied", (Object)"Respond-Async");
        builder.header("Retry-After", (Object)"10");
        return builder.build();
    }

    public Response createMonitorResponse(InputStream res) {
        Response.ResponseBuilder builder = Response.ok();
        if (this.version.compareTo((Enum)ODataServiceVersion.V30) <= 0) {
            builder.header(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_SERVICE_VERSION), (Object)(this.version.toString() + ";"));
        }
        builder.header("Content-Type", (Object)ITEM_CONTENT_TYPE);
        builder.header("Content-Transfer-Encoding", (Object)"binary");
        return builder.entity((Object)res).build();
    }

    public Response createResponse(InputStream entity, String etag, Accept accept) {
        return this.createResponse(null, entity, etag, accept, null);
    }

    public Response createBatchResponse(InputStream stream) {
        Response.ResponseBuilder builder = this.version.compareTo((Enum)ODataServiceVersion.V30) <= 0 ? Response.accepted((Object)stream) : Response.ok((Object)stream);
        builder.header(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_SERVICE_VERSION), (Object)(this.version.toString() + ";"));
        return builder.build();
    }

    public Response createResponse(InputStream entity, String etag, Accept accept, Response.Status status) {
        return this.createResponse(null, entity, etag, accept, status);
    }

    public Response createResponse(String location, InputStream entity, String etag, Accept accept, Response.Status status) {
        Response.ResponseBuilder builder = Response.ok();
        if (this.version.compareTo((Enum)ODataServiceVersion.V30) <= 0) {
            builder.header(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_SERVICE_VERSION), (Object)(this.version.toString() + ";"));
        }
        if (StringUtils.isNotBlank((CharSequence)etag)) {
            builder.header("ETag", (Object)etag);
        }
        if (status != null) {
            builder.status(status);
        }
        int contentLength = 0;
        String contentTypeEncoding = "";
        if (entity != null) {
            try {
                InputStream toBeStreamedBack = Accept.JSON == accept || Accept.JSON_NOMETA == accept ? Commons.changeFormat((InputStream)entity, (ODataServiceVersion)this.version, (Accept)accept) : entity;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)toBeStreamedBack, (OutputStream)bos);
                IOUtils.closeQuietly((InputStream)toBeStreamedBack);
                contentLength = bos.size();
                builder.entity((Object)new ByteArrayInputStream(bos.toByteArray()));
                contentTypeEncoding = ";odata.streaming=true;charset=utf-8";
            }
            catch (IOException ioe) {
                LOG.error("Error streaming response entity back", (Throwable)ioe);
            }
        }
        builder.header("Content-Length", (Object)contentLength);
        builder.header("Content-Type", (Object)((accept == null ? "*/*" : accept.toString(this.version)) + contentTypeEncoding));
        if (StringUtils.isNotBlank((CharSequence)location)) {
            builder.header("Location", (Object)location);
        }
        return builder.build();
    }

    public Response createFaultResponse(String accept, Exception e) {
        InputStream src;
        Accept contentType;
        String ext;
        LOG.debug("Create fault response about .... ", (Throwable)e);
        Response.ResponseBuilder builder = Response.serverError();
        if (this.version.compareTo((Enum)ODataServiceVersion.V30) <= 0) {
            builder.header(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_SERVICE_VERSION), (Object)(this.version + ";"));
        }
        if (accept.startsWith("application/json")) {
            ext = ".json";
            contentType = Accept.JSON;
        } else if (accept.startsWith("application/xml") || this.version.compareTo((Enum)ODataServiceVersion.V30) <= 0) {
            ext = ".xml";
            contentType = Accept.XML;
        } else {
            ext = ".json";
            contentType = Accept.JSON;
        }
        builder.header("Content-Type", (Object)contentType);
        if (e instanceof ConcurrentModificationException) {
            builder.status(Response.Status.PRECONDITION_FAILED);
            src = this.fsManager.readFile("/badRequest" + ext, null);
        } else if (e instanceof UnsupportedMediaTypeException) {
            builder.status(Response.Status.UNSUPPORTED_MEDIA_TYPE);
            src = this.fsManager.readFile("/unsupportedMediaType" + ext, null);
        } else if (e instanceof NotFoundException) {
            builder.status(Response.Status.NOT_FOUND);
            src = this.fsManager.readFile("/notFound" + ext, null);
        } else {
            builder.status(Response.Status.BAD_REQUEST);
            src = this.fsManager.readFile("/badRequest" + ext, null);
        }
        builder.entity((Object)src);
        return builder.build();
    }

    public EntitySet readEntitySet(Accept accept, InputStream entitySet) throws ODataDeserializerException {
        return (EntitySet)(accept == Accept.ATOM || accept == Accept.XML ? this.atomDeserializer.toEntitySet(entitySet) : this.jsonDeserializer.toEntitySet(entitySet)).getPayload();
    }

    public InputStream writeEntitySet(Accept accept, ResWrap<EntitySet> container) throws ODataSerializerException, IOException {
        StringWriter writer = new StringWriter();
        if (accept == Accept.ATOM || accept == Accept.XML) {
            this.atomSerializer.write((Writer)writer, container);
        } else {
            this.jsonSerializer.write((Writer)writer, container);
        }
        writer.flush();
        writer.close();
        return IOUtils.toInputStream((String)writer.toString(), (Charset)Constants.ENCODING);
    }

    public ResWrap<Entity> readContainerEntity(Accept accept, InputStream entity) throws ODataDeserializerException {
        return accept == Accept.ATOM || accept == Accept.XML ? this.atomDeserializer.toEntity(entity) : this.jsonDeserializer.toEntity(entity);
    }

    public Entity readEntity(Accept accept, InputStream entity) throws IOException, ODataDeserializerException {
        return (Entity)this.readContainerEntity(accept, entity).getPayload();
    }

    public InputStream writeEntity(Accept accept, ResWrap<Entity> container) throws ODataSerializerException {
        StringWriter writer = new StringWriter();
        if (accept == Accept.ATOM || accept == Accept.XML) {
            this.atomSerializer.write((Writer)writer, container);
        } else {
            this.jsonSerializer.write((Writer)writer, container);
        }
        return IOUtils.toInputStream((String)writer.toString(), (Charset)Constants.ENCODING);
    }

    public InputStream writeProperty(Accept accept, Property property) throws ODataSerializerException {
        StringWriter writer = new StringWriter();
        if (accept == Accept.XML || accept == Accept.ATOM) {
            this.atomSerializer.write((Writer)writer, (Object)property);
        } else {
            this.jsonSerializer.write((Writer)writer, (Object)property);
        }
        return IOUtils.toInputStream((String)writer.toString(), (Charset)Constants.ENCODING);
    }

    public Property readProperty(Accept accept, InputStream property) throws ODataDeserializerException {
        return (Property)(Accept.ATOM == accept || Accept.XML == accept ? this.atomDeserializer.toProperty(property) : this.jsonDeserializer.toProperty(property)).getPayload();
    }

    public InputStream writeProperty(Accept accept, ResWrap<Property> container) throws ODataSerializerException {
        StringWriter writer = new StringWriter();
        if (accept == Accept.XML || accept == Accept.ATOM) {
            this.atomSerializer.write((Writer)writer, container);
        } else {
            this.jsonSerializer.write((Writer)writer, container);
        }
        return IOUtils.toInputStream((String)writer.toString(), (Charset)Constants.ENCODING);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDefaultEntryKey(String entitySetName, Entity entry, String propertyName) throws IOException {
        String res;
        if (entry.getProperty(propertyName) == null) {
            if (!Commons.SEQUENCE.containsKey(entitySetName)) throw new IOException(String.format("Unable to retrieve entity key value for %s", entitySetName));
            res = String.valueOf((Integer)Commons.SEQUENCE.get(entitySetName) + 1);
        } else {
            res = entry.getProperty(propertyName).asPrimitive().toString();
        }
        Commons.SEQUENCE.put(entitySetName, Integer.valueOf(res));
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDefaultEntryKey(String entitySetName, Entity entity) throws IOException {
        try {
            String res;
            if ("OrderDetails".equals(entitySetName)) {
                int productID;
                if (entity.getProperty("OrderID") == null || entity.getProperty("ProductID") == null) {
                    if (!Commons.SEQUENCE.containsKey(entitySetName)) throw new IOException(String.format("Unable to retrieve entity key value for %s", entitySetName));
                    productID = (Integer)Commons.SEQUENCE.get(entitySetName) + 1;
                    res = "OrderID=1,ProductID=" + String.valueOf(productID);
                } else {
                    productID = (Integer)entity.getProperty("OrderID").asPrimitive();
                    res = "OrderID=" + entity.getProperty("OrderID").asPrimitive() + ",ProductID=" + entity.getProperty("ProductID").asPrimitive();
                }
                Commons.SEQUENCE.put(entitySetName, productID);
                return res;
            } else if ("Message".equals(entitySetName)) {
                int messageId;
                if (entity.getProperty("MessageId") == null || entity.getProperty("FromUsername") == null) {
                    if (!Commons.SEQUENCE.containsKey(entitySetName)) throw new IOException(String.format("Unable to retrieve entity key value for %s", entitySetName));
                    messageId = (Integer)Commons.SEQUENCE.get(entitySetName) + 1;
                    res = "FromUsername=1,MessageId=" + String.valueOf(messageId);
                } else {
                    messageId = (Integer)entity.getProperty("MessageId").asPrimitive();
                    res = "FromUsername=" + entity.getProperty("FromUsername").asPrimitive() + ",MessageId=" + entity.getProperty("MessageId").asPrimitive();
                }
                Commons.SEQUENCE.put(entitySetName, messageId);
                return res;
            } else {
                if ("PersonDetails".equals(entitySetName)) {
                    return this.getDefaultEntryKey(entitySetName, entity, "PersonID");
                }
                if ("Order".equals(entitySetName)) {
                    return this.getDefaultEntryKey(entitySetName, entity, "OrderId");
                }
                if ("Product".equals(entitySetName)) {
                    return this.getDefaultEntryKey(entitySetName, entity, "ProductId");
                }
                if ("Orders".equals(entitySetName)) {
                    return this.getDefaultEntryKey(entitySetName, entity, "OrderID");
                }
                if ("Customer".equals(entitySetName)) {
                    return this.getDefaultEntryKey(entitySetName, entity, "CustomerId");
                }
                if ("Customers".equals(entitySetName)) {
                    return this.getDefaultEntryKey(entitySetName, entity, "PersonID");
                }
                if ("Person".equals(entitySetName)) {
                    return this.getDefaultEntryKey(entitySetName, entity, "PersonId");
                }
                if ("ComputerDetail".equals(entitySetName)) {
                    return this.getDefaultEntryKey(entitySetName, entity, "ComputerDetailId");
                }
                if ("AllGeoTypesSet".equals(entitySetName)) {
                    return this.getDefaultEntryKey(entitySetName, entity, "Id");
                }
                if ("CustomerInfo".equals(entitySetName)) {
                    return this.getDefaultEntryKey(entitySetName, entity, "CustomerInfoId");
                }
                if ("Car".equals(entitySetName)) {
                    return this.getDefaultEntryKey(entitySetName, entity, "VIN");
                }
                if ("RowIndex".equals(entitySetName)) {
                    return this.getDefaultEntryKey(entitySetName, entity, "Id");
                }
                if ("Login".equals(entitySetName)) {
                    return (String)entity.getProperty("Username").asPrimitive();
                }
                if ("Products".equals(entitySetName)) {
                    return this.getDefaultEntryKey(entitySetName, entity, "ProductID");
                }
                if ("ProductDetails".equals(entitySetName)) {
                    int productDetailId;
                    int productId;
                    if (entity.getProperty("ProductID") == null || entity.getProperty("ProductDetailID") == null) {
                        if (!Commons.SEQUENCE.containsKey(entitySetName) || !Commons.SEQUENCE.containsKey("Products")) {
                            throw new IOException(String.format("Unable to retrieve entity key value for %s", entitySetName));
                        }
                        productId = (Integer)Commons.SEQUENCE.get("Products") + 1;
                        productDetailId = (Integer)Commons.SEQUENCE.get(entitySetName) + 1;
                        res = "ProductID=" + String.valueOf(productId) + ",ProductDetailID=" + String.valueOf(productDetailId);
                        Commons.SEQUENCE.put(entitySetName, productDetailId);
                    } else {
                        productId = (Integer)entity.getProperty("ProductID").asPrimitive();
                        productDetailId = (Integer)entity.getProperty("ProductDetailID").asPrimitive();
                        res = "ProductID=" + entity.getProperty("ProductID").asPrimitive() + ",ProductDetailID=" + entity.getProperty("ProductDetailID").asPrimitive();
                    }
                    Commons.SEQUENCE.put(entitySetName, productDetailId);
                    Commons.SEQUENCE.put("Products", productId);
                    return res;
                } else {
                    if ("PaymentInstrument".equals(entitySetName)) {
                        return this.getDefaultEntryKey(entitySetName, entity, "PaymentInstrumentID");
                    }
                    if ("Advertisements".equals(entitySetName)) {
                        return UUID.randomUUID().toString();
                    }
                    if (!"People".equals(entitySetName)) throw new IOException(String.format("EntitySet '%s' not found", entitySetName));
                    return this.getDefaultEntryKey(entitySetName, entity, "PersonID");
                }
            }
        }
        catch (Exception e) {
            throw new NotFoundException((Throwable)e);
        }
    }

    public String getLinksBasePath(String entitySetName, String entityId) {
        return entitySetName + File.separatorChar + Commons.getEntityKey((String)entityId) + File.separatorChar + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.LINKS_FILE_PATH) + File.separatorChar;
    }

    public LinkInfo readLinks(String entitySetName, String entityId, String linkName, Accept accept) throws Exception {
        String basePath = this.getLinksBasePath(entitySetName, entityId);
        LinkInfo linkInfo = new LinkInfo(this.fsManager.readFile(basePath + linkName, accept));
        linkInfo.setEtag(Commons.getETag((String)basePath, (ODataServiceVersion)this.version));
        Map navigationProperties = this.metadata.getNavigationProperties(entitySetName);
        linkInfo.setFeed(((NavigationProperty)navigationProperties.get(linkName.replaceAll("\\(.*\\)", ""))).isEntitySet());
        return linkInfo;
    }

    public InputStream putMediaInMemory(String entitySetName, String entityId, InputStream value) throws IOException {
        return this.putMediaInMemory(entitySetName, entityId, null, value);
    }

    public InputStream putMediaInMemory(String entitySetName, String entityId, String name, InputStream value) throws IOException {
        FileObject fo = this.fsManager.putInMemory(value, this.fsManager.getAbsolutePath(Commons.getEntityBasePath((String)entitySetName, (String)entityId) + (name == null ? Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.MEDIA_CONTENT_FILENAME) : name), null));
        return fo.getContent().getInputStream();
    }

    public Map.Entry<String, InputStream> readMediaEntity(String entitySetName, String entityId) {
        return this.readMediaEntity(entitySetName, entityId, null);
    }

    public Map.Entry<String, InputStream> readMediaEntity(String entitySetName, String entityId, String name) {
        String basePath = Commons.getEntityBasePath((String)entitySetName, (String)entityId);
        return new AbstractMap.SimpleEntry<String, InputStream>(basePath, this.fsManager.readFile(basePath + (name == null ? Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.MEDIA_CONTENT_FILENAME) : name)));
    }

    public Map.Entry<String, InputStream> readEntity(String entitySetName, String entityId, Accept accept) {
        if (accept == Accept.XML || accept == Accept.TEXT) {
            throw new UnsupportedMediaTypeException("Unsupported media type");
        }
        String basePath = Commons.getEntityBasePath((String)entitySetName, (String)entityId);
        return new AbstractMap.SimpleEntry<String, InputStream>(basePath, this.fsManager.readFile(basePath + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY), accept));
    }

    public InputStream expandEntity(String entitySetName, String entityId, String linkName) throws Exception {
        Map.Entry links = this.extractLinkURIs(entitySetName, entityId, linkName);
        Map navigationProperties = this.metadata.getNavigationProperties(entitySetName);
        return this.readEntities((List)links.getValue(), linkName, (String)links.getKey(), ((NavigationProperty)navigationProperties.get(linkName)).isEntitySet());
    }

    public InputStream expandEntity(String entitySetName, String entityId, InputStream entity, String linkName) throws Exception {
        return this.replaceLink(entity, linkName, this.expandEntity(entitySetName, entityId, linkName));
    }

    public InputStream deleteProperty(String entitySetName, String entityId, List<String> path, Accept accept) throws Exception {
        String basePath = Commons.getEntityBasePath((String)entitySetName, (String)entityId);
        Accept acceptType = accept == null || Accept.TEXT == accept ? Accept.XML : (accept.getExtension().equals(Accept.JSON.getExtension()) ? Accept.JSON_FULLMETA : accept);
        InputStream stream = this.fsManager.readFile(basePath + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY), acceptType);
        stream = this.deleteProperty(stream, path);
        this.fsManager.putInMemory(stream, this.fsManager.getAbsolutePath(basePath + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY), acceptType));
        return this.fsManager.readFile(basePath + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY), acceptType);
    }

    public abstract InputStream readEntities(List<String> var1, String var2, String var3, boolean var4) throws Exception;

    protected abstract InputStream replaceLink(InputStream var1, String var2, InputStream var3) throws Exception;

    public abstract InputStream selectEntity(InputStream var1, String[] var2) throws Exception;

    protected abstract Accept getDefaultFormat();

    protected abstract Map<String, InputStream> getChanges(InputStream var1) throws Exception;

    public abstract InputStream addEditLink(InputStream var1, String var2, String var3) throws Exception;

    public abstract InputStream addOperation(InputStream var1, String var2, String var3, String var4) throws Exception;

    protected abstract InputStream replaceProperty(InputStream var1, InputStream var2, List<String> var3, boolean var4) throws Exception;

    protected abstract InputStream deleteProperty(InputStream var1, List<String> var2) throws Exception;

    public abstract Map.Entry<String, List<String>> extractLinkURIs(InputStream var1) throws Exception;

    public abstract Map.Entry<String, List<String>> extractLinkURIs(String var1, String var2, String var3) throws Exception;
}

