/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.server;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Random;
import org.apache.olingo.fit.server.StringHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class StringHelper {
    public static Stream toStream(InputStream stream) throws IOException {
        byte[] result = new byte[]{};
        byte[] tmp = new byte[8192];
        int readCount = stream.read(tmp);
        while (readCount >= 0) {
            byte[] innerTmp = new byte[result.length + readCount];
            System.arraycopy(result, 0, innerTmp, 0, result.length);
            System.arraycopy(tmp, 0, innerTmp, result.length, readCount);
            result = innerTmp;
            readCount = stream.read(tmp);
        }
        stream.close();
        return new Stream(result, null);
    }

    public static Stream toStream(String content) {
        try {
            return new Stream(content, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 should be supported on each system.");
        }
    }

    public static String inputStreamToString(InputStream in, boolean preserveLineBreaks) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
        StringBuilder stringBuilder = new StringBuilder();
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            stringBuilder.append(line);
            if (!preserveLineBreaks) continue;
            stringBuilder.append("\n");
        }
        bufferedReader.close();
        String result = stringBuilder.toString();
        return result;
    }

    public static int countLines(String content) {
        return StringHelper.countLines((String)content, (String)"\r\n");
    }

    public static int countLines(String content, String lineBreak) {
        if (content == null) {
            return -1;
        }
        int lastPos = content.indexOf(lineBreak);
        int count = 1;
        while (lastPos >= 0) {
            lastPos = content.indexOf(lineBreak, lastPos + 1);
            ++count;
        }
        return count;
    }

    public static String inputStreamToString(InputStream in) throws IOException {
        return StringHelper.inputStreamToString((InputStream)in, (boolean)false);
    }

    public static InputStream encapsulate(String content) {
        try {
            return StringHelper.encapsulate((String)content, (String)"UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TestUtilRuntimeException("UTF-8 MUST be supported.", (Throwable)e);
        }
    }

    public static InputStream encapsulate(String content, String charset) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(content.getBytes(charset));
    }

    public static InputStream generateDataStream(int len) {
        return StringHelper.encapsulate((String)StringHelper.generateData((int)len));
    }

    public static String generateData(int len) {
        Random random = new Random();
        StringBuilder b = new StringBuilder(len);
        for (int j = 0; j < len; ++j) {
            char c = (char)(65 + random.nextInt(26));
            b.append(c);
        }
        return b.toString();
    }
}

