/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.rproxy;

import java.io.IOException;
import java.io.Writer;
import org.apache.http.HttpEntityEnclosingRequest;
import org.esigate.Renderer;

public class LinkRewriteRenderer
implements Renderer {
    private static final char SLASH = '/';
    private String baseUrl;
    private String replacementUrl;

    public LinkRewriteRenderer(String baseUrl, String visibleBaseUrl) {
        if (visibleBaseUrl == null || visibleBaseUrl.isEmpty()) {
            throw new IllegalArgumentException("Need to specify baseUrl and visibleBaseUrl");
        }
        this.baseUrl = this.removeLeadingSlash(baseUrl);
        this.replacementUrl = this.removeLeadingSlash(visibleBaseUrl);
    }

    private String removeLeadingSlash(String src) {
        int lastCharPosition = src.length() - 1;
        return src.charAt(lastCharPosition) == '/' ? src.substring(0, lastCharPosition) : src;
    }

    public void render(HttpEntityEnclosingRequest httpRequest, String src, Writer out) throws IOException {
        out.write(src.replaceAll(this.baseUrl, this.replacementUrl));
    }
}

