/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.fit.utils.Constants;

@Provider
public class ServiceNameResponseFilter
implements ContainerResponseFilter {
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String svcName = StringUtils.substringBefore((String)StringUtils.substringAfter((String)requestContext.getUriInfo().getPath(), (String)"/"), (String)"/");
        if ("OAuth2.svc".equals(svcName) && responseContext.getEntity() != null) {
            String content = IOUtils.toString((InputStream)((InputStream)responseContext.getEntity()), (Charset)Constants.ENCODING).replaceAll("Static\\.svc", svcName);
            InputStream toBeStreamedBack = IOUtils.toInputStream((String)content, (Charset)Constants.ENCODING);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)toBeStreamedBack, (OutputStream)baos);
            IOUtils.closeQuietly((InputStream)toBeStreamedBack);
            responseContext.setEntity((Object)new ByteArrayInputStream(baos.toByteArray()));
        }
    }
}

