/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.cxf.interceptor.InInterceptors;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.data.EntityImpl;
import org.apache.olingo.commons.core.data.EntitySetImpl;
import org.apache.olingo.commons.core.data.LinkImpl;
import org.apache.olingo.commons.core.data.PropertyImpl;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.fit.AbstractServices;
import org.apache.olingo.fit.UnsupportedMediaTypeException;
import org.apache.olingo.fit.metadata.Metadata;
import org.apache.olingo.fit.metadata.NavigationProperty;
import org.apache.olingo.fit.methods.PATCH;
import org.apache.olingo.fit.rest.ResolvingReferencesInterceptor;
import org.apache.olingo.fit.rest.XHTTPMethodInterceptor;
import org.apache.olingo.fit.utils.AbstractUtilities;
import org.apache.olingo.fit.utils.Accept;
import org.apache.olingo.fit.utils.Commons;
import org.apache.olingo.fit.utils.ConstantKey;
import org.apache.olingo.fit.utils.Constants;
import org.apache.olingo.fit.utils.FSManager;
import org.apache.olingo.fit.utils.LinkInfo;
import org.springframework.stereotype.Service;

@Service
@Path(value="/V40/Static.svc")
@InInterceptors(classes={XHTTPMethodInterceptor.class, ResolvingReferencesInterceptor.class})
public class V4Services
extends AbstractServices {
    protected static final byte[] CRLF = new byte[]{13, 10};
    protected static final Pattern RELENTITY_SELECT_PATTERN = Pattern.compile("^.*\\(\\$select=.*\\)$");
    protected static final Pattern CROSSJOIN_PATTERN = Pattern.compile("^\\$crossjoin\\(.*\\)\\?\\$filter=\\([a-zA-Z/]+ eq [a-zA-Z/]+\\)$");
    private final Map<String, String> providedAsync = new HashMap();

    public V4Services() throws IOException {
        super(ODataServiceVersion.V40, Commons.getMetadata((ODataServiceVersion)ODataServiceVersion.V40));
    }

    protected V4Services(Metadata metadata) throws IOException {
        super(ODataServiceVersion.V40, metadata);
    }

    @GET
    @Path(value="/redirect/{name}({id})")
    public Response conformanceRedirect(@Context UriInfo uriInfo, @PathParam(value="name") String name, @PathParam(value="id") String id) {
        return Response.temporaryRedirect((URI)URI.create(uriInfo.getRequestUri().toASCIIString().replace("/redirect", ""))).build();
    }

    @GET
    @Path(value="/$crossjoin({elements:.*})")
    public Response crossjoin(@PathParam(value="elements") String elements, @QueryParam(value="$filter") String filter) {
        try {
            if (CROSSJOIN_PATTERN.matcher("$crossjoin(" + elements + ")?$filter=" + filter).matches()) {
                InputStream feed = FSManager.instance((ODataServiceVersion)this.version).readFile("crossjoin", Accept.JSON);
                return this.xml.createResponse(feed, null, Accept.JSON_FULLMETA);
            }
            throw new IOException("Unexpected crossjoin pattern");
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(Accept.JSON.toString(this.version), e);
        }
    }

    @GET
    @Path(value="/relatedEntitySelect/{path:.*}")
    public Response relatedEntitySelect(@PathParam(value="path") String path, @QueryParam(value="$expand") String expand) {
        if (RELENTITY_SELECT_PATTERN.matcher(expand).matches()) {
            return this.xml.createResponse(null, null, Accept.JSON_FULLMETA);
        }
        return this.xml.createFaultResponse(Accept.JSON.toString(this.version), new Exception("Unexpected expand pattern"));
    }

    @DELETE
    @Path(value="/monitor/{name}")
    public Response removeMonitor(@Context UriInfo uriInfo, @PathParam(value="name") String name) {
        this.providedAsync.remove(name);
        return this.xml.createResponse(null, null, null, Response.Status.NO_CONTENT);
    }

    @GET
    @Path(value="/monitor/{name}")
    public Response async(@Context UriInfo uriInfo, @PathParam(value="name") String name) {
        try {
            if (!this.providedAsync.containsKey(name)) {
                throw new NotFoundException();
            }
            InputStream res = IOUtils.toInputStream((String)((String)this.providedAsync.get(name)), (Charset)Constants.ENCODING);
            this.providedAsync.remove(name);
            return this.xml.createMonitorResponse(res);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(Accept.JSON_FULLMETA.toString(), e);
        }
    }

    @POST
    @Path(value="/async/$batch")
    public Response async(@Context UriInfo uriInfo, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, @Multipart MultipartBody attachment) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write("HTTP/1.1 200 Ok".getBytes());
            bos.write(CRLF);
            bos.write("OData-Version: 4.0".getBytes());
            bos.write(CRLF);
            bos.write(("Content-Type: " + ContentType.APPLICATION_OCTET_STREAM + ";boundary=" + "batch_243234_25424_ef_892u748").getBytes());
            bos.write(CRLF);
            bos.write(CRLF);
            bos.write("--batch_243234_25424_ef_892u748".getBytes());
            bos.write(CRLF);
            bos.write("Content-Type: application/http".getBytes());
            bos.write(CRLF);
            bos.write("Content-Transfer-Encoding: binary".getBytes());
            bos.write(CRLF);
            bos.write(CRLF);
            bos.write("HTTP/1.1 202 Accepted".getBytes());
            bos.write(CRLF);
            bos.write("Location: http://service-root/async-monitor".getBytes());
            bos.write(CRLF);
            bos.write("Retry-After: 10".getBytes());
            bos.write(CRLF);
            bos.write(CRLF);
            bos.write("--batch_243234_25424_ef_892u748--".getBytes());
            bos.write(CRLF);
            UUID uuid = UUID.randomUUID();
            this.providedAsync.put(uuid.toString(), bos.toString(Constants.ENCODING.toString()));
            bos.flush();
            bos.close();
            return this.xml.createAsyncResponse(uriInfo.getRequestUri().toASCIIString().replace("async/$batch", "") + "monitor/" + uuid.toString());
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(Accept.JSON.toString(), e);
        }
    }

    @GET
    @Path(value="/async/{name}")
    public Response async(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="name") String name) {
        try {
            Accept acceptType = Accept.parse((String)accept, (ODataServiceVersion)this.version);
            if (acceptType == Accept.XML || acceptType == Accept.TEXT) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            String basePath = name + File.separatorChar;
            StringBuilder path = new StringBuilder(basePath);
            path.append(this.metadata.getEntitySet(name).isSingleton() ? Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY) : Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.FEED));
            InputStream feed = FSManager.instance((ODataServiceVersion)this.version).readFile(path.toString(), acceptType);
            StringBuilder builder = new StringBuilder();
            builder.append("HTTP/1.1 200 Ok").append(new String(CRLF));
            builder.append("Content-Type: ").append(accept).append(new String(CRLF)).append(new String(CRLF));
            builder.append(IOUtils.toString((InputStream)feed));
            IOUtils.closeQuietly((InputStream)feed);
            UUID uuid = UUID.randomUUID();
            this.providedAsync.put(uuid.toString(), builder.toString());
            return this.xml.createAsyncResponse(uriInfo.getRequestUri().toASCIIString().replaceAll("async/" + name, "") + "monitor/" + uuid.toString());
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    protected void setInlineCount(EntitySet entitySet, String count) {
        if ("true".equals(count)) {
            entitySet.setCount(Integer.valueOf(entitySet.getEntities().size()));
        }
    }

    public InputStream exploreMultipart(List<Attachment> attachments, String boundary, boolean continueOnError) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Response res = null;
        boolean goon = true;
        for (int i = 0; i < attachments.size() && goon; ++i) {
            try {
                Attachment obj = attachments.get(i);
                bos.write(("--" + boundary).getBytes());
                bos.write(Constants.CRLF);
                Object content = obj.getDataHandler().getContent();
                if (content instanceof MimeMultipart) {
                    ByteArrayOutputStream chbos = new ByteArrayOutputStream();
                    String lastContebtID = null;
                    try {
                        HashMap<String, String> references = new HashMap<String, String>();
                        String cboundary = "changeset_" + UUID.randomUUID().toString();
                        chbos.write(("Content-Type: multipart/mixed;boundary=" + cboundary).getBytes());
                        chbos.write(Constants.CRLF);
                        chbos.write(Constants.CRLF);
                        for (int j = 0; j < ((MimeMultipart)content).getCount(); ++j) {
                            MimeBodyPart part = (MimeBodyPart)((MimeMultipart)content).getBodyPart(j);
                            lastContebtID = part.getContentID();
                            this.addChangesetItemIntro(chbos, lastContebtID, cboundary);
                            res = this.bodyPartRequest(new MimeBodyPart(part.getInputStream()), references);
                            if (!(continueOnError || res != null && res.getStatus() < 400)) {
                                throw new Exception("Failure processing changeset");
                            }
                            this.addSingleBatchResponse(res, lastContebtID, chbos);
                            references.put("$" + lastContebtID, res.getHeaderString("Location"));
                        }
                        chbos.write(("--" + cboundary + "--").getBytes());
                        chbos.write(Constants.CRLF);
                        bos.write(chbos.toByteArray());
                        IOUtils.closeQuietly((OutputStream)chbos);
                    }
                    catch (Exception e) {
                        LOG.warn("While processing changeset", (Throwable)e);
                        IOUtils.closeQuietly((OutputStream)chbos);
                        this.addItemIntro(bos, lastContebtID);
                        if (res == null || res.getStatus() < 400) {
                            this.addErrorBatchResponse(e, "1", bos);
                        } else {
                            this.addSingleBatchResponse(res, lastContebtID, bos);
                        }
                        goon = continueOnError;
                    }
                    continue;
                }
                this.addItemIntro(bos);
                res = this.bodyPartRequest(new MimeBodyPart(obj.getDataHandler().getInputStream()));
                if (res.getStatus() >= 400) {
                    goon = continueOnError;
                    throw new Exception("Failure processing batch item");
                }
                this.addSingleBatchResponse(res, bos);
                continue;
            }
            catch (Exception e) {
                if (res == null || res.getStatus() < 400) {
                    this.addErrorBatchResponse(e, bos);
                    continue;
                }
                this.addSingleBatchResponse(res, bos);
            }
        }
        bos.write(("--" + boundary + "--").getBytes());
        return new ByteArrayInputStream(bos.toByteArray());
    }

    @GET
    @Path(value="/People/{type:.*}")
    public Response getPeople(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="type") String type, @QueryParam(value="$top") @DefaultValue(value="") String top, @QueryParam(value="$skip") @DefaultValue(value="") String skip, @QueryParam(value="$format") @DefaultValue(value="") String format, @QueryParam(value="$inlinecount") @DefaultValue(value="") String count, @QueryParam(value="$filter") @DefaultValue(value="") String filter, @QueryParam(value="$search") @DefaultValue(value="") String search, @QueryParam(value="$orderby") @DefaultValue(value="") String orderby, @QueryParam(value="$skiptoken") @DefaultValue(value="") String skiptoken) {
        return StringUtils.isBlank((CharSequence)filter) && StringUtils.isBlank((CharSequence)search) ? (NumberUtils.isNumber((String)type) ? super.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, "People", type, format, null, null) : super.getEntitySet(accept, "People", type)) : super.getEntitySet(uriInfo, accept, "People", top, skip, format, count, filter, orderby, skiptoken);
    }

    @GET
    @Path(value="/Boss")
    public Response getSingletonBoss(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        return this.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, "Boss", "", format, null, null);
    }

    @GET
    @Path(value="/Company")
    public Response getSingletonCompany(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        return this.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, "Company", "", format, null, null);
    }

    @PATCH
    @Path(value="/Company")
    @Produces(value={"application/xml", "application/atom+xml", "application/json"})
    @Consumes(value={"application/atom+xml", "application/json"})
    public Response patchSingletonCompany(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, @HeaderParam(value="If-Match") @DefaultValue(value="") String ifMatch, String changes) {
        return super.patchEntity(uriInfo, accept, contentType, prefer, ifMatch, "Company", "", changes);
    }

    @GET
    @Path(value="/Customers")
    public Response getCustomers(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, @QueryParam(value="$deltatoken") @DefaultValue(value="") String deltatoken) {
        try {
            InputStream output;
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            if (StringUtils.isBlank((CharSequence)deltatoken)) {
                InputStream input = (InputStream)this.getEntitySet(uriInfo, accept, "Customers", null, null, format, null, null, null, null).getEntity();
                EntitySet entitySet = this.xml.readEntitySet(acceptType, input);
                boolean trackChanges = prefer.contains("odata.track-changes");
                if (trackChanges) {
                    entitySet.setDeltaLink(URI.create("Customers?$deltatoken=8015"));
                }
                output = this.xml.writeEntitySet(acceptType, new ResWrap(URI.create(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_METADATA_PREFIX) + "Customers"), null, (Object)entitySet));
            } else {
                output = FSManager.instance((ODataServiceVersion)this.version).readFile("delta", acceptType);
            }
            Response response = this.xml.createResponse(null, output, null, acceptType);
            if (StringUtils.isNotBlank((CharSequence)prefer)) {
                response.getHeaders().put((Object)"Preference-Applied", Collections.singletonList(prefer));
            }
            return response;
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @GET
    @Path(value="/Company/Microsoft.Test.OData.Services.ODataWCFService.GetEmployeesCount{paren:[\\(\\)]*}")
    public Response functionGetEmployeesCount(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            PropertyImpl property = new PropertyImpl();
            property.setType("Edm.Int32");
            property.setValue(ValueType.PRIMITIVE, (Object)2);
            ResWrap container = new ResWrap(URI.create(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_METADATA_PREFIX) + property.getType()), null, (Object)property);
            return this.xml.createResponse(null, this.xml.writeProperty(acceptType, container), null, acceptType);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @POST
    @Path(value="/Company/Microsoft.Test.OData.Services.ODataWCFService.IncreaseRevenue{paren:[\\(\\)]*}")
    public Response actionIncreaseRevenue(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @QueryParam(value="$format") @DefaultValue(value="") String format, String param) {
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            Accept contentTypeValue = Accept.parse((String)contentType, (ODataServiceVersion)this.version);
            Entity entry = this.xml.readEntity(contentTypeValue, IOUtils.toInputStream((String)param, (Charset)Constants.ENCODING));
            return this.xml.createResponse(null, this.xml.writeProperty(acceptType, entry.getProperty("IncreaseValue")), null, acceptType);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @GET
    @Path(value="/Products({entityId})/Microsoft.Test.OData.Services.ODataWCFService.GetProductDetails({param:.*})")
    public Response functionGetProductDetails(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entityId") String entityId, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            EntityImpl entry = new EntityImpl();
            entry.setType("Microsoft.Test.OData.Services.ODataWCFService.ProductDetail");
            PropertyImpl productId = new PropertyImpl();
            productId.setName("ProductID");
            productId.setType("Edm.Int32");
            productId.setValue(ValueType.PRIMITIVE, (Object)Integer.valueOf(entityId));
            entry.getProperties().add(productId);
            PropertyImpl productDetailId = new PropertyImpl();
            productDetailId.setName("ProductDetailID");
            productDetailId.setType("Edm.Int32");
            productDetailId.setValue(ValueType.PRIMITIVE, (Object)2);
            entry.getProperties().add(productDetailId);
            LinkImpl link = new LinkImpl();
            link.setRel("edit");
            link.setHref(URI.create(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.DEFAULT_SERVICE_URL) + "ProductDetails(ProductID=6,ProductDetailID=1)").toASCIIString());
            entry.setEditLink((Link)link);
            EntitySetImpl feed = new EntitySetImpl();
            feed.getEntities().add(entry);
            ResWrap container = new ResWrap(URI.create(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_METADATA_PREFIX) + "ProductDetail"), null, (Object)feed);
            return this.xml.createResponse(null, this.xml.writeEntitySet(acceptType, container), null, acceptType);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @POST
    @Path(value="/Products({entityId})/Microsoft.Test.OData.Services.ODataWCFService.AddAccessRight{paren:[\\(\\)]*}")
    public Response actionAddAccessRight(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @QueryParam(value="$format") @DefaultValue(value="") String format, String param) {
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            Accept contentTypeValue = Accept.parse((String)contentType, (ODataServiceVersion)this.version);
            Entity entry = this.xml.readEntity(contentTypeValue, IOUtils.toInputStream((String)param, (Charset)Constants.ENCODING));
            assert (1 == entry.getProperties().size());
            assert (entry.getProperty("accessRight") != null);
            Property property = entry.getProperty("accessRight");
            property.setType("Microsoft.Test.OData.Services.ODataWCFService.AccessLevel");
            ResWrap result = new ResWrap(URI.create(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_METADATA_PREFIX) + property.getType()), null, (Object)property);
            return this.xml.createResponse(null, this.xml.writeProperty(acceptType, result), null, acceptType);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @POST
    @Path(value="/Customers({personId})/Microsoft.Test.OData.Services.ODataWCFService.ResetAddress{paren:[\\(\\)]*}")
    public Response actionResetAddress(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="personId") String personId, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @QueryParam(value="$format") @DefaultValue(value="") String format, String param) {
        try {
            Accept contentTypeValue = Accept.parse((String)contentType, (ODataServiceVersion)this.version);
            Entity entry = this.xml.readEntity(contentTypeValue, IOUtils.toInputStream((String)param, (Charset)Constants.ENCODING));
            assert (2 == entry.getProperties().size());
            assert (entry.getProperty("addresses") != null);
            assert (entry.getProperty("index") != null);
            return this.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, "Customers", personId, format, null, null);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @GET
    @Path(value="/ProductDetails(ProductID={productId},ProductDetailID={productDetailId})/Microsoft.Test.OData.Services.ODataWCFService.GetRelatedProduct{paren:[\\(\\)]*}")
    public Response functionGetRelatedProduct(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="productId") String productId, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        return this.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, "Products", productId, format, null, null);
    }

    @POST
    @Path(value="/Accounts({entityId})/Microsoft.Test.OData.Services.ODataWCFService.RefreshDefaultPI{paren:[\\(\\)]*}")
    public Response actionRefreshDefaultPI(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @PathParam(value="entityId") String entityId, @QueryParam(value="$format") @DefaultValue(value="") String format, String param) {
        try {
            Accept contentTypeValue = Accept.parse((String)contentType, (ODataServiceVersion)this.version);
            Entity entry = this.xml.readEntity(contentTypeValue, IOUtils.toInputStream((String)param, (Charset)Constants.ENCODING));
            assert (1 == entry.getProperties().size());
            assert (entry.getProperty("newDate") != null);
            return this.functionGetDefaultPI(accept, entityId, format);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @GET
    @Path(value="/Accounts({entityId})/Microsoft.Test.OData.Services.ODataWCFService.GetDefaultPI{paren:[\\(\\)]*}")
    public Response functionGetDefaultPI(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entityId") String entityId, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        return this.getContainedEntity(accept, entityId, "MyPaymentInstruments", entityId + "901", format);
    }

    @GET
    @Path(value="/Accounts({entityId})/Microsoft.Test.OData.Services.ODataWCFService.GetAccountInfo{paren:[\\(\\)]*}")
    public Response functionGetAccountInfo(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entityId") String entityId, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        return this.getPath(accept, "Accounts", entityId, "AccountInfo", format);
    }

    @GET
    @Path(value="/Accounts({entityId})/MyGiftCard/Microsoft.Test.OData.Services.ODataWCFService.GetActualAmount({param:.*})")
    public Response functionGetActualAmount(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entityId") String entityId, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            PropertyImpl property = new PropertyImpl();
            property.setType("Edm.Double");
            property.setValue(ValueType.PRIMITIVE, (Object)41.79);
            ResWrap container = new ResWrap((URI)null, null, (Object)property);
            return this.xml.createResponse(null, this.xml.writeProperty(acceptType, container), null, acceptType);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @GET
    @Path(value="/{path:.*}/$ref")
    public Response getEntityReference(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="path") String path, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        try {
            Map.Entry utils = this.getUtilities(accept, format);
            if (utils.getKey() == Accept.TEXT) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            String filename = Base64.encodeBase64String((byte[])path.getBytes("UTF-8"));
            return ((AbstractUtilities)utils.getValue()).createResponse(FSManager.instance((ODataServiceVersion)this.version).readFile(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.REF) + File.separatorChar + filename, (Accept)utils.getKey()), null, (Accept)utils.getKey());
        }
        catch (Exception e) {
            LOG.error("Error retrieving entity", (Throwable)e);
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @POST
    @Path(value="/People")
    @Produces(value={"application/xml", "application/atom+xml", "application/json"})
    @Consumes(value={"application/atom+xml", "application/json", "application/octet-stream"})
    public Response postPeople(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, String entity) {
        if ("{\"@odata.type\":\"#Microsoft.Test.OData.Services.ODataWCFService.Person\"}".equals(entity)) {
            return this.xml.createFaultResponse(accept, (Exception)new BadRequestException());
        }
        return super.postNewEntity(uriInfo, accept, contentType, prefer, "People", entity);
    }

    public Response patchEntity(UriInfo uriInfo, String accept, String contentType, String prefer, String ifMatch, String entitySetName, String entityId, String changes) {
        Response response = this.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, entitySetName, entityId, accept, "", "");
        return response.getStatus() >= 400 ? super.postNewEntity(uriInfo, accept, contentType, prefer, entitySetName, changes) : super.patchEntity(uriInfo, accept, contentType, prefer, ifMatch, entitySetName, entityId, changes);
    }

    public Response replaceEntity(UriInfo uriInfo, String accept, String contentType, String prefer, String entitySetName, String entityId, String entity) {
        try {
            this.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, entitySetName, entityId, accept, "", "");
            return super.replaceEntity(uriInfo, accept, contentType, prefer, entitySetName, entityId, entity);
        }
        catch (NotFoundException e) {
            return this.postNewEntity(uriInfo, accept, contentType, prefer, entitySetName, entityId);
        }
    }

    private StringBuilder containedPath(String entityId, String containedEntitySetName) {
        return new StringBuilder("Accounts").append(File.separatorChar).append(entityId).append(File.separatorChar).append("links").append(File.separatorChar).append(containedEntitySetName);
    }

    @GET
    @Path(value="/Accounts({entityId})/{containedEntitySetName}({containedEntityId})")
    public Response getContainedEntity(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entityId") String entityId, @PathParam(value="containedEntitySetName") String containedEntitySetName, @PathParam(value="containedEntityId") String containedEntityId, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            if (acceptType == Accept.XML || acceptType == Accept.TEXT) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            StringBuilder containedPath = this.containedPath(entityId, containedEntitySetName);
            if (StringUtils.isNotBlank((CharSequence)containedEntityId)) {
                containedPath.append('(').append(containedEntityId).append(')');
            }
            InputStream entry = FSManager.instance((ODataServiceVersion)this.version).readFile(containedPath.toString(), Accept.ATOM);
            ResWrap container = this.atomDeserializer.toEntity(entry);
            return this.xml.createResponse(null, this.xml.writeEntity(acceptType, container), null, acceptType);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @POST
    @Path(value="/Accounts({entityId})/{containedEntitySetName:.*}")
    public Response postContainedEntity(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @PathParam(value="entityId") String entityId, @PathParam(value="containedEntitySetName") String containedEntitySetName, String entity) {
        try {
            Entity entry;
            ResWrap entryContainer;
            Accept acceptType = Accept.parse((String)accept, (ODataServiceVersion)this.version);
            if (acceptType == Accept.XML || acceptType == Accept.TEXT) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            AbstractUtilities utils = this.getUtilities(acceptType);
            Accept contentTypeValue = Accept.parse((String)contentType, (ODataServiceVersion)this.version);
            if (Accept.ATOM == contentTypeValue) {
                entryContainer = this.atomDeserializer.toEntity(IOUtils.toInputStream((String)entity, (Charset)Constants.ENCODING));
                entry = (Entity)entryContainer.getPayload();
            } else {
                ResWrap jcontainer = this.jsonDeserializer.toEntity(IOUtils.toInputStream((String)entity, (Charset)Constants.ENCODING));
                entry = (Entity)jcontainer.getPayload();
                entryContainer = new ResWrap(jcontainer.getContextURL(), jcontainer.getMetadataETag(), (Object)entry);
            }
            EdmTypeInfo contained = new EdmTypeInfo.Builder().setTypeExpression(((NavigationProperty)this.metadata.getNavigationProperties("Accounts").get(containedEntitySetName)).getType()).build();
            String entityKey = this.getUtilities(contentTypeValue).getDefaultEntryKey(contained.getFullQualifiedName().getName(), entry);
            String atomEntryRelativePath = this.containedPath(entityId, containedEntitySetName).append('(').append(entityKey).append(')').toString();
            FSManager.instance((ODataServiceVersion)this.version).putInMemory(utils.writeEntity(Accept.ATOM, entryContainer), FSManager.instance((ODataServiceVersion)this.version).getAbsolutePath(atomEntryRelativePath, Accept.ATOM));
            String atomFeedRelativePath = this.containedPath(entityId, containedEntitySetName).toString();
            InputStream feedIS = FSManager.instance((ODataServiceVersion)this.version).readFile(atomFeedRelativePath, Accept.ATOM);
            ResWrap feedContainer = this.atomDeserializer.toEntitySet(feedIS);
            ((EntitySet)feedContainer.getPayload()).getEntities().add(entry);
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)content, Constants.ENCODING);
            this.atomSerializer.write((Writer)writer, feedContainer);
            writer.flush();
            writer.close();
            FSManager.instance((ODataServiceVersion)this.version).putInMemory((InputStream)new ByteArrayInputStream(content.toByteArray()), FSManager.instance((ODataServiceVersion)this.version).getAbsolutePath(atomFeedRelativePath, Accept.ATOM));
            return utils.createResponse(uriInfo.getRequestUri().toASCIIString() + "(" + entityKey + ")", utils.writeEntity(acceptType, entryContainer), null, acceptType, Response.Status.CREATED);
        }
        catch (Exception e) {
            LOG.error("While creating new contained entity", (Throwable)e);
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @PATCH
    @Path(value="/{entitySetName}({entityId})/{containedEntitySetName}({containedEntityId})")
    public Response patchContainedEntity(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @PathParam(value="containedEntitySetName") String containedEntitySetName, @PathParam(value="containedEntityId") String containedEntityId, @QueryParam(value="$format") @DefaultValue(value="") String format, String changes) {
        try {
            Entity entryChanges;
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            if (acceptType == Accept.XML || acceptType == Accept.TEXT) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            if (StringUtils.isBlank((CharSequence)contentType)) {
                throw new IllegalArgumentException();
            }
            Accept contentTypeValue = Accept.parse((String)contentType, (ODataServiceVersion)this.version);
            LinkInfo links = this.xml.readLinks(entitySetName, entityId, containedEntitySetName + "(" + containedEntityId + ")", Accept.ATOM);
            ResWrap container = this.atomDeserializer.toEntity(links.getLinks());
            Entity original = (Entity)container.getPayload();
            if (Accept.ATOM == contentTypeValue) {
                container = this.atomDeserializer.toEntity(IOUtils.toInputStream((String)changes, (Charset)Constants.ENCODING));
                entryChanges = (Entity)container.getPayload();
            } else {
                String entityType = this.metadata.getEntitySet(entitySetName).getType();
                String containedType = this.metadata.getEntityOrComplexType(entityType).getNavigationProperty(containedEntitySetName).getType();
                EdmTypeInfo typeInfo = new EdmTypeInfo.Builder().setTypeExpression(containedType).build();
                ResWrap jsonContainer = this.jsonDeserializer.toEntity(IOUtils.toInputStream((String)changes, (Charset)Constants.ENCODING));
                ((Entity)jsonContainer.getPayload()).setType(typeInfo.getFullQualifiedName().toString());
                entryChanges = (Entity)jsonContainer.getPayload();
            }
            for (Property property : entryChanges.getProperties()) {
                Property old = original.getProperty(property.getName());
                if (old != null) {
                    original.getProperties().remove(old);
                }
                original.getProperties().add(property);
            }
            FSManager.instance((ODataServiceVersion)this.version).putInMemory(new ResWrap((URI)null, null, (Object)original), this.xml.getLinksBasePath(entitySetName, entityId) + containedEntitySetName + "(" + containedEntityId + ")");
            return this.xml.createResponse(null, null, acceptType, Response.Status.NO_CONTENT);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @DELETE
    @Path(value="/Accounts({entityId})/{containedEntitySetName}({containedEntityId})")
    public Response removeContainedEntity(@PathParam(value="entityId") String entityId, @PathParam(value="containedEntitySetName") String containedEntitySetName, @PathParam(value="containedEntityId") String containedEntityId) {
        try {
            InputStream entry = FSManager.instance((ODataServiceVersion)this.version).readFile(this.containedPath(entityId, containedEntitySetName).append('(').append(containedEntityId).append(')').toString(), Accept.ATOM);
            ResWrap container = this.atomDeserializer.toEntity(entry);
            String atomEntryRelativePath = this.containedPath(entityId, containedEntitySetName).append('(').append(containedEntityId).append(')').toString();
            FSManager.instance((ODataServiceVersion)this.version).deleteFile(atomEntryRelativePath);
            String atomFeedRelativePath = this.containedPath(entityId, containedEntitySetName).toString();
            InputStream feedIS = FSManager.instance((ODataServiceVersion)this.version).readFile(atomFeedRelativePath, Accept.ATOM);
            ResWrap feedContainer = this.atomDeserializer.toEntitySet(feedIS);
            ((EntitySet)feedContainer.getPayload()).getEntities().remove(container.getPayload());
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)content, Constants.ENCODING);
            this.atomSerializer.write((Writer)writer, feedContainer);
            writer.flush();
            writer.close();
            FSManager.instance((ODataServiceVersion)this.version).putInMemory((InputStream)new ByteArrayInputStream(content.toByteArray()), FSManager.instance((ODataServiceVersion)this.version).getAbsolutePath(atomFeedRelativePath, Accept.ATOM));
            return this.xml.createResponse(null, null, null, null, Response.Status.NO_CONTENT);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(Accept.XML.toString(this.version), e);
        }
    }

    @GET
    @Path(value="/Accounts({entityId})/{containedEntitySetName:.*}")
    public Response getContainedEntitySet(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entityId") String entityId, @PathParam(value="containedEntitySetName") String containedEntitySetName, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        if ("MyGiftCard".equals(containedEntitySetName)) {
            return this.getContainedEntity(accept, entityId, containedEntitySetName, null, format);
        }
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            if (acceptType == Accept.XML || acceptType == Accept.TEXT) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            String derivedType = null;
            if (containedEntitySetName.contains("/")) {
                String[] parts = containedEntitySetName.split("/");
                containedEntitySetName = parts[0];
                derivedType = parts[1];
            }
            InputStream feed = FSManager.instance((ODataServiceVersion)this.version).readFile(this.containedPath(entityId, containedEntitySetName).toString(), Accept.ATOM);
            ResWrap container = this.atomDeserializer.toEntitySet(feed);
            if (derivedType != null) {
                ArrayList<Entity> nonMatching = new ArrayList<Entity>();
                for (Entity entity : ((EntitySet)container.getPayload()).getEntities()) {
                    if (derivedType.equals(entity.getType())) continue;
                    nonMatching.add(entity);
                }
                ((EntitySet)container.getPayload()).getEntities().removeAll(nonMatching);
            }
            return this.xml.createResponse(null, this.xml.writeEntitySet(acceptType, container), null, acceptType);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @GET
    @Path(value="/GetDefaultColor()")
    public Response functionGetDefaultColor(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            PropertyImpl property = new PropertyImpl();
            property.setType("Microsoft.Test.OData.Services.ODataWCFService.Color");
            property.setValue(ValueType.ENUM, (Object)"Red");
            ResWrap container = new ResWrap(URI.create(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_METADATA_PREFIX) + property.getType()), null, (Object)property);
            return this.xml.createResponse(null, this.xml.writeProperty(acceptType, container), null, acceptType);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @GET
    @Path(value="/GetPerson2({param:.*})")
    public Response functionGetPerson2(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        return this.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, "Customers", "1", format, null, null);
    }

    @GET
    @Path(value="/GetPerson2({param:.*})/Emails")
    public Response functionGetPerson2Emails(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        return this.getPath(accept, "Customers", "1", "Emails", format);
    }

    @GET
    @Path(value="/GetPerson2({param:.*})/HomeAddress")
    public Response functionGetPerson2HomeAddress(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        return this.getPath(accept, "Customers", "1", "HomeAddress", format);
    }

    @GET
    @Path(value="/GetPerson2({param:.*})/Parent")
    public Response functionGetPerson2Parent(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        return this.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, "Customers", "2", format, null, null);
    }

    @GET
    @Path(value="/GetPerson({param:.*})")
    public Response functionGetPerson(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        return this.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, "Customers", "1", format, null, null);
    }

    @GET
    @Path(value="/GetAllProducts()")
    public Response functionGetAllProducts(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        return this.getEntitySet(uriInfo, accept, "Products", null, null, format, null, null, null, null);
    }

    @GET
    @Path(value="/GetProductsByAccessLevel({param:.*})")
    public Response functionGetProductsByAccessLevel(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            PropertyImpl property = new PropertyImpl();
            property.setType("Collection(String)");
            List<String> value = Arrays.asList("Cheetos", "Mushrooms", "Apple", "Car", "Computer");
            property.setValue(ValueType.COLLECTION_PRIMITIVE, value);
            ResWrap container = new ResWrap(URI.create(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_METADATA_PREFIX) + property.getType()), null, (Object)property);
            return this.xml.createResponse(null, this.xml.writeProperty(acceptType, container), null, acceptType);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @GET
    @Path(value="/GetBossEmails({param:.*})")
    public Response functionGetBossEmails(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            PropertyImpl property = new PropertyImpl();
            property.setType("Collection(Edm.String)");
            property.setValue(ValueType.COLLECTION_PRIMITIVE, Arrays.asList("first@olingo.apache.org", "second@olingo.apache.org"));
            ResWrap container = new ResWrap(URI.create(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_METADATA_PREFIX) + property.getType()), null, (Object)property);
            return this.xml.createResponse(null, this.xml.writeProperty(acceptType, container), null, acceptType);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @POST
    @Path(value="/Discount()")
    public Response actionDiscount(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @QueryParam(value="$format") @DefaultValue(value="") String format, String param) {
        try {
            Property property;
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            Accept contentTypeValue = Accept.parse((String)contentType, (ODataServiceVersion)this.version);
            if (contentTypeValue == Accept.ATOM) {
                ResWrap paramContainer = this.atomDeserializer.toProperty(IOUtils.toInputStream((String)param, (Charset)Constants.ENCODING));
                property = (Property)paramContainer.getPayload();
            } else {
                ResWrap paramContainer = this.jsonDeserializer.toProperty(IOUtils.toInputStream((String)param, (Charset)Constants.ENCODING));
                property = (Property)paramContainer.getPayload();
            }
            assert (property.isComplex());
            assert (1 == property.asComplex().size());
            assert ("Edm.Int32".equals(((Property)property.asComplex().get(0)).getType()));
            assert (((Property)property.asComplex().get(0)).isPrimitive());
            assert ("percentage".equals(((Property)property.asComplex().get(0)).getName()));
            return this.xml.createResponse(null, null, null, acceptType, Response.Status.NO_CONTENT);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @POST
    @Path(value="/GetAllProducts()/Discount")
    public Response actionBoundDiscount() {
        try {
            String basePath = "Products" + File.separatorChar + "feed";
            InputStream feed = FSManager.instance((ODataServiceVersion)this.version).readFile(basePath, Accept.JSON_FULLMETA);
            return this.xml.createResponse(null, feed, Commons.getETag((String)basePath, (ODataServiceVersion)this.version), Accept.JSON_FULLMETA);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(Accept.JSON_FULLMETA.toString(this.version), e);
        }
    }

    @POST
    @Path(value="/ResetBossAddress()")
    public Response actionResetBossAddress(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @QueryParam(value="$format") @DefaultValue(value="") String format, String param) {
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            Accept contentTypeValue = Accept.parse((String)contentType, (ODataServiceVersion)this.version);
            Entity entity = this.xml.readEntity(contentTypeValue, IOUtils.toInputStream((String)param, (Charset)Constants.ENCODING));
            assert ("Microsoft.Test.OData.Services.ODataWCFService.Address".equals(entity.getType()));
            assert (entity.getProperty("address").isComplex());
            ResWrap result = new ResWrap(URI.create(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_METADATA_PREFIX) + "Microsoft.Test.OData.Services.ODataWCFService.Address"), null, (Object)entity.getProperty("address"));
            return this.xml.createResponse(null, this.xml.writeProperty(acceptType, result), null, acceptType);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @POST
    @Path(value="/ResetBossEmail()")
    public Response actionResetBossEmail(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @QueryParam(value="$format") @DefaultValue(value="") String format, String param) {
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            Accept contentTypeValue = Accept.parse((String)contentType, (ODataServiceVersion)this.version);
            Entity entry = this.xml.readEntity(contentTypeValue, IOUtils.toInputStream((String)param, (Charset)Constants.ENCODING));
            assert (1 == entry.getProperties().size());
            assert ("Collection(Edm.String)".equals(entry.getProperty("emails").getType()));
            assert (entry.getProperty("emails").isCollection());
            return this.xml.createResponse(null, this.xml.writeProperty(acceptType, entry.getProperty("emails")), null, acceptType);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @POST
    @Path(value="/Products({productId})/Categories/$ref")
    public Response createLinked(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @QueryParam(value="$format") @DefaultValue(value="") String format, String entity) {
        return this.xml.createResponse(null, null, null, Response.Status.NO_CONTENT);
    }

    @POST
    @Path(value="/Customers(1)/Orders/$ref")
    public Response linkOrderViaRef(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @QueryParam(value="$format") @DefaultValue(value="") String format, String entity) {
        return this.xml.createResponse(null, null, null, Response.Status.NO_CONTENT);
    }

    @DELETE
    @Path(value="/Products({productId})/Categories({categoryId})/$ref")
    public Response deleteLinked(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @QueryParam(value="$format") @DefaultValue(value="") String format, String entity) {
        return this.xml.createResponse(null, null, null, Response.Status.NO_CONTENT);
    }

    @GET
    @Path(value="/Company/VipCustomer")
    public Response getVipCustomer(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format, @QueryParam(value="$expand") @DefaultValue(value="") String expand, @QueryParam(value="$select") @DefaultValue(value="") String select) {
        return super.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, "VipCustomer", "1", format, expand, select);
    }
}

