/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.interceptor.InInterceptors;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.fit.AbstractServices;
import org.apache.olingo.fit.UnsupportedMediaTypeException;
import org.apache.olingo.fit.metadata.Metadata;
import org.apache.olingo.fit.methods.MERGE;
import org.apache.olingo.fit.methods.PATCH;
import org.apache.olingo.fit.rest.XHTTPMethodInterceptor;
import org.apache.olingo.fit.utils.AbstractUtilities;
import org.apache.olingo.fit.utils.Accept;
import org.apache.olingo.fit.utils.Commons;
import org.apache.olingo.fit.utils.ConstantKey;
import org.apache.olingo.fit.utils.Constants;
import org.apache.olingo.fit.utils.FSManager;
import org.apache.olingo.fit.utils.LinkInfo;
import org.springframework.stereotype.Service;

@Service
@Path(value="/V30/Static.svc")
@InInterceptors(classes={XHTTPMethodInterceptor.class})
public class V3Services
extends AbstractServices {
    public V3Services() throws IOException {
        super(ODataServiceVersion.V30, Commons.getMetadata((ODataServiceVersion)ODataServiceVersion.V30));
    }

    protected V3Services(Metadata metadata) throws IOException {
        super(ODataServiceVersion.V30, metadata);
    }

    @GET
    @Path(value="/InStreamErrorGetCustomer")
    public Response instreamErrorGetCustomer(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
        try {
            InputStream error = FSManager.instance((ODataServiceVersion)this.version).readFile("InStreamErrorGetCustomer", acceptType);
            return Response.ok((Object)error).header(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_SERVICE_VERSION), (Object)(this.version + ";")).header("Content-Type", (Object)acceptType.toString(this.version)).build();
        }
        catch (Exception e) {
            if (acceptType == Accept.XML || acceptType == Accept.TEXT) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @GET
    @Path(value="/large/$metadata")
    @Produces(value={"application/xml"})
    public Response getLargeMetadata() {
        return this.getMetadata("large" + StringUtils.capitalize((String)Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.METADATA)));
    }

    protected void setInlineCount(EntitySet feed, String count) {
        if ("allpages".equals(count)) {
            feed.setCount(Integer.valueOf(feed.getEntities().size()));
        }
    }

    public InputStream exploreMultipart(List<Attachment> attachments, String boundary, boolean contineOnError) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Response res = null;
        boolean goon = true;
        for (int i = 0; i < attachments.size() && goon; ++i) {
            try {
                Attachment obj = attachments.get(i);
                bos.write(("--" + boundary).getBytes());
                bos.write(Constants.CRLF);
                Object content = obj.getDataHandler().getContent();
                if (content instanceof MimeMultipart) {
                    HashMap<String, String> references = new HashMap<String, String>();
                    String cboundary = "changeset_" + UUID.randomUUID().toString();
                    bos.write(("Content-Type: multipart/mixed;boundary=" + cboundary).getBytes());
                    bos.write(Constants.CRLF);
                    bos.write(Constants.CRLF);
                    ByteArrayOutputStream chbos = new ByteArrayOutputStream();
                    String lastContebtID = null;
                    try {
                        for (int j = 0; j < ((MimeMultipart)content).getCount(); ++j) {
                            MimeBodyPart part = (MimeBodyPart)((MimeMultipart)content).getBodyPart(j);
                            lastContebtID = part.getContentID();
                            this.addChangesetItemIntro(chbos, lastContebtID, cboundary);
                            res = this.bodyPartRequest(new MimeBodyPart(part.getInputStream()), references);
                            if (res == null || res.getStatus() >= 400) {
                                throw new Exception("Failure processing changeset");
                            }
                            this.addSingleBatchResponse(res, lastContebtID, chbos);
                            references.put("$" + lastContebtID, res.getHeaderString("Location"));
                        }
                        bos.write(chbos.toByteArray());
                        IOUtils.closeQuietly((OutputStream)chbos);
                        bos.write(("--" + cboundary + "--").getBytes());
                        bos.write(Constants.CRLF);
                    }
                    catch (Exception e) {
                        LOG.warn("While processing changeset", (Throwable)e);
                        IOUtils.closeQuietly((OutputStream)chbos);
                        this.addChangesetItemIntro(bos, lastContebtID, cboundary);
                        if (res == null || res.getStatus() < 400) {
                            this.addErrorBatchResponse(e, "1", bos);
                        } else {
                            this.addSingleBatchResponse(res, lastContebtID, bos);
                        }
                        goon = contineOnError;
                    }
                    continue;
                }
                this.addItemIntro(bos);
                res = this.bodyPartRequest(new MimeBodyPart(obj.getDataHandler().getInputStream()));
                if (res.getStatus() >= 400) {
                    goon = contineOnError;
                    throw new Exception("Failure processing changeset");
                }
                this.addSingleBatchResponse(res, bos);
                continue;
            }
            catch (Exception e) {
                if (res == null || res.getStatus() < 400) {
                    this.addErrorBatchResponse(e, bos);
                    continue;
                }
                this.addSingleBatchResponse(res, bos);
            }
        }
        bos.write(("--" + boundary + "--").getBytes());
        return new ByteArrayInputStream(bos.toByteArray());
    }

    @GET
    @Path(value="/Car/{type:[a-zA-Z].*}")
    public Response filterCar(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$top") @DefaultValue(value="") String top, @QueryParam(value="$skip") @DefaultValue(value="") String skip, @QueryParam(value="$format") @DefaultValue(value="") String format, @QueryParam(value="$inlinecount") @DefaultValue(value="") String count, @QueryParam(value="$filter") @DefaultValue(value="") String filter, @QueryParam(value="$orderby") @DefaultValue(value="") String orderby, @QueryParam(value="$skiptoken") @DefaultValue(value="") String skiptoken) {
        return super.getEntitySet(uriInfo, accept, "Car", top, skip, format, count, filter, orderby, skiptoken);
    }

    @GET
    @Path(value="/Login({entityId})")
    public Response getLogin(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entityId") String entityId, @QueryParam(value="$format") @DefaultValue(value="") String format, @QueryParam(value="$expand") @DefaultValue(value="") String expand, @QueryParam(value="$select") @DefaultValue(value="") String select) {
        return super.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, "Login", StringUtils.remove((String)entityId, (String)"'"), format, expand, select);
    }

    @POST
    @Path(value="/Login")
    @Produces(value={"application/xml", "application/atom+xml", "application/json"})
    @Consumes(value={"application/atom+xml", "application/json", "application/octet-stream"})
    public Response postLogin(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, String entity) {
        if ("{\"odata.type\":\"Microsoft.Test.OData.Services.AstoriaDefaultService.Login\"}".equals(entity)) {
            return this.xml.createFaultResponse(accept, (Exception)new BadRequestException());
        }
        return super.postNewEntity(uriInfo, accept, contentType, prefer, "Login", entity);
    }

    @DELETE
    @Path(value="/Login({entityId})")
    public Response removeLogin(@PathParam(value="entityId") String entityId) {
        return super.removeEntity("Login", StringUtils.remove((String)entityId, (String)"'"));
    }

    @GET
    @Path(value="/{entitySetName}({entityId})/$links/{linkName}")
    public Response getLinks(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @PathParam(value="linkName") String linkName, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            if (acceptType == Accept.ATOM) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            LinkInfo links = this.xml.readLinks(entitySetName, entityId, linkName, acceptType);
            return this.xml.createResponse(links.getLinks(), links.getEtag(), acceptType);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @POST
    @Path(value="/{entitySetName}({entityId})/$links/{linkName}")
    public Response postLink(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @PathParam(value="linkName") String linkName, String link, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            if (acceptType == Accept.ATOM) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            Accept content = StringUtils.isNotBlank((CharSequence)contentType) ? Accept.parse((String)contentType, (ODataServiceVersion)this.version) : acceptType;
            AbstractUtilities utils = this.getUtilities(acceptType);
            List links = content == Accept.XML || content == Accept.TEXT || content == Accept.ATOM ? (List)this.xml.extractLinkURIs(IOUtils.toInputStream((String)link, (Charset)Constants.ENCODING)).getValue() : (List)this.json.extractLinkURIs(IOUtils.toInputStream((String)link, (Charset)Constants.ENCODING)).getValue();
            utils.putLinksInMemory(Commons.getEntityBasePath((String)entitySetName, (String)entityId), entitySetName, entityId, linkName, (Collection)links);
            return this.xml.createResponse(null, null, null, Response.Status.NO_CONTENT);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @MERGE
    @Path(value="/{entitySetName}({entityId})/$links/{linkName}")
    public Response mergeLink(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @PathParam(value="linkName") String linkName, String link, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        return this.putLink(accept, contentType, entitySetName, entityId, linkName, link, format);
    }

    @PATCH
    @Path(value="/{entitySetName}({entityId})/$links/{linkName}")
    public Response patchLink(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @PathParam(value="linkName") String linkName, String link, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        return this.putLink(accept, contentType, entitySetName, entityId, linkName, link, format);
    }

    @PUT
    @Path(value="/{entitySetName}({entityId})/$links/{linkName}")
    public Response putLink(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @PathParam(value="linkName") String linkName, String link, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            if (acceptType == Accept.ATOM) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            Accept content = StringUtils.isNotBlank((CharSequence)contentType) ? Accept.parse((String)contentType, (ODataServiceVersion)this.version) : acceptType;
            AbstractUtilities utils = this.getUtilities(acceptType);
            List links = content == Accept.XML || content == Accept.TEXT || content == Accept.ATOM ? (List)this.xml.extractLinkURIs(IOUtils.toInputStream((String)link, (Charset)Constants.ENCODING)).getValue() : (List)this.json.extractLinkURIs(IOUtils.toInputStream((String)link, (Charset)Constants.ENCODING)).getValue();
            utils.putLinksInMemory(Commons.getEntityBasePath((String)entitySetName, (String)entityId), entitySetName, linkName, (Collection)links);
            return this.xml.createResponse(null, null, null, Response.Status.NO_CONTENT);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @DELETE
    @Path(value="/{entitySetName}({entityId})/$links/{linkName}({linkId})")
    public Response deleteLink(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @PathParam(value="linkName") String linkName, @PathParam(value="linkId") String linkId, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            if (acceptType == Accept.ATOM) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            AbstractUtilities utils = this.getUtilities(acceptType);
            Map.Entry currents = this.json.extractLinkURIs(utils.readLinks(entitySetName, entityId, linkName, Accept.JSON_FULLMETA).getLinks());
            Map.Entry toBeRemoved = this.json.extractLinkURIs(utils.readLinks(entitySetName, entityId, linkName + "(" + linkId + ")", Accept.JSON_FULLMETA).getLinks());
            List remains = (List)currents.getValue();
            remains.removeAll((Collection)toBeRemoved.getValue());
            utils.putLinksInMemory(Commons.getEntityBasePath((String)entitySetName, (String)entityId), entitySetName, linkName, (Collection)remains);
            return this.xml.createResponse(null, null, null, Response.Status.NO_CONTENT);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }
}

