/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.fit.UnsupportedMediaTypeException;
import org.apache.olingo.fit.V3Services;
import org.apache.olingo.fit.metadata.Metadata;
import org.apache.olingo.fit.utils.AbstractUtilities;
import org.apache.olingo.fit.utils.Accept;
import org.apache.olingo.fit.utils.Commons;
import org.apache.olingo.fit.utils.ConstantKey;
import org.apache.olingo.fit.utils.Constants;
import org.apache.olingo.fit.utils.FSManager;
import org.springframework.stereotype.Service;

@Service
@Path(value="/V30/ActionOverloading.svc")
public class V3ActionOverloading
extends V3Services {
    public V3ActionOverloading() throws IOException {
        super(new Metadata(FSManager.instance((ODataServiceVersion)ODataServiceVersion.V30).readRes("actionOverloading" + StringUtils.capitalize((String)Constants.get((ODataServiceVersion)ODataServiceVersion.V30, (ConstantKey)ConstantKey.METADATA)), Accept.XML), ODataServiceVersion.V30));
    }

    private Response replaceServiceName(Response response) {
        try {
            String content = IOUtils.toString((InputStream)((InputStream)response.getEntity()), (Charset)Constants.ENCODING).replaceAll("Static\\.svc", "ActionOverloading.svc");
            Response.ResponseBuilder builder = Response.status((int)response.getStatus());
            for (String headerName : response.getHeaders().keySet()) {
                for (Object headerValue : (List)response.getHeaders().get((Object)headerName)) {
                    builder.header(headerName, headerValue);
                }
            }
            InputStream toBeStreamedBack = IOUtils.toInputStream((String)content, (Charset)Constants.ENCODING);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)toBeStreamedBack, (OutputStream)baos);
            IOUtils.closeQuietly((InputStream)toBeStreamedBack);
            builder.header("Content-Length", (Object)baos.size());
            builder.entity((Object)new ByteArrayInputStream(baos.toByteArray()));
            return builder.build();
        }
        catch (Exception e) {
            return response;
        }
    }

    @GET
    @Path(value="/$metadata")
    @Produces(value={"application/xml"})
    public Response getMetadata() {
        return super.getMetadata("actionOverloading" + StringUtils.capitalize((String)Constants.get((ODataServiceVersion)ODataServiceVersion.V30, (ConstantKey)ConstantKey.METADATA)));
    }

    @POST
    @Path(value="/RetrieveProduct")
    public Response unboundRetrieveProduct(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType) {
        Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)ODataServiceVersion.V30);
        if (acceptType == Accept.XML || acceptType == Accept.TEXT) {
            throw new UnsupportedMediaTypeException("Unsupported media type");
        }
        try {
            InputStream result = FSManager.instance((ODataServiceVersion)ODataServiceVersion.V30).readFile("actionOverloadingRetrieveProduct", acceptType);
            return this.replaceServiceName(this.xml.createResponse(result, null, acceptType));
        }
        catch (Exception e) {
            return this.replaceServiceName(this.xml.createFaultResponse(accept, e));
        }
    }

    @GET
    @Path(value="/Product({entityId})")
    public Response getProduct(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entityId") String entityId, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        Map.Entry utils = super.getUtilities(accept, format);
        if (utils.getKey() == Accept.XML || utils.getKey() == Accept.TEXT) {
            throw new UnsupportedMediaTypeException("Unsupported media type");
        }
        Map.Entry entityInfo = ((AbstractUtilities)utils.getValue()).readEntity("Product", entityId, (Accept)utils.getKey());
        InputStream entity = (InputStream)entityInfo.getValue();
        try {
            if (utils.getKey() == Accept.JSON_FULLMETA || utils.getKey() == Accept.ATOM) {
                entity = ((AbstractUtilities)utils.getValue()).addOperation(entity, "RetrieveProduct", "#DefaultContainer.RetrieveProduct", uriInfo.getAbsolutePath().toASCIIString() + "/RetrieveProduct");
            }
            return this.replaceServiceName(((AbstractUtilities)utils.getValue()).createResponse(entity, Commons.getETag((String)((String)entityInfo.getKey()), (ODataServiceVersion)ODataServiceVersion.V30), (Accept)utils.getKey()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving entity", (Throwable)e);
            return this.replaceServiceName(this.xml.createFaultResponse(accept, e));
        }
    }

    @POST
    @Path(value="/Product({entityId})/{path:.*RetrieveProduct}")
    public Response productBoundRetrieveProduct(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType) {
        return this.unboundRetrieveProduct(accept, format, contentType);
    }

    @GET
    @Path(value="/OrderLine(OrderId={orderId},ProductId={productId})")
    public Response getOrderLine(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="orderId") String orderId, @PathParam(value="productId") String productId, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        Map.Entry utils = super.getUtilities(accept, format);
        if (utils.getKey() == Accept.XML || utils.getKey() == Accept.TEXT) {
            throw new UnsupportedMediaTypeException("Unsupported media type");
        }
        Map.Entry entityInfo = ((AbstractUtilities)utils.getValue()).readEntity("OrderLine", orderId + " " + productId, (Accept)utils.getKey());
        InputStream entity = (InputStream)entityInfo.getValue();
        try {
            if (utils.getKey() == Accept.JSON_FULLMETA || utils.getKey() == Accept.ATOM) {
                entity = ((AbstractUtilities)utils.getValue()).addOperation(entity, "RetrieveProduct", "#DefaultContainer.RetrieveProduct", uriInfo.getAbsolutePath().toASCIIString() + "/RetrieveProduct");
            }
            return this.replaceServiceName(((AbstractUtilities)utils.getValue()).createResponse(entity, Commons.getETag((String)((String)entityInfo.getKey()), (ODataServiceVersion)ODataServiceVersion.V30), (Accept)utils.getKey()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving entity", (Throwable)e);
            return this.replaceServiceName(this.xml.createFaultResponse(accept, e));
        }
    }

    @POST
    @Path(value="/OrderLine(OrderId={orderId},ProductId={productId})/{path:.*RetrieveProduct}")
    public Response orderLineBoundRetrieveProduct(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @QueryParam(value="$format") @DefaultValue(value="") String format, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType) {
        return this.unboundRetrieveProduct(accept, format, contentType);
    }
}

