/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Header;
import javax.mail.internet.MimeBodyPart;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.LinkedComplexValue;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.serialization.ODataDeserializer;
import org.apache.olingo.commons.api.serialization.ODataSerializer;
import org.apache.olingo.commons.core.data.EntityImpl;
import org.apache.olingo.commons.core.data.EntitySetImpl;
import org.apache.olingo.commons.core.data.LinkImpl;
import org.apache.olingo.commons.core.data.PropertyImpl;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.commons.core.serialization.AtomSerializer;
import org.apache.olingo.commons.core.serialization.JsonDeserializer;
import org.apache.olingo.commons.core.serialization.JsonSerializer;
import org.apache.olingo.fit.UnsupportedMediaTypeException;
import org.apache.olingo.fit.V3KeyAsSegment;
import org.apache.olingo.fit.V4KeyAsSegment;
import org.apache.olingo.fit.metadata.EntitySet;
import org.apache.olingo.fit.metadata.EntityType;
import org.apache.olingo.fit.metadata.Metadata;
import org.apache.olingo.fit.metadata.NavigationProperty;
import org.apache.olingo.fit.metadata.Property;
import org.apache.olingo.fit.methods.MERGE;
import org.apache.olingo.fit.methods.PATCH;
import org.apache.olingo.fit.serializer.FITAtomDeserializer;
import org.apache.olingo.fit.utils.AbstractUtilities;
import org.apache.olingo.fit.utils.Accept;
import org.apache.olingo.fit.utils.Commons;
import org.apache.olingo.fit.utils.ConstantKey;
import org.apache.olingo.fit.utils.Constants;
import org.apache.olingo.fit.utils.FSManager;
import org.apache.olingo.fit.utils.JSONUtilities;
import org.apache.olingo.fit.utils.LinkInfo;
import org.apache.olingo.fit.utils.XMLUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServices {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractServices.class);
    private static final Pattern REQUEST_PATTERN = Pattern.compile("(.*) (http://.*) HTTP/.*");
    private static final Pattern BATCH_REQUEST_REF_PATTERN = Pattern.compile("(.*) ([$]\\d+)(.*) HTTP/.*");
    private static final Pattern REF_PATTERN = Pattern.compile("([$]\\d+)");
    protected static final String BOUNDARY = "batch_243234_25424_ef_892u748";
    protected static final String MULTIPART_MIXED = "multipart/mixed";
    protected static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    protected final ODataServiceVersion version;
    protected final Metadata metadata;
    protected final ODataDeserializer atomDeserializer;
    protected final ODataDeserializer jsonDeserializer;
    protected final ODataSerializer atomSerializer;
    protected final ODataSerializer jsonSerializer;
    protected final XMLUtilities xml;
    protected final JSONUtilities json;

    public AbstractServices(ODataServiceVersion version, Metadata metadata) throws IOException {
        this.version = version;
        this.metadata = metadata;
        this.atomDeserializer = new FITAtomDeserializer(version);
        this.jsonDeserializer = new JsonDeserializer(version, true);
        this.atomSerializer = new AtomSerializer(version, true);
        this.jsonSerializer = new JsonSerializer(version, true);
        this.xml = new XMLUtilities(version, metadata);
        this.json = new JSONUtilities(version, metadata);
    }

    @GET
    public Response getSevices(@HeaderParam(value="Accept") @DefaultValue(value="") String accept) {
        try {
            Accept acceptType = Accept.parse((String)accept, (ODataServiceVersion)this.version);
            if (acceptType == Accept.ATOM) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            return this.xml.createResponse(null, FSManager.instance((ODataServiceVersion)this.version).readFile(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.SERVICES), acceptType), null, acceptType);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @GET
    @Path(value="/$metadata")
    @Produces(value={"application/xml"})
    public Response getMetadata() {
        return this.getMetadata(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.METADATA));
    }

    protected Response getMetadata(String filename) {
        try {
            return this.xml.createResponse(null, FSManager.instance((ODataServiceVersion)this.version).readRes(filename, Accept.XML), null, Accept.XML);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(Accept.XML.toString(this.version), e);
        }
    }

    @POST
    @Path(value="/$batch")
    @Consumes(value={"multipart/mixed"})
    @Produces(value={"application/octet-stream;boundary=batch_243234_25424_ef_892u748"})
    public Response batch(@HeaderParam(value="Authorization") @DefaultValue(value="") String authorization, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, @Multipart MultipartBody attachment) {
        try {
            boolean continueOnError = prefer.contains("odata.continue-on-error");
            return this.xml.createBatchResponse(this.exploreMultipart(attachment.getAllAttachments(), BOUNDARY, continueOnError));
        }
        catch (IOException e) {
            return this.xml.createFaultResponse(Accept.XML.toString(this.version), (Exception)e);
        }
    }

    @PATCH
    @Path(value="/Driver('2')")
    public Response patchDriver() {
        return this.xml.createFaultResponse(Accept.JSON_FULLMETA.toString(this.version), new Exception("Non nullable properties"));
    }

    @GET
    @Path(value="/StoredPIs(1000)")
    public Response getStoredPI(@Context UriInfo uriInfo) {
        EntityImpl entity = new EntityImpl();
        entity.setType("Microsoft.Test.OData.Services.ODataWCFService.StoredPI");
        PropertyImpl id = new PropertyImpl();
        id.setType("Edm.Int32");
        id.setName("StoredPIID");
        id.setValue(ValueType.PRIMITIVE, (Object)1000);
        entity.getProperties().add(id);
        LinkImpl edit = new LinkImpl();
        edit.setHref(uriInfo.getRequestUri().toASCIIString());
        edit.setRel("edit");
        edit.setTitle("StoredPI");
        entity.setEditLink((Link)edit);
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)content, Constants.ENCODING);
        try {
            this.jsonSerializer.write((Writer)writer, new ResWrap((URI)null, null, (Object)entity));
            return this.xml.createResponse((InputStream)new ByteArrayInputStream(content.toByteArray()), null, Accept.JSON_FULLMETA);
        }
        catch (Exception e) {
            LOG.error("While creating StoredPI", (Throwable)e);
            return this.xml.createFaultResponse(Accept.JSON_FULLMETA.toString(this.version), e);
        }
    }

    @PATCH
    @Path(value="/StoredPIs(1000)")
    public Response patchStoredPI() {
        return this.xml.createFaultResponse(Accept.JSON_FULLMETA.toString(this.version), new Exception("Non nullable properties"));
    }

    protected Response bodyPartRequest(MimeBodyPart body) throws Exception {
        return this.bodyPartRequest(body, Collections.emptyMap());
    }

    protected Response bodyPartRequest(MimeBodyPart body, Map<String, String> references) throws Exception {
        Response res;
        String method;
        String url;
        Enumeration en = body.getAllHeaders();
        Header header = (Header)en.nextElement();
        String request = header.getName() + (StringUtils.isNotBlank((CharSequence)header.getValue()) ? ":" + header.getValue() : "");
        Matcher matcher = REQUEST_PATTERN.matcher(request);
        Matcher matcherRef = BATCH_REQUEST_REF_PATTERN.matcher(request);
        MultivaluedHashMap headers = new MultivaluedHashMap();
        while (en.hasMoreElements()) {
            header = (Header)en.nextElement();
            headers.putSingle((Object)header.getName(), (Object)header.getValue());
        }
        if (matcher.find()) {
            url = matcher.group(2);
            method = matcher.group(1);
        } else if (matcherRef.find()) {
            url = references.get(matcherRef.group(2)) + matcherRef.group(3);
            method = matcherRef.group(1);
        } else {
            url = null;
            method = null;
        }
        if (url == null) {
            res = null;
        } else {
            WebClient client = WebClient.create((String)url, (String)"odatajclient", (String)"odatajclient", null);
            client.headers((MultivaluedMap)headers);
            if ("DELETE".equals(method)) {
                res = client.delete();
            } else {
                InputStream is = body.getDataHandler().getInputStream();
                String content = IOUtils.toString((InputStream)is);
                IOUtils.closeQuietly((InputStream)is);
                Matcher refs = REF_PATTERN.matcher(content);
                while (refs.find()) {
                    content = content.replace(refs.group(1), references.get(refs.group(1)));
                }
                if ("PATCH".equals(method) || "MERGE".equals(method)) {
                    client.header("X-HTTP-METHOD", new Object[]{method});
                    res = client.invoke("POST", (Object)IOUtils.toInputStream((String)content));
                } else {
                    res = client.invoke(method, (Object)IOUtils.toInputStream((String)content));
                }
            }
        }
        return res;
    }

    protected abstract InputStream exploreMultipart(List<Attachment> var1, String var2, boolean var3) throws IOException;

    protected void addItemIntro(ByteArrayOutputStream bos) throws IOException {
        this.addItemIntro(bos, null);
    }

    protected void addItemIntro(ByteArrayOutputStream bos, String contentId) throws IOException {
        bos.write("Content-Type: application/http".getBytes());
        bos.write(Constants.CRLF);
        bos.write("Content-Transfer-Encoding: binary".getBytes());
        bos.write(Constants.CRLF);
        if (StringUtils.isNotBlank((CharSequence)contentId)) {
            bos.write(("Content-ID: " + contentId).getBytes());
            bos.write(Constants.CRLF);
        }
        bos.write(Constants.CRLF);
    }

    protected void addChangesetItemIntro(ByteArrayOutputStream bos, String contentId, String cboundary) throws IOException {
        bos.write(("--" + cboundary).getBytes());
        bos.write(Constants.CRLF);
        bos.write(("Content-ID: " + contentId).getBytes());
        bos.write(Constants.CRLF);
        this.addItemIntro(bos);
    }

    protected void addSingleBatchResponse(Response response, ByteArrayOutputStream bos) throws IOException {
        this.addSingleBatchResponse(response, null, bos);
    }

    protected void addSingleBatchResponse(Response response, String contentId, ByteArrayOutputStream bos) throws IOException {
        bos.write("HTTP/1.1 ".getBytes());
        bos.write(String.valueOf(response.getStatusInfo().getStatusCode()).getBytes());
        bos.write(" ".getBytes());
        bos.write(response.getStatusInfo().getReasonPhrase().getBytes());
        bos.write(Constants.CRLF);
        for (Map.Entry header : response.getHeaders().entrySet()) {
            StringBuilder builder = new StringBuilder();
            for (Object value : (List)header.getValue()) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(value.toString());
            }
            builder.insert(0, ": ").insert(0, (String)header.getKey());
            bos.write(builder.toString().getBytes());
            bos.write(Constants.CRLF);
        }
        if (StringUtils.isNotBlank((CharSequence)contentId)) {
            bos.write(("Content-ID: " + contentId).getBytes());
            bos.write(Constants.CRLF);
        }
        bos.write(Constants.CRLF);
        Object entity = response.getEntity();
        if (entity != null) {
            bos.write(IOUtils.toByteArray((InputStream)((InputStream)entity)));
            bos.write(Constants.CRLF);
        }
        bos.write(Constants.CRLF);
    }

    protected void addErrorBatchResponse(Exception e, ByteArrayOutputStream bos) throws IOException {
        this.addErrorBatchResponse(e, null, bos);
    }

    protected void addErrorBatchResponse(Exception e, String contentId, ByteArrayOutputStream bos) throws IOException {
        this.addSingleBatchResponse(this.xml.createFaultResponse(Accept.XML.toString(this.version), e), contentId, bos);
    }

    @MERGE
    @Path(value="/{entitySetName}({entityId})")
    @Produces(value={"application/xml", "application/atom+xml", "application/json"})
    @Consumes(value={"application/atom+xml", "application/json"})
    public Response mergeEntity(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, @HeaderParam(value="If-Match") @DefaultValue(value="") String ifMatch, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, String changes) {
        return this.patchEntity(uriInfo, accept, contentType, prefer, ifMatch, entitySetName, entityId, changes);
    }

    @PATCH
    @Path(value="/{entitySetName}({entityId})")
    @Produces(value={"application/xml", "application/atom+xml", "application/json"})
    @Consumes(value={"application/atom+xml", "application/json"})
    public Response patchEntity(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, @HeaderParam(value="If-Match") @DefaultValue(value="") String ifMatch, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, String changes) {
        try {
            Response response;
            Entity entryChanges;
            Accept acceptType = Accept.parse((String)accept, (ODataServiceVersion)this.version);
            if (acceptType == Accept.XML || acceptType == Accept.TEXT) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            Map.Entry entityInfo = this.xml.readEntity(entitySetName, entityId, Accept.ATOM);
            String etag = Commons.getETag((String)((String)entityInfo.getKey()), (ODataServiceVersion)this.version);
            if (StringUtils.isNotBlank((CharSequence)ifMatch) && !ifMatch.equals(etag)) {
                throw new ConcurrentModificationException("Concurrent modification");
            }
            Accept contentTypeValue = Accept.parse((String)contentType, (ODataServiceVersion)this.version);
            if (contentTypeValue == Accept.XML || contentTypeValue == Accept.TEXT) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            if (contentTypeValue == Accept.ATOM) {
                entryChanges = (Entity)this.atomDeserializer.toEntity(IOUtils.toInputStream((String)changes, (Charset)Constants.ENCODING)).getPayload();
            } else {
                ResWrap jcont = this.jsonDeserializer.toEntity(IOUtils.toInputStream((String)changes, (Charset)Constants.ENCODING));
                entryChanges = (Entity)jcont.getPayload();
            }
            ResWrap container = this.atomDeserializer.toEntity((InputStream)entityInfo.getValue());
            for (org.apache.olingo.commons.api.data.Property property : entryChanges.getProperties()) {
                org.apache.olingo.commons.api.data.Property _property = ((Entity)container.getPayload()).getProperty(property.getName());
                if (_property == null) {
                    ((Entity)container.getPayload()).getProperties().add(property);
                    continue;
                }
                _property.setValue(property.getValueType(), property.getValue());
            }
            for (Link link : entryChanges.getNavigationLinks()) {
                ((Entity)container.getPayload()).getNavigationLinks().add(link);
            }
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)content, Constants.ENCODING);
            this.atomSerializer.write((Writer)writer, container);
            writer.flush();
            writer.close();
            InputStream res = this.xml.addOrReplaceEntity(entityId, entitySetName, (InputStream)new ByteArrayInputStream(content.toByteArray()), (Entity)container.getPayload());
            ResWrap cres = this.atomDeserializer.toEntity(res);
            this.normalizeAtomEntry((Entity)cres.getPayload(), entitySetName, entityId);
            String path = Commons.getEntityBasePath((String)entitySetName, (String)entityId);
            FSManager.instance((ODataServiceVersion)this.version).putInMemory(cres, path + File.separatorChar + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY));
            if ("return-content".equalsIgnoreCase(prefer)) {
                response = this.xml.createResponse(uriInfo.getRequestUri().toASCIIString(), (InputStream)this.xml.readEntity(entitySetName, entityId, acceptType).getValue(), null, acceptType, Response.Status.OK);
            } else {
                res.close();
                response = this.xml.createResponse(uriInfo.getRequestUri().toASCIIString(), null, null, acceptType, Response.Status.NO_CONTENT);
            }
            if (StringUtils.isNotBlank((CharSequence)prefer)) {
                response.getHeaders().put((Object)"Preference-Applied", Collections.singletonList(prefer));
            }
            return response;
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @PUT
    @Path(value="/{entitySetName}({entityId})")
    @Produces(value={"application/xml", "application/atom+xml", "application/json"})
    @Consumes(value={"application/atom+xml", "application/json"})
    public Response replaceEntity(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, String entity) {
        try {
            Response response;
            Accept acceptType = Accept.parse((String)accept, (ODataServiceVersion)this.version);
            if (acceptType == Accept.XML || acceptType == Accept.TEXT) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            InputStream res = this.getUtilities(acceptType).addOrReplaceEntity(entityId, entitySetName, IOUtils.toInputStream((String)entity, (Charset)Constants.ENCODING), this.xml.readEntity(acceptType, IOUtils.toInputStream((String)entity, (Charset)Constants.ENCODING)));
            ResWrap cres = acceptType == Accept.ATOM ? this.atomDeserializer.toEntity(res) : this.jsonDeserializer.toEntity(res);
            String path = Commons.getEntityBasePath((String)entitySetName, (String)entityId);
            FSManager.instance((ODataServiceVersion)this.version).putInMemory(cres, path + File.separatorChar + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY));
            if ("return-content".equalsIgnoreCase(prefer)) {
                response = this.xml.createResponse(uriInfo.getRequestUri().toASCIIString(), (InputStream)this.xml.readEntity(entitySetName, entityId, acceptType).getValue(), null, acceptType, Response.Status.OK);
            } else {
                res.close();
                response = this.xml.createResponse(uriInfo.getRequestUri().toASCIIString(), null, null, acceptType, Response.Status.NO_CONTENT);
            }
            if (StringUtils.isNotBlank((CharSequence)prefer)) {
                response.getHeaders().put((Object)"Preference-Applied", Collections.singletonList(prefer));
            }
            return response;
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @POST
    @Path(value="/{entitySetName}")
    @Produces(value={"application/xml", "application/atom+xml", "application/json"})
    @Consumes(value={"application/atom+xml", "application/json", "application/octet-stream"})
    public Response postNewEntity(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, @PathParam(value="entitySetName") String entitySetName, String entity) {
        try {
            String location;
            ResWrap container;
            String entityKey;
            EntityImpl entry;
            Accept acceptType = Accept.parse((String)accept, (ODataServiceVersion)this.version);
            if (acceptType == Accept.XML || acceptType == Accept.TEXT) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            EntitySet entitySet = this.metadata.getEntitySet(entitySetName);
            if (this.xml.isMediaContent(entitySetName)) {
                entry = new EntityImpl();
                entry.setMediaContentType(ContentType.APPLICATION_OCTET_STREAM.toContentTypeString());
                entry.setType(entitySet.getType());
                entityKey = this.xml.getDefaultEntryKey(entitySetName, (Entity)entry);
                this.xml.addMediaEntityValue(entitySetName, entityKey, IOUtils.toInputStream((String)entity, (Charset)Constants.ENCODING));
                Pair id = (Pair)Commons.getMediaContent().get(entitySetName);
                if (id != null) {
                    PropertyImpl prop = new PropertyImpl();
                    prop.setName((String)id.getKey());
                    prop.setType(((EdmPrimitiveTypeKind)id.getValue()).toString());
                    prop.setValue(ValueType.PRIMITIVE, id.getValue() == EdmPrimitiveTypeKind.Int32 ? Integer.valueOf(Integer.parseInt(entityKey)) : (id.getValue() == EdmPrimitiveTypeKind.Guid ? UUID.fromString(entityKey) : entityKey));
                    entry.getProperties().add(prop);
                }
                LinkImpl editLink = new LinkImpl();
                editLink.setHref(Commons.getEntityURI((String)entitySetName, (String)entityKey));
                editLink.setRel("edit");
                editLink.setTitle(entitySetName);
                entry.setEditLink((Link)editLink);
                entry.setMediaContentSource(URI.create(editLink.getHref() + "/$value"));
                container = new ResWrap((URI)null, null, (Object)entry);
            } else {
                Accept contentTypeValue = Accept.parse((String)contentType, (ODataServiceVersion)this.version);
                container = Accept.ATOM == contentTypeValue ? this.atomDeserializer.toEntity(IOUtils.toInputStream((String)entity, (Charset)Constants.ENCODING)) : this.jsonDeserializer.toEntity(IOUtils.toInputStream((String)entity, (Charset)Constants.ENCODING));
                entry = (Entity)container.getPayload();
                this.updateInlineEntities((Entity)entry);
                entityKey = this.xml.getDefaultEntryKey(entitySetName, (Entity)entry);
            }
            this.normalizeAtomEntry((Entity)entry, entitySetName, entityKey);
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)content, Constants.ENCODING);
            this.atomSerializer.write((Writer)writer, container);
            writer.flush();
            writer.close();
            InputStream serialization = this.xml.addOrReplaceEntity(entityKey, entitySetName, (InputStream)new ByteArrayInputStream(content.toByteArray()), (Entity)entry);
            ResWrap result = this.atomDeserializer.toEntity(serialization);
            result = new ResWrap(URI.create(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_METADATA_PREFIX) + entitySetName + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_METADATA_ENTITY_SUFFIX)), null, result.getPayload());
            String path = Commons.getEntityBasePath((String)entitySetName, (String)entityKey);
            FSManager.instance((ODataServiceVersion)this.version).putInMemory(result, path + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY));
            if (this instanceof V3KeyAsSegment || this instanceof V4KeyAsSegment) {
                location = uriInfo.getRequestUri().toASCIIString() + "/" + entityKey;
                LinkImpl editLink = new LinkImpl();
                editLink.setRel("edit");
                editLink.setTitle(entitySetName);
                editLink.setHref(location);
                ((Entity)result.getPayload()).setEditLink((Link)editLink);
            } else {
                location = uriInfo.getRequestUri().toASCIIString() + "(" + entityKey + ")";
            }
            Response response = "return-no-content".equalsIgnoreCase(prefer) ? this.xml.createResponse(location, null, null, acceptType, Response.Status.NO_CONTENT) : this.xml.createResponse(location, this.xml.writeEntity(acceptType, result), null, acceptType, Response.Status.CREATED);
            if (StringUtils.isNotBlank((CharSequence)prefer)) {
                response.getHeaders().put((Object)"Preference-Applied", Collections.singletonList(prefer));
            }
            return response;
        }
        catch (Exception e) {
            LOG.error("While creating new entity", (Throwable)e);
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @POST
    @Path(value="/Person({entityId})/{type:.*}/Sack")
    public Response actionSack(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entityId") String entityId, @PathParam(value="type") String type, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        Map.Entry utils = this.getUtilities(accept, format);
        if (utils.getKey() == Accept.XML || utils.getKey() == Accept.TEXT) {
            throw new UnsupportedMediaTypeException("Unsupported media type");
        }
        try {
            Map.Entry entityInfo = this.xml.readEntity("Person", entityId, Accept.ATOM);
            InputStream entity = (InputStream)entityInfo.getValue();
            ResWrap container = this.atomDeserializer.toEntity(entity);
            ((Entity)container.getPayload()).getProperty("Salary").setValue(ValueType.PRIMITIVE, (Object)0);
            ((Entity)container.getPayload()).getProperty("Title").setValue(ValueType.PRIMITIVE, (Object)"[Sacked]");
            FSManager fsManager = FSManager.instance((ODataServiceVersion)this.version);
            fsManager.putInMemory(this.xml.writeEntity(Accept.ATOM, container), fsManager.getAbsolutePath(Commons.getEntityBasePath((String)"Person", (String)entityId) + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY), Accept.ATOM));
            return ((AbstractUtilities)utils.getValue()).createResponse(null, null, null, (Accept)utils.getKey(), Response.Status.NO_CONTENT);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @POST
    @Path(value="/Person/{type:.*}/IncreaseSalaries")
    public Response actionIncreaseSalaries(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="type") String type, @QueryParam(value="$format") @DefaultValue(value="") String format, String body) {
        String name = "Person";
        try {
            Accept acceptType = Accept.parse((String)accept, (ODataServiceVersion)this.version);
            if (acceptType == Accept.XML || acceptType == Accept.TEXT) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            JsonNode tree = new ObjectMapper().readTree(body);
            if (!tree.has("n")) {
                throw new Exception("Missing parameter: n");
            }
            int n = tree.get("n").asInt();
            StringBuilder path = new StringBuilder("Person").append(File.separatorChar).append(type).append(File.separatorChar);
            path.append(this.metadata.getEntitySet("Person").isSingleton() ? Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY) : Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.FEED));
            InputStream feed = FSManager.instance((ODataServiceVersion)this.version).readFile(path.toString(), acceptType);
            ByteArrayOutputStream copy = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)feed, (OutputStream)copy);
            IOUtils.closeQuietly((InputStream)feed);
            String newContent = new String(copy.toByteArray(), "UTF-8");
            Pattern salary = Pattern.compile(acceptType == Accept.ATOM ? "\\<d:Salary m:type=\"Edm.Int32\"\\>(-?\\d+)\\</d:Salary\\>" : "\"Salary\":(-?\\d+),");
            Matcher salaryMatcher = salary.matcher(newContent);
            while (salaryMatcher.find()) {
                Long newSalary = Long.valueOf(salaryMatcher.group(1)) + (long)n;
                newContent = newContent.replaceAll("\"Salary\":" + salaryMatcher.group(1) + ",", "\"Salary\":" + newSalary + ",").replaceAll("\\<d:Salary m:type=\"Edm.Int32\"\\>" + salaryMatcher.group(1) + "</d:Salary\\>", "<d:Salary m:type=\"Edm.Int32\">" + newSalary + "</d:Salary>");
            }
            FSManager.instance((ODataServiceVersion)this.version).putInMemory(IOUtils.toInputStream((String)newContent, (Charset)Constants.ENCODING), FSManager.instance((ODataServiceVersion)this.version).getAbsolutePath(path.toString(), acceptType));
            return this.xml.createResponse(null, null, null, acceptType, Response.Status.NO_CONTENT);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @POST
    @Path(value="/Product({entityId})/ChangeProductDimensions")
    public Response actionChangeProductDimensions(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entityId") String entityId, @QueryParam(value="$format") @DefaultValue(value="") String format, String argument) {
        Map.Entry utils = this.getUtilities(accept, format);
        if (utils.getKey() == Accept.XML || utils.getKey() == Accept.TEXT) {
            throw new UnsupportedMediaTypeException("Unsupported media type");
        }
        try {
            Map.Entry entityInfo = this.xml.readEntity("Product", entityId, Accept.ATOM);
            InputStream entity = (InputStream)entityInfo.getValue();
            ResWrap container = this.atomDeserializer.toEntity(entity);
            Entity param = this.xml.readEntity((Accept)utils.getKey(), IOUtils.toInputStream((String)argument, (Charset)Constants.ENCODING));
            org.apache.olingo.commons.api.data.Property property = param.getProperty("dimensions");
            ((Entity)container.getPayload()).getProperty("Dimensions").setValue(property.getValueType(), property.getValue());
            FSManager fsManager = FSManager.instance((ODataServiceVersion)this.version);
            fsManager.putInMemory(this.xml.writeEntity(Accept.ATOM, container), fsManager.getAbsolutePath(Commons.getEntityBasePath((String)"Product", (String)entityId) + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY), Accept.ATOM));
            return ((AbstractUtilities)utils.getValue()).createResponse(null, null, null, (Accept)utils.getKey(), Response.Status.NO_CONTENT);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @POST
    @Path(value="/ComputerDetail({entityId})/ResetComputerDetailsSpecifications")
    public Response actionResetComputerDetailsSpecifications(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entityId") String entityId, @QueryParam(value="$format") @DefaultValue(value="") String format, String argument) {
        Map.Entry utils = this.getUtilities(accept, format);
        if (utils.getKey() == Accept.XML || utils.getKey() == Accept.TEXT) {
            throw new UnsupportedMediaTypeException("Unsupported media type");
        }
        try {
            Map.Entry entityInfo = this.xml.readEntity("ComputerDetail", entityId, Accept.ATOM);
            InputStream entity = (InputStream)entityInfo.getValue();
            ResWrap container = this.atomDeserializer.toEntity(entity);
            Entity param = this.xml.readEntity((Accept)utils.getKey(), IOUtils.toInputStream((String)argument, (Charset)Constants.ENCODING));
            org.apache.olingo.commons.api.data.Property property = param.getProperty("specifications");
            ((Entity)container.getPayload()).getProperty("SpecificationsBag").setValue(property.getValueType(), property.getValue());
            property = param.getProperty("purchaseTime");
            ((Entity)container.getPayload()).getProperty("PurchaseDate").setValue(property.getValueType(), property.getValue());
            FSManager fsManager = FSManager.instance((ODataServiceVersion)this.version);
            fsManager.putInMemory(this.xml.writeEntity(Accept.ATOM, container), fsManager.getAbsolutePath(Commons.getEntityBasePath((String)"ComputerDetail", (String)entityId) + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY), Accept.ATOM));
            return ((AbstractUtilities)utils.getValue()).createResponse(null, null, null, (Accept)utils.getKey(), Response.Status.NO_CONTENT);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @GET
    @Path(value="/{name}/{type:[a-zA-Z].*}")
    public Response getEntitySet(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="name") String name, @PathParam(value="type") String type) {
        try {
            Accept acceptType = Accept.parse((String)accept, (ODataServiceVersion)this.version);
            if (acceptType == Accept.XML || acceptType == Accept.TEXT) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            String basePath = name + File.separatorChar;
            StringBuilder path = new StringBuilder(name).append(File.separatorChar).append(type).append(File.separatorChar);
            path.append(this.metadata.getEntitySet(name).isSingleton() ? Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY) : Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.FEED));
            InputStream feed = FSManager.instance((ODataServiceVersion)this.version).readFile(path.toString(), acceptType);
            return this.xml.createResponse(null, feed, Commons.getETag((String)basePath, (ODataServiceVersion)this.version), acceptType);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @GET
    @Path(value="/{name}")
    public Response getEntitySet(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="name") String name, @QueryParam(value="$top") @DefaultValue(value="") String top, @QueryParam(value="$skip") @DefaultValue(value="") String skip, @QueryParam(value="$format") @DefaultValue(value="") String format, @QueryParam(value="$inlinecount") @DefaultValue(value="") String count, @QueryParam(value="$filter") @DefaultValue(value="") String filter, @QueryParam(value="$orderby") @DefaultValue(value="") String orderby, @QueryParam(value="$skiptoken") @DefaultValue(value="") String skiptoken) {
        try {
            Accept acceptType = StringUtils.isNotBlank((CharSequence)format) ? Accept.valueOf((String)format.toUpperCase()) : Accept.parse((String)accept, (ODataServiceVersion)this.version);
            String location = uriInfo.getRequestUri().toASCIIString();
            try {
                InputStream func = FSManager.instance((ODataServiceVersion)this.version).readFile(name, acceptType);
                return this.xml.createResponse(location, func, null, acceptType);
            }
            catch (NotFoundException e) {
                if (acceptType == Accept.XML || acceptType == Accept.TEXT) {
                    throw new UnsupportedMediaTypeException("Unsupported media type");
                }
                String basePath = name + File.separatorChar;
                StringBuilder builder = new StringBuilder();
                builder.append(basePath);
                if (StringUtils.isNotBlank((CharSequence)orderby)) {
                    builder.append(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ORDERBY)).append(File.separatorChar).append(orderby).append(File.separatorChar);
                }
                if (StringUtils.isNotBlank((CharSequence)filter)) {
                    builder.append(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.FILTER)).append(File.separatorChar).append(filter.replaceAll("/", "."));
                } else if (StringUtils.isNotBlank((CharSequence)skiptoken)) {
                    builder.append(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.SKIP_TOKEN)).append(File.separatorChar).append(skiptoken);
                } else {
                    builder.append(this.metadata.getEntitySet(name).isSingleton() ? Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY) : Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.FEED));
                }
                InputStream feed = FSManager.instance((ODataServiceVersion)this.version).readFile(builder.toString(), Accept.ATOM);
                ResWrap container = this.atomDeserializer.toEntitySet(feed);
                this.setInlineCount((org.apache.olingo.commons.api.data.EntitySet)container.getPayload(), count);
                ByteArrayOutputStream content = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)content, Constants.ENCODING);
                List entries = new ArrayList(((org.apache.olingo.commons.api.data.EntitySet)container.getPayload()).getEntities());
                if (StringUtils.isNotBlank((CharSequence)skip)) {
                    entries = entries.subList(Integer.valueOf(skip), entries.size());
                }
                if (StringUtils.isNotBlank((CharSequence)top)) {
                    entries = entries.subList(0, Integer.valueOf(top));
                }
                ((org.apache.olingo.commons.api.data.EntitySet)container.getPayload()).getEntities().clear();
                ((org.apache.olingo.commons.api.data.EntitySet)container.getPayload()).getEntities().addAll(entries);
                if (acceptType == Accept.ATOM) {
                    this.atomSerializer.write((Writer)writer, container);
                } else {
                    this.jsonSerializer.write((Writer)writer, container);
                }
                writer.flush();
                writer.close();
                return this.xml.createResponse(location, (InputStream)new ByteArrayInputStream(content.toByteArray()), Commons.getETag((String)basePath, (ODataServiceVersion)this.version), acceptType);
            }
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    protected abstract void setInlineCount(org.apache.olingo.commons.api.data.EntitySet var1, String var2);

    @GET
    @Path(value="/Person({entityId})")
    public Response getPerson(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entityId") String entityId, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        Map.Entry utils = this.getUtilities(accept, format);
        Response internal = this.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, "Person", entityId, format, null, null);
        if (internal.getStatus() == 200) {
            InputStream entity = (InputStream)internal.getEntity();
            try {
                if (utils.getKey() == Accept.JSON_FULLMETA || utils.getKey() == Accept.ATOM) {
                    entity = ((AbstractUtilities)utils.getValue()).addOperation(entity, "Sack", "#DefaultContainer.Sack", uriInfo.getAbsolutePath().toASCIIString() + "/Microsoft.Test.OData.Services.AstoriaDefaultService.SpecialEmployee/Sack");
                }
                return ((AbstractUtilities)utils.getValue()).createResponse(uriInfo.getRequestUri().toASCIIString(), entity, internal.getHeaderString("ETag"), (Accept)utils.getKey());
            }
            catch (Exception e) {
                LOG.error("Error retrieving entity", (Throwable)e);
                return this.xml.createFaultResponse(accept, e);
            }
        }
        return internal;
    }

    @GET
    @Path(value="/Product({entityId})")
    public Response getProduct(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entityId") String entityId, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        Map.Entry utils = this.getUtilities(accept, format);
        Response internal = this.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, "Product", entityId, format, null, null);
        if (internal.getStatus() == 200) {
            InputStream entity = (InputStream)internal.getEntity();
            try {
                if (utils.getKey() == Accept.JSON_FULLMETA || utils.getKey() == Accept.ATOM) {
                    entity = ((AbstractUtilities)utils.getValue()).addOperation(entity, "ChangeProductDimensions", "#DefaultContainer.ChangeProductDimensions", uriInfo.getAbsolutePath().toASCIIString() + "/ChangeProductDimensions");
                }
                return ((AbstractUtilities)utils.getValue()).createResponse(uriInfo.getRequestUri().toASCIIString(), entity, internal.getHeaderString("ETag"), (Accept)utils.getKey());
            }
            catch (Exception e) {
                LOG.error("Error retrieving entity", (Throwable)e);
                return this.xml.createFaultResponse(accept, e);
            }
        }
        return internal;
    }

    @GET
    @Path(value="/ComputerDetail({entityId})")
    public Response getComputerDetail(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entityId") String entityId, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        Map.Entry utils = this.getUtilities(accept, format);
        Response internal = this.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, "ComputerDetail", entityId, format, null, null);
        if (internal.getStatus() == 200) {
            InputStream entity = (InputStream)internal.getEntity();
            try {
                if (utils.getKey() == Accept.JSON_FULLMETA || utils.getKey() == Accept.ATOM) {
                    entity = ((AbstractUtilities)utils.getValue()).addOperation(entity, "ResetComputerDetailsSpecifications", "#DefaultContainer.ResetComputerDetailsSpecifications", uriInfo.getAbsolutePath().toASCIIString() + "/ResetComputerDetailsSpecifications");
                }
                return ((AbstractUtilities)utils.getValue()).createResponse(uriInfo.getRequestUri().toASCIIString(), entity, internal.getHeaderString("ETag"), (Accept)utils.getKey());
            }
            catch (Exception e) {
                LOG.error("Error retrieving entity", (Throwable)e);
                return this.xml.createFaultResponse(accept, e);
            }
        }
        return internal;
    }

    @GET
    @Path(value="/{entitySetName}({entityId})")
    public Response getEntity(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @QueryParam(value="$format") @DefaultValue(value="") String format, @QueryParam(value="$expand") @DefaultValue(value="") String expand, @QueryParam(value="$select") @DefaultValue(value="") String select) {
        return this.getEntityInternal(uriInfo.getRequestUri().toASCIIString(), accept, entitySetName, entityId, format, expand, select);
    }

    protected Response getEntityInternal(String location, String accept, String entitySetName, String entityId, String format, String expand, String select) {
        try {
            Map.Entry utils = this.getUtilities(accept, format);
            if (utils.getKey() == Accept.XML || utils.getKey() == Accept.TEXT) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            Map.Entry entityInfo = ((AbstractUtilities)utils.getValue()).readEntity(entitySetName, entityId, Accept.ATOM);
            InputStream entity = (InputStream)entityInfo.getValue();
            ResWrap container = this.atomDeserializer.toEntity(entity);
            if (container.getContextURL() == null) {
                container = new ResWrap(URI.create(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_METADATA_PREFIX) + entitySetName + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_METADATA_ENTITY_SUFFIX)), container.getMetadataETag(), container.getPayload());
            }
            Entity entry = (Entity)container.getPayload();
            if (this instanceof V3KeyAsSegment || this instanceof V4KeyAsSegment) {
                LinkImpl editLink = new LinkImpl();
                editLink.setRel("edit");
                editLink.setTitle(entitySetName);
                editLink.setHref(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.DEFAULT_SERVICE_URL) + entitySetName + "/" + entityId);
                entry.setEditLink((Link)editLink);
            }
            if (StringUtils.isNotBlank((CharSequence)select)) {
                List<String> properties = Arrays.asList(select.split(","));
                HashSet<org.apache.olingo.commons.api.data.Property> toBeRemoved = new HashSet<org.apache.olingo.commons.api.data.Property>();
                for (org.apache.olingo.commons.api.data.Property property : entry.getProperties()) {
                    if (properties.contains(property.getName())) continue;
                    toBeRemoved.add(property);
                }
                entry.getProperties().removeAll(toBeRemoved);
                HashSet<Link> linkToBeRemoved = new HashSet<Link>();
                for (Link link : entry.getNavigationLinks()) {
                    if (properties.contains(link.getTitle().replaceAll("@.*$", "")) || properties.contains(link.getTitle())) continue;
                    linkToBeRemoved.add(link);
                }
                entry.getNavigationLinks().removeAll(linkToBeRemoved);
            }
            if (StringUtils.isNotBlank((CharSequence)expand)) {
                expand = StringUtils.substringBefore((String)expand, (String)"(");
                List<String> links = Arrays.asList(expand.split(","));
                HashMap<Link, LinkImpl> replace = new HashMap<Link, LinkImpl>();
                for (Link link : entry.getNavigationLinks()) {
                    Entity inline;
                    if (!links.contains(link.getTitle())) continue;
                    LinkImpl rep = new LinkImpl();
                    rep.setHref(link.getHref());
                    rep.setRel(link.getRel());
                    rep.setTitle(link.getTitle());
                    rep.setType(link.getType());
                    if (link.getType().equals(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ATOM_LINK_ENTRY))) {
                        inline = (Entity)this.atomDeserializer.toEntity(this.xml.expandEntity(entitySetName, entityId, link.getTitle())).getPayload();
                        rep.setInlineEntity(inline);
                    } else if (link.getType().equals(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ATOM_LINK_FEED))) {
                        inline = (org.apache.olingo.commons.api.data.EntitySet)this.atomDeserializer.toEntitySet(this.xml.expandEntity(entitySetName, entityId, link.getTitle())).getPayload();
                        rep.setInlineEntitySet((org.apache.olingo.commons.api.data.EntitySet)inline);
                    }
                    replace.put(link, rep);
                }
                for (Map.Entry entry2 : replace.entrySet()) {
                    entry.getNavigationLinks().remove(entry2.getKey());
                    entry.getNavigationLinks().add(entry2.getValue());
                }
            }
            return this.xml.createResponse(location, this.xml.writeEntity((Accept)utils.getKey(), container), Commons.getETag((String)((String)entityInfo.getKey()), (ODataServiceVersion)this.version), (Accept)utils.getKey());
        }
        catch (Exception e) {
            LOG.error("Error retrieving entity", (Throwable)e);
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @GET
    @Path(value="/{entitySetName}({entityId})/$value")
    public Response getMediaEntity(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId) {
        try {
            if (!accept.contains("*/*") && !accept.contains(APPLICATION_OCTET_STREAM)) {
                throw new UnsupportedMediaTypeException("Unsupported media type");
            }
            AbstractUtilities utils = this.getUtilities(null);
            Map.Entry entityInfo = utils.readMediaEntity(entitySetName, entityId);
            return utils.createResponse(uriInfo.getRequestUri().toASCIIString(), (InputStream)entityInfo.getValue(), Commons.getETag((String)((String)entityInfo.getKey()), (ODataServiceVersion)this.version), null);
        }
        catch (Exception e) {
            LOG.error("Error retrieving entity", (Throwable)e);
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @DELETE
    @Path(value="/{entitySetName}({entityId})")
    public Response removeEntity(@PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId) {
        try {
            String basePath = entitySetName + File.separatorChar + Commons.getEntityKey((String)entityId);
            FSManager.instance((ODataServiceVersion)this.version).deleteEntity(basePath);
            return this.xml.createResponse(null, null, null, null, Response.Status.NO_CONTENT);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(Accept.XML.toString(this.version), e);
        }
    }

    private Response replaceProperty(String location, String accept, String contentType, String prefer, String entitySetName, String entityId, String path, String format, String changes, boolean justValue) {
        LOG.info("Retrieve property {}", (Object)path);
        try {
            Response response;
            FSManager fsManager = FSManager.instance((ODataServiceVersion)this.version);
            String basePath = Commons.getEntityBasePath((String)entitySetName, (String)entityId);
            ResWrap container = this.xml.readContainerEntity(Accept.ATOM, fsManager.readFile(basePath + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY), Accept.ATOM));
            Entity entry = (Entity)container.getPayload();
            org.apache.olingo.commons.api.data.Property toBeReplaced = null;
            for (String element : path.split("/")) {
                if (toBeReplaced == null) {
                    toBeReplaced = entry.getProperty(element.trim());
                    continue;
                }
                List value = toBeReplaced.asComplex();
                for (org.apache.olingo.commons.api.data.Property field : value) {
                    if (!field.getName().equalsIgnoreCase(element)) continue;
                    toBeReplaced = field;
                }
            }
            if (toBeReplaced == null) {
                throw new NotFoundException();
            }
            if (justValue) {
                toBeReplaced.setValue(ValueType.PRIMITIVE, (Object)changes);
            } else {
                org.apache.olingo.commons.api.data.Property pchanges = this.xml.readProperty(Accept.parse((String)contentType, (ODataServiceVersion)this.version), IOUtils.toInputStream((String)changes, (Charset)Constants.ENCODING));
                toBeReplaced.setValue(pchanges.getValueType(), pchanges.getValue());
            }
            fsManager.putInMemory(this.xml.writeEntity(Accept.ATOM, container), fsManager.getAbsolutePath(basePath + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ENTITY), Accept.ATOM));
            if ("return-content".equalsIgnoreCase(prefer)) {
                response = this.getEntityInternal(location, accept, entitySetName, entityId, format, null, null);
            } else {
                Accept acceptType = null;
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    acceptType = Accept.valueOf((String)format.toUpperCase());
                } else if (StringUtils.isNotBlank((CharSequence)accept)) {
                    acceptType = Accept.parse((String)accept, (ODataServiceVersion)this.version, null);
                }
                response = this.xml.createResponse(null, null, null, acceptType, Response.Status.NO_CONTENT);
            }
            if (StringUtils.isNotBlank((CharSequence)prefer)) {
                response.getHeaders().put((Object)"Preference-Applied", Collections.singletonList(prefer));
            }
            return response;
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    private Response deletePropertyValue(String accept, String prefer, String entitySetName, String entityId, String path, String format) {
        try {
            Response response;
            Accept acceptType = null;
            if (StringUtils.isNotBlank((CharSequence)format)) {
                acceptType = Accept.valueOf((String)format.toUpperCase());
            } else if (StringUtils.isNotBlank((CharSequence)accept)) {
                acceptType = Accept.parse((String)accept, (ODataServiceVersion)this.version, null);
            }
            LOG.info("Retrieve property {}", (Object)path);
            AbstractUtilities utils = this.getUtilities(acceptType);
            InputStream changed = utils.deleteProperty(entitySetName, entityId, Arrays.asList(path.split("/")), acceptType);
            if ("return-content".equalsIgnoreCase(prefer)) {
                response = this.xml.createResponse(null, changed, null, acceptType, Response.Status.OK);
            } else {
                changed.close();
                response = this.xml.createResponse(null, null, null, acceptType, Response.Status.NO_CONTENT);
            }
            if (StringUtils.isNotBlank((CharSequence)prefer)) {
                response.getHeaders().put((Object)"Preference-Applied", Collections.singletonList(prefer));
            }
            return response;
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @PUT
    @Path(value="/{entitySetName}({entityId})/{path:.*}/$value")
    public Response replacePropertyValue(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @PathParam(value="path") String path, @QueryParam(value="$format") @DefaultValue(value="") String format, String changes) {
        return this.replaceProperty(uriInfo.getRequestUri().toASCIIString(), accept, contentType, prefer, entitySetName, entityId, path, format, changes, true);
    }

    @MERGE
    @Path(value="/{entitySetName}({entityId})/{path:.*}")
    public Response mergeProperty(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @PathParam(value="path") String path, @QueryParam(value="$format") @DefaultValue(value="") String format, String changes) {
        return this.replaceProperty(uriInfo.getRequestUri().toASCIIString(), accept, contentType, prefer, entitySetName, entityId, path, format, changes, false);
    }

    @PATCH
    @Path(value="/{entitySetName}({entityId})/{path:.*}")
    public Response patchProperty(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @PathParam(value="path") String path, @QueryParam(value="$format") @DefaultValue(value="") String format, String changes) {
        return this.replaceProperty(uriInfo.getRequestUri().toASCIIString(), accept, contentType, prefer, entitySetName, entityId, path, format, changes, false);
    }

    @PUT
    @Produces(value={"application/atom+xml", "application/json"})
    @Consumes(value={"*/*", "application/octet-stream"})
    @Path(value="/{entitySetName}({entityId})/$value")
    public Response replaceMediaEntity(@Context UriInfo uriInfo, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @QueryParam(value="$format") @DefaultValue(value="") String format, String value) {
        try {
            Response response;
            AbstractUtilities utils = this.getUtilities(null);
            InputStream res = utils.putMediaInMemory(entitySetName, entityId, IOUtils.toInputStream((String)value, (Charset)Constants.ENCODING));
            String location = uriInfo.getRequestUri().toASCIIString().replace("/$value", "");
            if ("return-content".equalsIgnoreCase(prefer)) {
                response = this.xml.createResponse(location, res, null, null, Response.Status.OK);
            } else {
                res.close();
                response = this.xml.createResponse(location, null, null, null, Response.Status.NO_CONTENT);
            }
            if (StringUtils.isNotBlank((CharSequence)prefer)) {
                response.getHeaders().put((Object)"Preference-Applied", Collections.singletonList(prefer));
            }
            return response;
        }
        catch (Exception e) {
            LOG.error("Error retrieving entity", (Throwable)e);
            return this.xml.createFaultResponse(Accept.JSON.toString(this.version), e);
        }
    }

    @PUT
    @Path(value="/{entitySetName}({entityId})/{path:.*}")
    public Response replaceProperty(@Context UriInfo uriInfo, @HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Content-Type") @DefaultValue(value="") String contentType, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @PathParam(value="path") String path, @QueryParam(value="$format") @DefaultValue(value="") String format, String changes) {
        if (this.xml.isMediaContent(entitySetName + "/" + path)) {
            return this.replaceMediaProperty(prefer, entitySetName, entityId, path, changes);
        }
        return this.replaceProperty(uriInfo.getRequestUri().toASCIIString(), accept, contentType, prefer, entitySetName, entityId, path, format, changes, false);
    }

    private Response replaceMediaProperty(String prefer, String entitySetName, String entityId, String path, String value) {
        try {
            Response response;
            AbstractUtilities utils = this.getUtilities(null);
            InputStream res = utils.putMediaInMemory(entitySetName, entityId, path, IOUtils.toInputStream((String)value, (Charset)Constants.ENCODING));
            if ("return-content".equalsIgnoreCase(prefer)) {
                response = this.xml.createResponse(null, res, null, null, Response.Status.OK);
            } else {
                res.close();
                response = this.xml.createResponse(null, null, null, null, Response.Status.NO_CONTENT);
            }
            if (StringUtils.isNotBlank((CharSequence)prefer)) {
                response.getHeaders().put((Object)"Preference-Applied", Collections.singletonList(prefer));
            }
            return response;
        }
        catch (Exception e) {
            LOG.error("Error retrieving entity", (Throwable)e);
            return this.xml.createFaultResponse(Accept.JSON.toString(this.version), e);
        }
    }

    @DELETE
    @Path(value="/{entitySetName}({entityId})/{path:.*}/$value")
    public Response deleteProperty(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @HeaderParam(value="Prefer") @DefaultValue(value="") String prefer, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @PathParam(value="path") String path, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        return this.deletePropertyValue(accept, prefer, entitySetName, entityId, path, format);
    }

    @GET
    @Path(value="/{entitySetName}({entityId})/{path:.*}/$value")
    public Response getPathValue(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @PathParam(value="path") String path, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        try {
            Accept acceptType = null;
            if (StringUtils.isNotBlank((CharSequence)format)) {
                acceptType = Accept.valueOf((String)format.toUpperCase());
            } else if (StringUtils.isNotBlank((CharSequence)accept)) {
                acceptType = Accept.parse((String)accept, (ODataServiceVersion)this.version, null);
            }
            return this.navigateProperty(acceptType, entitySetName, entityId, path, true);
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    @GET
    @Path(value="/{entitySetName}({entityId})/{path:.*}")
    public Response getPath(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="entityId") String entityId, @PathParam(value="path") String path, @QueryParam(value="$format") @DefaultValue(value="") String format) {
        XMLUtilities utils = this.xml;
        try {
            if (utils.isMediaContent(entitySetName + "/" + path)) {
                return this.navigateStreamedEntity(entitySetName, entityId, path);
            }
            Accept acceptType = null;
            if (StringUtils.isNotBlank((CharSequence)format)) {
                acceptType = Accept.valueOf((String)format.toUpperCase());
            } else if (StringUtils.isNotBlank((CharSequence)accept)) {
                acceptType = Accept.parse((String)accept, (ODataServiceVersion)this.version, null);
            }
            try {
                ResWrap container;
                LinkInfo linkInfo = this.xml.readLinks(entitySetName, entityId, path, Accept.XML);
                Map.Entry links = this.xml.extractLinkURIs(linkInfo.getLinks());
                InputStream stream = this.xml.readEntities((List)links.getValue(), path, (String)links.getKey(), linkInfo.isFeed());
                ByteArrayOutputStream content = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)content, Constants.ENCODING);
                ResWrap resWrap = container = linkInfo.isFeed() ? this.atomDeserializer.toEntitySet(stream) : this.atomDeserializer.toEntity(stream);
                if (acceptType == Accept.ATOM) {
                    this.atomSerializer.write((Writer)writer, container);
                } else {
                    this.jsonSerializer.write((Writer)writer, container);
                }
                writer.flush();
                writer.close();
                String basePath = Commons.getEntityBasePath((String)entitySetName, (String)entityId);
                return this.xml.createResponse(null, (InputStream)new ByteArrayInputStream(content.toByteArray()), Commons.getETag((String)basePath, (ODataServiceVersion)this.version), acceptType);
            }
            catch (NotFoundException e) {
                return this.navigateProperty(acceptType, entitySetName, entityId, path, false);
            }
        }
        catch (Exception e) {
            return utils.createFaultResponse(accept, e);
        }
    }

    private Response navigateStreamedEntity(String entitySetName, String entityId, String path) throws Exception {
        AbstractUtilities utils = this.getUtilities(null);
        Map.Entry entityInfo = utils.readMediaEntity(entitySetName, entityId, path);
        return utils.createResponse(null, (InputStream)entityInfo.getValue(), Commons.getETag((String)((String)entityInfo.getKey()), (ODataServiceVersion)this.version), null);
    }

    private Response navigateProperty(Accept acceptType, String entitySetName, String entityId, String path, boolean searchForValue) throws Exception {
        if (searchForValue && acceptType != null && acceptType != Accept.TEXT || acceptType == Accept.ATOM) {
            throw new UnsupportedMediaTypeException("Unsupported media type " + acceptType);
        }
        AbstractUtilities utils = this.getUtilities(acceptType);
        Map.Entry entityInfo = utils.readEntity(entitySetName, entityId, Accept.ATOM);
        InputStream entity = (InputStream)entityInfo.getValue();
        ResWrap entryContainer = this.atomDeserializer.toEntity(entity);
        String[] pathElems = StringUtils.split((String)path, (String)"/");
        org.apache.olingo.commons.api.data.Property property = ((Entity)entryContainer.getPayload()).getProperty(pathElems[0]);
        if (pathElems.length > 1 && property.isComplex()) {
            for (org.apache.olingo.commons.api.data.Property sub : property.asComplex()) {
                if (!pathElems[1].equals(sub.getName())) continue;
                property = sub;
                if (pathElems.length <= 2 || !property.isComplex()) continue;
                for (org.apache.olingo.commons.api.data.Property subsub : property.asComplex()) {
                    if (!pathElems[2].equals(subsub.getName())) continue;
                    property = subsub;
                }
            }
        }
        ResWrap container = new ResWrap(URI.create(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_METADATA_PREFIX) + (this.version.compareTo((Enum)ODataServiceVersion.V40) >= 0 ? entitySetName + "(" + entityId + ")/" + path : property.getType())), entryContainer.getMetadataETag(), (Object)property);
        return this.xml.createResponse(null, searchForValue ? IOUtils.toInputStream((String)(((org.apache.olingo.commons.api.data.Property)container.getPayload()).isNull() ? "" : this.stringValue((org.apache.olingo.commons.api.data.Property)container.getPayload())), (Charset)Constants.ENCODING) : utils.writeProperty(acceptType, container), Commons.getETag((String)Commons.getEntityBasePath((String)entitySetName, (String)entityId), (ODataServiceVersion)this.version), acceptType);
    }

    private String stringValue(org.apache.olingo.commons.api.data.Property property) {
        EdmPrimitiveTypeKind kind = EdmPrimitiveTypeKind.valueOfFQN((ODataServiceVersion)this.version, (String)property.getType());
        try {
            return EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)kind).valueToString(property.asPrimitive(), null, null, org.apache.olingo.commons.api.Constants.DEFAULT_PRECISION, org.apache.olingo.commons.api.Constants.DEFAULT_SCALE, null);
        }
        catch (EdmPrimitiveTypeException e) {
            return property.asPrimitive().toString();
        }
    }

    @GET
    @Path(value="/{entitySetName}/$count")
    public Response count(@HeaderParam(value="Accept") @DefaultValue(value="") String accept, @PathParam(value="entitySetName") String entitySetName) {
        try {
            Accept acceptType = Accept.parse((String)accept, (ODataServiceVersion)this.version, (Accept)Accept.TEXT);
            if (acceptType != Accept.TEXT) {
                throw new UnsupportedMediaTypeException("Unsupported type " + accept);
            }
            int count = this.xml.countAllElements(entitySetName);
            Response.ResponseBuilder builder = Response.ok();
            builder.entity((Object)count);
            return builder.build();
        }
        catch (Exception e) {
            return this.xml.createFaultResponse(accept, e);
        }
    }

    public Map.Entry<Accept, AbstractUtilities> getUtilities(String accept, String format) {
        Accept acceptType;
        if (StringUtils.isNotBlank((CharSequence)format)) {
            try {
                acceptType = Accept.valueOf((String)format.toUpperCase());
            }
            catch (Exception e) {
                acceptType = Accept.parse((String)format, (ODataServiceVersion)this.version);
            }
        } else {
            acceptType = Accept.parse((String)accept, (ODataServiceVersion)this.version);
        }
        return new AbstractMap.SimpleEntry<Accept, AbstractUtilities>(acceptType, this.getUtilities(acceptType));
    }

    protected AbstractUtilities getUtilities(Accept accept) {
        Object utils = accept == Accept.XML || accept == Accept.TEXT || accept == Accept.ATOM ? this.xml : this.json;
        return utils;
    }

    protected void updateInlineEntities(Entity entity) {
        String type = entity.getType();
        Map navProperties = Collections.emptyMap();
        if (type != null && type.length() > 0) {
            EntityType entityType = this.metadata.getEntityOrComplexType(type);
            navProperties = entityType.getNavigationPropertyMap();
        }
        for (org.apache.olingo.commons.api.data.Property property : entity.getProperties()) {
            EntityImpl inline;
            if (!navProperties.containsKey(property.getName())) continue;
            LinkImpl alink = new LinkImpl();
            alink.setTitle(property.getName());
            alink.getAnnotations().addAll(property.getAnnotations());
            alink.setType(((NavigationProperty)navProperties.get(property.getName())).isEntitySet() ? Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ATOM_LINK_FEED) : Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ATOM_LINK_ENTRY));
            alink.setRel(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ATOM_LINK_REL) + property.getName());
            if (property.isComplex()) {
                inline = new EntityImpl();
                inline.setType(((NavigationProperty)navProperties.get(property.getName())).getType());
                for (org.apache.olingo.commons.api.data.Property prop : property.asComplex()) {
                    inline.getProperties().add(prop);
                }
                alink.setInlineEntity((Entity)inline);
            } else if (property.isCollection()) {
                inline = new EntitySetImpl();
                for (Object value : property.asCollection()) {
                    EntityImpl inlineEntity = new EntityImpl();
                    inlineEntity.setType(((NavigationProperty)navProperties.get(property.getName())).getType());
                    for (org.apache.olingo.commons.api.data.Property prop : value instanceof LinkedComplexValue ? ((LinkedComplexValue)value).getValue() : ((Valuable)value).asComplex()) {
                        inlineEntity.getProperties().add(prop);
                    }
                    inline.getEntities().add(inlineEntity);
                }
                alink.setInlineEntitySet((org.apache.olingo.commons.api.data.EntitySet)inline);
            } else {
                throw new IllegalStateException("Invalid navigation property " + property);
            }
            entity.getNavigationLinks().add(alink);
        }
    }

    protected void normalizeAtomEntry(Entity entry, String entitySetName, String entityKey) {
        EntitySet entitySet = this.metadata.getEntitySet(entitySetName);
        EntityType entityType = this.metadata.getEntityOrComplexType(entitySet.getType());
        for (Map.Entry property : entityType.getPropertyMap().entrySet()) {
            if (entry.getProperty((String)property.getKey()) != null || !((Property)property.getValue()).isNullable()) continue;
            PropertyImpl prop = new PropertyImpl();
            prop.setName((String)property.getKey());
            prop.setValue(ValueType.PRIMITIVE, null);
            entry.getProperties().add(prop);
        }
        for (Map.Entry property : entityType.getNavigationPropertyMap().entrySet()) {
            boolean found = false;
            for (Link link : entry.getNavigationLinks()) {
                if (!link.getTitle().equals(property.getKey())) continue;
                found = true;
            }
            if (found) continue;
            LinkImpl link = new LinkImpl();
            link.setTitle((String)property.getKey());
            link.setType(((NavigationProperty)property.getValue()).isEntitySet() ? Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ATOM_LINK_FEED) : Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ATOM_LINK_ENTRY));
            link.setRel(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ATOM_LINK_REL) + (String)property.getKey());
            link.setHref(entitySetName + "(" + entityKey + ")/" + (String)property.getKey());
            entry.getNavigationLinks().add(link);
        }
    }
}

