/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.CommonEdmEnabledODataClient;
import org.apache.olingo.client.api.uri.CommonURIBuilder;
import org.apache.olingo.client.api.v3.UnsupportedInV3Exception;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.domain.ODataCollectionValue;
import org.apache.olingo.commons.api.domain.ODataComplexValue;
import org.apache.olingo.commons.api.domain.ODataLink;
import org.apache.olingo.commons.api.domain.ODataPrimitiveValue;
import org.apache.olingo.commons.api.domain.ODataValue;
import org.apache.olingo.commons.api.domain.v4.ODataAnnotatable;
import org.apache.olingo.commons.api.domain.v4.ODataAnnotation;
import org.apache.olingo.commons.api.domain.v4.ODataEnumValue;
import org.apache.olingo.commons.api.domain.v4.ODataObjectFactory;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.domain.v4.ODataAnnotationImpl;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.AbstractTerm;
import org.apache.olingo.ext.proxy.api.annotations.ComplexType;
import org.apache.olingo.ext.proxy.api.annotations.CompoundKey;
import org.apache.olingo.ext.proxy.api.annotations.CompoundKeyElement;
import org.apache.olingo.ext.proxy.api.annotations.EnumType;
import org.apache.olingo.ext.proxy.api.annotations.Key;
import org.apache.olingo.ext.proxy.api.annotations.Namespace;
import org.apache.olingo.ext.proxy.api.annotations.NavigationProperty;
import org.apache.olingo.ext.proxy.api.annotations.Property;
import org.apache.olingo.ext.proxy.api.annotations.Term;
import org.apache.olingo.ext.proxy.commons.AbstractStructuredInvocationHandler;
import org.apache.olingo.ext.proxy.commons.ComplexInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.utils.ClassUtils;
import org.apache.olingo.ext.proxy.utils.CompoundKeyElementWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CoreUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CoreUtils.class);

    private CoreUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ODataValue getODataValue(CommonEdmEnabledODataClient<?> client, EdmTypeInfo type, Object obj) {
        ODataCollectionValue value;
        if (type.isCollection()) {
            value = client.getObjectFactory().newCollectionValue(type.getFullQualifiedName().toString());
            EdmTypeInfo intType = new EdmTypeInfo.Builder().setEdm(client.getCachedEdm()).setTypeExpression(type.getFullQualifiedName().toString()).build();
            Iterator i$ = ((Collection)obj).iterator();
            while (i$.hasNext()) {
                Object collectionItem = i$.next();
                if (intType.isPrimitiveType()) {
                    value.asCollection().add((ODataValue)CoreUtils.getODataValue(client, (EdmTypeInfo)intType, collectionItem).asPrimitive());
                    continue;
                }
                if (intType.isEnumType()) {
                    if (client.getServiceVersion().compareTo((Enum)ODataServiceVersion.V30) <= 0) {
                        throw new UnsupportedInV3Exception();
                    }
                    value.asCollection().add((ODataValue)((org.apache.olingo.commons.api.domain.v4.ODataValue)CoreUtils.getODataValue(client, (EdmTypeInfo)intType, collectionItem)).asEnum());
                    continue;
                }
                if (!intType.isComplexType()) throw new UnsupportedOperationException("Unsupported object type " + intType.getFullQualifiedName());
                value.asCollection().add((ODataValue)CoreUtils.getODataValue(client, (EdmTypeInfo)intType, collectionItem).asComplex());
            }
            return value;
        }
        if (type.isComplexType()) {
            InvocationHandler objHandler = Proxy.getInvocationHandler(obj);
            if (!(objHandler instanceof ComplexInvocationHandler)) throw new IllegalArgumentException(objHandler.getClass().getName() + "' is not a complex value");
            value = ((ComplexInvocationHandler)objHandler).getComplex();
            Class typeRef = ((ComplexInvocationHandler)objHandler).getTypeRef();
            Iterator i$ = ((ComplexInvocationHandler)objHandler).getPropertyChanges().entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry changes = i$.next();
                try {
                    value.asComplex().add(CoreUtils.getODataComplexProperty(client, (FullQualifiedName)type.getFullQualifiedName(), (String)((String)changes.getKey()), changes.getValue()));
                }
                catch (Exception ignore) {
                    LOG.warn("Error attaching complex {} for field '{}.{}'", new Object[]{type.getFullQualifiedName(), typeRef.getName(), changes.getKey(), ignore});
                }
            }
            return value;
        }
        if (!type.isEnumType()) return client.getObjectFactory().newPrimitiveValueBuilder().setType(type.getPrimitiveTypeKind()).setValue(obj).build();
        if (client.getServiceVersion().compareTo((Enum)ODataServiceVersion.V30) > 0) return ((ODataObjectFactory)client.getObjectFactory()).newEnumValue(type.getFullQualifiedName().toString(), ((Enum)obj).name());
        throw new UnsupportedInV3Exception();
    }

    private static CommonODataProperty getODataEntityProperty(CommonEdmEnabledODataClient<?> client, FullQualifiedName entity, String property, Object obj) {
        EdmElement edmProperty = client.getCachedEdm().getEntityType(entity).getProperty(property);
        return CoreUtils.getODataProperty(client, (EdmElement)edmProperty, (String)property, (Object)obj);
    }

    private static CommonODataProperty getODataComplexProperty(CommonEdmEnabledODataClient<?> client, FullQualifiedName complex, String property, Object obj) {
        EdmElement edmProperty = client.getCachedEdm().getComplexType(complex).getProperty(property);
        return CoreUtils.getODataProperty(client, (EdmElement)edmProperty, (String)property, (Object)obj);
    }

    private static CommonODataProperty getODataProperty(CommonEdmEnabledODataClient<?> client, EdmElement edmProperty, String property, Object obj) {
        EdmTypeInfo type;
        if (edmProperty == null) {
            type = null;
        } else {
            EdmType edmType = edmProperty.getType();
            type = new EdmTypeInfo.Builder().setEdm(client.getCachedEdm()).setTypeExpression(edmProperty.isCollection() ? "Collection(" + edmType.getFullQualifiedName().toString() + ")" : edmType.getFullQualifiedName().toString()).build();
        }
        return CoreUtils.getODataProperty(client, (String)property, type, (Object)obj);
    }

    public static ODataAnnotation getODataAnnotation(CommonEdmEnabledODataClient<?> client, String term, EdmType type, Object obj) {
        ODataAnnotationImpl annotation;
        if (obj == null) {
            annotation = new ODataAnnotationImpl(term, null);
        } else {
            EdmTypeInfo valueType = type == null ? CoreUtils.guessTypeFromObject(client, (Object)obj) : new EdmTypeInfo.Builder().setEdm(client.getCachedEdm()).setTypeExpression(type.getFullQualifiedName().toString()).build();
            annotation = new ODataAnnotationImpl(term, (org.apache.olingo.commons.api.domain.v4.ODataValue)CoreUtils.getODataValue(client, (EdmTypeInfo)valueType, (Object)obj));
        }
        return annotation;
    }

    public static CommonODataProperty getODataProperty(CommonEdmEnabledODataClient<?> client, String name, EdmTypeInfo type, Object obj) {
        try {
            CommonODataProperty property;
            if (obj == null) {
                property = client.getObjectFactory().newPrimitiveProperty(name, null);
            } else {
                EdmTypeInfo valueType = type == null ? CoreUtils.guessTypeFromObject(client, (Object)obj) : type;
                ODataValue value = CoreUtils.getODataValue(client, (EdmTypeInfo)valueType, (Object)obj);
                if (valueType.isCollection()) {
                    property = client.getObjectFactory().newCollectionProperty(name, value.asCollection());
                } else if (valueType.isPrimitiveType()) {
                    property = client.getObjectFactory().newPrimitiveProperty(name, value.asPrimitive());
                } else if (valueType.isComplexType()) {
                    property = client.getObjectFactory().newComplexProperty(name, value.asComplex());
                } else if (valueType.isEnumType()) {
                    if (client.getServiceVersion().compareTo((Enum)ODataServiceVersion.V30) <= 0) {
                        throw new UnsupportedInV3Exception();
                    }
                    property = ((ODataObjectFactory)client.getObjectFactory()).newEnumProperty(name, ((org.apache.olingo.commons.api.domain.v4.ODataValue)value).asEnum());
                } else {
                    throw new UnsupportedOperationException("Usupported object type " + valueType.getFullQualifiedName());
                }
            }
            return property;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static EdmTypeInfo guessTypeFromObject(CommonEdmEnabledODataClient<?> client, Object obj) {
        EdmTypeInfo.Builder edmTypeInfo = new EdmTypeInfo.Builder().setEdm(client.getCachedEdm());
        if (Collection.class.isAssignableFrom(obj.getClass())) {
            EdmTypeInfo type = CoreUtils.guessPrimitiveType(client, (Class)ClassUtils.extractTypeArg(obj.getClass(), (Class[])new Class[0]));
            return edmTypeInfo.setTypeExpression("Collection(" + type.getFullQualifiedName() + ")").build();
        }
        if (obj instanceof Proxy) {
            Class<?> typeRef = obj.getClass().getInterfaces()[0];
            String ns = typeRef.getAnnotation(Namespace.class).value();
            String name = typeRef.getAnnotation(ComplexType.class).name();
            return edmTypeInfo.setTypeExpression(new FullQualifiedName(ns, name).toString()).build();
        }
        if (obj.getClass().getAnnotation(EnumType.class) != null) {
            Class<?> typeRef = obj.getClass();
            String ns = typeRef.getAnnotation(Namespace.class).value();
            String name = typeRef.getAnnotation(EnumType.class).name();
            return edmTypeInfo.setTypeExpression(new FullQualifiedName(ns, name).toString()).build();
        }
        return CoreUtils.guessPrimitiveType(client, obj.getClass());
    }

    private static EdmTypeInfo guessPrimitiveType(CommonEdmEnabledODataClient<?> client, Class<?> clazz) {
        EdmPrimitiveTypeKind bckCandidate = null;
        for (EdmPrimitiveTypeKind kind : EdmPrimitiveTypeKind.values()) {
            if (!kind.getSupportedVersions().contains(client.getServiceVersion())) continue;
            Class target = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)kind).getDefaultType();
            if (clazz.equals(target)) {
                return new EdmTypeInfo.Builder().setEdm(client.getCachedEdm()).setTypeExpression(kind.toString()).build();
            }
            if (target.isAssignableFrom(clazz)) {
                bckCandidate = kind;
                continue;
            }
            if (target != Timestamp.class || kind != EdmPrimitiveTypeKind.DateTime && kind != EdmPrimitiveTypeKind.DateTimeOffset) continue;
            bckCandidate = kind;
        }
        if (bckCandidate == null) {
            throw new IllegalArgumentException(clazz.getSimpleName() + " is not a simple type");
        }
        return new EdmTypeInfo.Builder().setEdm(client.getCachedEdm()).setTypeExpression(bckCandidate.toString()).build();
    }

    public static void addProperties(CommonEdmEnabledODataClient<?> client, Map<String, Object> changes, CommonODataEntity entity) {
        for (Map.Entry<String, Object> entry : changes.entrySet()) {
            entity.getProperties().add(CoreUtils.getODataEntityProperty(client, (FullQualifiedName)entity.getTypeName(), (String)entry.getKey(), (Object)entry.getValue()));
        }
    }

    public static void addProperties(CommonEdmEnabledODataClient<?> client, Map<String, Object> changes, ODataComplexValue<CommonODataProperty> entity) {
        for (Map.Entry<String, Object> entry : changes.entrySet()) {
            entity.add(CoreUtils.getODataComplexProperty(client, (FullQualifiedName)new FullQualifiedName(entity.getTypeName()), (String)entry.getKey(), (Object)entry.getValue()));
        }
    }

    public static void addAnnotations(CommonEdmEnabledODataClient<?> client, Map<Class<? extends AbstractTerm>, Object> annotations, ODataAnnotatable annotatable) {
        for (Map.Entry<Class<? extends AbstractTerm>, Object> entry : annotations.entrySet()) {
            Namespace nsAnn = entry.getKey().getAnnotation(Namespace.class);
            Term termAnn = entry.getKey().getAnnotation(Term.class);
            FullQualifiedName termName = new FullQualifiedName(nsAnn.value(), termAnn.name());
            EdmTerm term = client.getCachedEdm().getTerm(termName);
            if (term == null) {
                LOG.error("Could not find term for class {}", (Object)entry.getKey().getName());
                continue;
            }
            annotatable.getAnnotations().add(CoreUtils.getODataAnnotation(client, (String)term.getFullQualifiedName().toString(), (EdmType)term.getType(), (Object)entry.getValue()));
        }
    }

    private static Enum<?> enumValueToObject(ODataEnumValue value, Class<?> reference) {
        Namespace namespace = reference.getAnnotation(Namespace.class);
        EnumType enumType = reference.getAnnotation(EnumType.class);
        if (value.getTypeName().equals(namespace.value() + "." + enumType.name())) {
            return Enum.valueOf(reference, value.getValue());
        }
        return null;
    }

    private static Object primitiveValueToObject(ODataPrimitiveValue value, Class<?> reference) {
        Object obj;
        try {
            obj = reference == null ? value.toValue() : value.toCastValue(reference);
        }
        catch (EdmPrimitiveTypeException e) {
            LOG.warn("While casting primitive value {} to {}", new Object[]{value, reference, e});
            obj = value.toValue();
        }
        return obj;
    }

    private static void setPropertyValue(Object bean, Method getter, Object value) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String setterName = getter.getName().replaceFirst("get", "set");
        bean.getClass().getMethod(setterName, getter.getReturnType()).invoke(bean, value);
    }

    private static Class<?> getPropertyClass(Class<?> entityClass, String propertyName) {
        Class<?> propertyClass = null;
        try {
            Method getter = entityClass.getMethod("get" + StringUtils.capitalize((String)propertyName), new Class[0]);
            if (getter != null) {
                propertyClass = getter.getReturnType();
            }
        }
        catch (Exception e) {
            LOG.error("Could not determine the Java type of {}", (Object)propertyName, (Object)e);
        }
        return propertyClass;
    }

    public static CommonURIBuilder<?> buildEditLink(CommonEdmEnabledODataClient<?> client, String entitySetURI, CommonODataEntity entity, Object key) {
        CommonURIBuilder uriBuilder;
        if (key == null) {
            return null;
        }
        CommonURIBuilder commonURIBuilder = uriBuilder = StringUtils.isNotBlank((CharSequence)entitySetURI) ? client.newURIBuilder(entitySetURI) : client.newURIBuilder();
        if (key.getClass().getAnnotation(CompoundKey.class) == null) {
            LOG.debug("Append key segment '{}'", key);
            uriBuilder.appendKeySegment(key);
        } else {
            LOG.debug("Append compound key segment '{}'", key);
            uriBuilder.appendKeySegment(CoreUtils.getCompoundKey((Object)key));
        }
        return uriBuilder;
    }

    public static Map<String, Object> getCompoundKey(Object key) {
        TreeSet<CompoundKeyElementWrapper> elements = new TreeSet<CompoundKeyElementWrapper>();
        for (Method method : key.getClass().getMethods()) {
            CompoundKeyElement annotation = method.getAnnotation(CompoundKeyElement.class);
            if (!(annotation instanceof CompoundKeyElement)) continue;
            elements.add(new CompoundKeyElementWrapper(annotation.name(), method, annotation.position()));
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (CompoundKeyElementWrapper element : elements) {
            try {
                map.put(element.getName(), element.getMethod().invoke(key, new Object[0]));
            }
            catch (Exception e) {
                LOG.warn("Error retrieving compound key element '{}' value", (Object)element.getName(), (Object)e);
            }
        }
        return map;
    }

    public static Object getKey(CommonEdmEnabledODataClient<?> client, EntityInvocationHandler typeHandler, Class<?> entityTypeRef, CommonODataEntity entity) {
        Object res = null;
        if (!entity.getProperties().isEmpty()) {
            Class keyRef = ClassUtils.getCompoundKeyRef(entityTypeRef);
            if (keyRef == null) {
                CommonODataProperty property = entity.getProperty(CoreUtils.firstValidEntityKey(entityTypeRef));
                if (property != null && property.hasPrimitiveValue()) {
                    res = CoreUtils.primitiveValueToObject((ODataPrimitiveValue)property.getPrimitiveValue(), (Class)CoreUtils.getPropertyClass(entityTypeRef, (String)property.getName()));
                }
            } else {
                try {
                    res = keyRef.newInstance();
                    CoreUtils.populate(client, (EntityInvocationHandler)typeHandler, res, CompoundKeyElement.class, entity.getProperties().iterator());
                }
                catch (Exception e) {
                    LOG.error("Error population compound key {}", (Object)keyRef.getSimpleName(), (Object)e);
                    throw new IllegalArgumentException("Cannot populate compound key");
                }
            }
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void populate(CommonEdmEnabledODataClient<?> client, EntityInvocationHandler typeHandler, Object bean, Class<? extends Annotation> getterAnn, Iterator<? extends CommonODataProperty> propItor) {
        Class typeRef;
        if (bean == null) return;
        if (bean instanceof Proxy) {
            InvocationHandler handler = Proxy.getInvocationHandler(bean);
            if (!(handler instanceof AbstractStructuredInvocationHandler)) throw new IllegalStateException("Invalid bean " + bean);
            typeRef = ((ComplexInvocationHandler)handler).getTypeRef();
        } else {
            typeRef = bean.getClass();
        }
        CoreUtils.populate(client, (EntityInvocationHandler)typeHandler, (Object)bean, (Class)typeRef, getterAnn, propItor);
    }

    private static void populate(CommonEdmEnabledODataClient<?> client, EntityInvocationHandler typeHandler, Object bean, Class<?> typeRef, Class<? extends Annotation> getterAnn, Iterator<? extends CommonODataProperty> propItor) {
        if (bean != null) {
            while (propItor.hasNext()) {
                CommonODataProperty property = propItor.next();
                Method getter = ClassUtils.findGetterByAnnotatedName(typeRef, getterAnn, (String)property.getName());
                if (getter == null) {
                    LOG.warn("Could not find any property annotated as {} in {}", (Object)property.getName(), (Object)bean.getClass().getName());
                    continue;
                }
                try {
                    if (property.hasNullValue()) {
                        CoreUtils.setPropertyValue((Object)bean, (Method)getter, null);
                        continue;
                    }
                    if (property.hasPrimitiveValue()) {
                        CoreUtils.setPropertyValue((Object)bean, (Method)getter, (Object)CoreUtils.primitiveValueToObject((ODataPrimitiveValue)property.getPrimitiveValue(), (Class)CoreUtils.getPropertyClass(typeRef, (String)property.getName())));
                        continue;
                    }
                    if (property.hasComplexValue()) {
                        Object complex = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{getter.getReturnType()}, (InvocationHandler)ComplexInvocationHandler.getInstance((String)property.getName(), (EntityInvocationHandler)typeHandler, getter.getReturnType()));
                        CoreUtils.populate(client, (EntityInvocationHandler)typeHandler, (Object)complex, Property.class, (Iterator)property.getValue().asComplex().iterator());
                        CoreUtils.setPropertyValue((Object)bean, (Method)getter, (Object)complex);
                        continue;
                    }
                    if (!property.hasCollectionValue()) continue;
                    ParameterizedType collType = (ParameterizedType)getter.getGenericReturnType();
                    Class collItemClass = (Class)collType.getActualTypeArguments()[0];
                    ArrayList<Object> collection = (ArrayList<Object>)getter.invoke(bean, new Object[0]);
                    if (collection == null) {
                        collection = new ArrayList<Object>();
                        CoreUtils.setPropertyValue((Object)bean, (Method)getter, collection);
                    }
                    for (ODataValue value : property.getValue().asCollection()) {
                        if (value.isPrimitive()) {
                            collection.add(CoreUtils.primitiveValueToObject((ODataPrimitiveValue)value.asPrimitive(), (Class)CoreUtils.getPropertyClass(typeRef, (String)property.getName())));
                            continue;
                        }
                        if (!value.isComplex()) continue;
                        Object collItem = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{collItemClass}, (InvocationHandler)ComplexInvocationHandler.getInstance((String)property.getName(), (EntityInvocationHandler)typeHandler, (Class)collItemClass));
                        CoreUtils.populate(client, (EntityInvocationHandler)typeHandler, (Object)collItem, Property.class, (Iterator)value.asComplex().iterator());
                        collection.add(collItem);
                    }
                }
                catch (Exception e) {
                    LOG.error("Could not set property {} on {}", new Object[]{getter, bean, e});
                }
            }
        }
    }

    public static Object getObjectFromODataValue(ODataValue value, Type typeRef, AbstractService<?> service) throws InstantiationException, IllegalAccessException {
        Class internalRef;
        if (typeRef == null) {
            internalRef = null;
        } else {
            try {
                internalRef = (Class)((ParameterizedType)typeRef).getActualTypeArguments()[0];
            }
            catch (ClassCastException e) {
                internalRef = (Class)typeRef;
            }
        }
        return CoreUtils.getObjectFromODataValue((ODataValue)value, (Class)internalRef, service);
    }

    public static Object getObjectFromODataValue(ODataValue value, Class<?> ref, AbstractService<?> service) throws InstantiationException, IllegalAccessException {
        Object res;
        if (value == null) {
            res = null;
        } else if (value.isComplex()) {
            Class internalRef = CoreUtils.getComplexTypeRef(service, (ODataValue)value);
            res = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{internalRef}, (InvocationHandler)ComplexInvocationHandler.getInstance((ODataComplexValue)value.asComplex(), (Class)internalRef, service));
        } else if (value.isCollection()) {
            ArrayList<Object> collection = new ArrayList<Object>();
            for (ODataValue itemValue : value.asCollection()) {
                if (itemValue.isPrimitive()) {
                    collection.add(CoreUtils.primitiveValueToObject((ODataPrimitiveValue)itemValue.asPrimitive(), (Class)ref));
                    continue;
                }
                if (!itemValue.isComplex()) continue;
                Class internalRef = CoreUtils.getComplexTypeRef(service, (ODataValue)value);
                Object collItem = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{internalRef}, (InvocationHandler)ComplexInvocationHandler.getInstance((ODataComplexValue)itemValue.asComplex(), (Class)internalRef, service));
                collection.add(collItem);
            }
            res = collection;
        } else {
            res = value instanceof ODataEnumValue ? CoreUtils.enumValueToObject((ODataEnumValue)((ODataEnumValue)value), ref == null ? CoreUtils.getEnumTypeRef(service, (ODataValue)value) : ref) : CoreUtils.primitiveValueToObject((ODataPrimitiveValue)value.asPrimitive(), ref);
        }
        return res;
    }

    public static Collection<Class<? extends AbstractTerm>> getAnnotationTerms(AbstractService<?> service, List<ODataAnnotation> annotations) {
        ArrayList<Class<? extends AbstractTerm>> res = new ArrayList<Class<? extends AbstractTerm>>();
        for (ODataAnnotation annotation : annotations) {
            Class clazz = service.getTermClass(annotation.getTerm());
            if (clazz == null) continue;
            res.add(clazz);
        }
        return res;
    }

    private static Class<?> getEnumTypeRef(AbstractService<?> service, ODataValue value) {
        return service.getEnumTypeClass(value.getTypeName().replaceAll("^Collection\\(", "").replaceAll("\\)$", ""));
    }

    public static Class<?> getComplexTypeRef(AbstractService<?> service, ODataValue value) {
        return service.getComplexTypeClass(value.getTypeName().replaceAll("^Collection\\(", "").replaceAll("\\)$", ""));
    }

    private static String firstValidEntityKey(Class<?> entityTypeRef) {
        for (Method method : entityTypeRef.getDeclaredMethods()) {
            Property ann;
            if (method.getAnnotation(Key.class) == null || (ann = method.getAnnotation(Property.class)) == null) continue;
            return ann.name();
        }
        return null;
    }

    public static URI getMediaEditLink(String name, CommonODataEntity entity) {
        ODataLink mediaEditLink = entity.getMediaEditLink(name);
        return mediaEditLink == null ? URIUtils.getURI((URI)entity.getEditLink(), (String)name) : mediaEditLink.getLink();
    }

    public static URI getTargetEntitySetURI(CommonEdmEnabledODataClient<?> client, NavigationProperty property) {
        Edm edm = client.getCachedEdm();
        FullQualifiedName containerName = new FullQualifiedName(property.targetSchema(), property.targetContainer());
        EdmEntityContainer container = edm.getEntityContainer(containerName);
        CommonURIBuilder uriBuilder = client.newURIBuilder(client.getServiceRoot());
        if (!container.isDefault()) {
            StringBuilder entitySetSegment = new StringBuilder();
            entitySetSegment.append(container.getFullQualifiedName()).append('.');
            entitySetSegment.append(property.targetEntitySet());
            uriBuilder.appendEntitySetSegment(entitySetSegment.toString());
        } else {
            uriBuilder.appendEntitySetSegment(property.targetEntitySet());
        }
        return uriBuilder.build();
    }
}

