/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import org.apache.olingo.ext.proxy.api.annotations.CompoundKey;
import org.apache.olingo.ext.proxy.api.annotations.EntityType;
import org.apache.olingo.ext.proxy.api.annotations.Key;
import org.apache.olingo.ext.proxy.api.annotations.KeyRef;
import org.apache.olingo.ext.proxy.api.annotations.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ClassUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ClassUtils.class);

    private ClassUtils() {
    }

    public static Type[] extractGenericType(Class<?> paramType, Class<?> ... references) {
        if (paramType.getGenericInterfaces().length > 0) {
            if (references == null || references.length == 0) {
                return ((ParameterizedType)paramType.getGenericInterfaces()[0]).getActualTypeArguments();
            }
            for (Type type : paramType.getGenericInterfaces()) {
                Class typeClass = ClassUtils.getTypeClass((Type)type);
                for (Class<?> reference : references) {
                    if (!reference.isAssignableFrom(typeClass)) continue;
                    return ((ParameterizedType)type).getActualTypeArguments();
                }
            }
        }
        throw new IllegalArgumentException("Invalid type argument " + paramType);
    }

    public static Class<?> extractTypeArg(Class<?> paramType, Class<?> ... references) {
        return (Class)Class.class.cast(ClassUtils.extractGenericType(paramType, (Class[])references)[0]);
    }

    public static Method findGetterByAnnotatedName(Class<?> clazz, Class<? extends Annotation> ann, String name) {
        Method[] methods = clazz.getMethods();
        Method result = null;
        for (int i = 0; i < methods.length && result == null; ++i) {
            Annotation annotation = methods[i].getAnnotation(ann);
            try {
                if (annotation == null || !methods[i].getName().startsWith("get") || !name.equals(ann.getMethod("name", new Class[0]).invoke((Object)annotation, new Object[0]))) continue;
                result = methods[i];
                continue;
            }
            catch (Exception e) {
                LOG.warn("Error retrieving value annotation name for {}.{}", (Object)clazz.getName(), (Object)methods[i].getName());
            }
        }
        return result;
    }

    public static <ANN extends Annotation> ANN getAnnotation(Class<ANN> reference, AccessibleObject obj) {
        ANN ann = obj.getAnnotation(reference);
        return (ANN)(ann == null ? null : (Annotation)reference.cast(ann));
    }

    public static Class<?> getCompoundKeyRef(Class<?> entityTypeRef) {
        if (entityTypeRef.getAnnotation(EntityType.class) == null) {
            throw new IllegalArgumentException("Invalid annotation for entity type " + entityTypeRef);
        }
        KeyRef ann = entityTypeRef.getAnnotation(KeyRef.class);
        return ann == null || ann.value().getAnnotation(CompoundKey.class) == null ? null : ann.value();
    }

    public static Class<?> getKeyRef(Class<?> entityTypeRef) {
        Class<?> res = ClassUtils.getCompoundKeyRef(entityTypeRef);
        if (res == null) {
            HashSet<Method> keyGetters = new HashSet<Method>();
            for (Method method : entityTypeRef.getDeclaredMethods()) {
                if (!method.getName().startsWith("get") || method.getAnnotation(Key.class) == null) continue;
                keyGetters.add(method);
            }
            if (keyGetters.size() == 1) {
                res = ((Method)keyGetters.iterator().next()).getReturnType();
            } else {
                throw new IllegalStateException(entityTypeRef.getSimpleName() + "'s key reference not found");
            }
        }
        return res;
    }

    public static String getEntityTypeName(Class<?> ref) {
        EntityType annotation = ref.getAnnotation(EntityType.class);
        if (!(annotation instanceof EntityType)) {
            throw new IllegalArgumentException(ref.getPackage().getName() + " is not annotated as @" + EntityType.class.getSimpleName());
        }
        return annotation.name();
    }

    public static String getNamespace(Class<?> ref) {
        Namespace annotation = ref.getAnnotation(Namespace.class);
        if (!(annotation instanceof Namespace)) {
            throw new IllegalArgumentException(ref.getName() + " is not annotated as @" + Namespace.class.getSimpleName());
        }
        return annotation.value();
    }

    public static Void returnVoid() throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor voidConstructor = Void.class.getDeclaredConstructor(new Class[0]);
        voidConstructor.setAccessible(true);
        return (Void)voidConstructor.newInstance(new Object[0]);
    }

    public static Type[] getTypeArguments(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)ParameterizedType.class.cast(type)).getActualTypeArguments();
        }
        if (type instanceof TypeVariable) {
            return ((TypeVariable)TypeVariable.class.cast(type)).getBounds();
        }
        return new Type[0];
    }

    public static <T> Class<T> getTypeClass(Type type) {
        if (type instanceof ParameterizedType) {
            return ClassUtils.getTypeClass((Type)((ParameterizedType)ParameterizedType.class.cast(type)).getRawType());
        }
        if (type instanceof Class) {
            return (Class)Class.class.cast(type);
        }
        return null;
    }
}

