/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.StatusLine;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.ODataBatchableRequest;
import org.apache.olingo.client.api.communication.request.ODataRequest;
import org.apache.olingo.client.api.communication.request.ODataStreamedRequest;
import org.apache.olingo.client.api.communication.request.batch.BatchManager;
import org.apache.olingo.client.api.communication.request.batch.CommonODataBatchRequest;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchResponseItem;
import org.apache.olingo.client.api.communication.request.batch.ODataChangeset;
import org.apache.olingo.client.api.communication.response.ODataBatchResponse;
import org.apache.olingo.client.api.communication.response.ODataEntityCreateResponse;
import org.apache.olingo.client.api.communication.response.ODataEntityUpdateResponse;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.core.communication.header.ODataErrorResponseChecker;
import org.apache.olingo.client.core.communication.request.batch.ODataChangesetResponseItem;
import org.apache.olingo.commons.api.ODataRuntimeException;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.commons.AbstractPersistenceManager;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.commons.PersistenceChanges;
import org.apache.olingo.ext.proxy.commons.TransactionItems;

public class TransactionalPersistenceManagerImpl
extends AbstractPersistenceManager {
    private static final long serialVersionUID = -3320312269235907501L;

    public TransactionalPersistenceManagerImpl(AbstractService<?> factory) {
        super(factory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<ODataRuntimeException> doFlush(PersistenceChanges changes, TransactionItems items) {
        CommonODataBatchRequest request = this.service.getClient().getBatchRequestFactory().getBatchRequest(this.service.getClient().getServiceRoot());
        ((ODataRequest)request).setAccept(this.service.getClient().getConfiguration().getDefaultBatchAcceptFormat().toContentTypeString());
        BatchManager batchManager = (BatchManager)((ODataStreamedRequest)request).payloadManager();
        ODataChangeset changeset = batchManager.addChangeset();
        for (Map.Entry entry : changes.getChanges().entrySet()) {
            changeset.addRequest((ODataBatchableRequest)entry.getKey());
        }
        ODataBatchResponse response = (ODataBatchResponse)batchManager.getResponse();
        if (response.getStatusCode() != 202 && response.getStatusCode() != 200) {
            throw new IllegalStateException("Operation failed");
        }
        ArrayList<ODataRuntimeException> result = new ArrayList<ODataRuntimeException>();
        if (!items.isEmpty()) {
            Iterator batchResItor = response.getBody();
            if (!batchResItor.hasNext()) {
                throw new IllegalStateException("Unexpected operation result");
            }
            ODataBatchResponseItem item = (ODataBatchResponseItem)batchResItor.next();
            if (!(item instanceof ODataChangesetResponseItem)) {
                throw new IllegalStateException("Unexpected batch response item " + item.getClass().getSimpleName());
            }
            ODataChangesetResponseItem chgres = (ODataChangesetResponseItem)item;
            for (Integer changesetItemId : items.sortedValues()) {
                EntityInvocationHandler handler;
                LOG.debug("Expected changeset item {}", (Object)changesetItemId);
                ODataResponse res = chgres.next();
                if (res.getStatusCode() >= 400) {
                    if (!this.service.getClient().getConfiguration().isContinueOnError()) throw new IllegalStateException("Transaction failed: " + res.getStatusMessage());
                    result.add(ODataErrorResponseChecker.checkResponse((CommonODataClient)this.service.getClient(), (StatusLine)new /* Unavailable Anonymous Inner Class!! */, (InputStream)res.getRawResponse(), (String)((ODataRequest)request).getAccept()));
                } else {
                    result.add(null);
                }
                if ((handler = items.get(changesetItemId)) == null) continue;
                if (res instanceof ODataEntityCreateResponse && res.getStatusCode() == 201) {
                    handler.setEntity(((ODataEntityCreateResponse)res).getBody());
                    LOG.debug("Upgrade created object '{}'", (Object)handler);
                    continue;
                }
                if (!(res instanceof ODataEntityUpdateResponse) || res.getStatusCode() != 200) continue;
                handler.setEntity(((ODataEntityUpdateResponse)res).getBody());
                LOG.debug("Upgrade updated object '{}'", (Object)handler);
            }
        }
        response.close();
        return result;
    }
}

