/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.olingo.client.api.communication.request.retrieve.ODataPropertyRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.uri.CommonURIBuilder;
import org.apache.olingo.commons.api.domain.v4.ODataAnnotation;
import org.apache.olingo.commons.api.domain.v4.ODataProperty;
import org.apache.olingo.commons.api.domain.v4.ODataValue;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.PrimitiveCollection;
import org.apache.olingo.ext.proxy.commons.AbstractCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.OperationInvocationHandler;

public class PrimitiveCollectionInvocationHandler<T extends Serializable>
extends AbstractCollectionInvocationHandler<T, PrimitiveCollection<T>> {
    private static final long serialVersionUID = 98078202642671756L;

    public PrimitiveCollectionInvocationHandler(AbstractService<?> service, Class<T> itemRef) {
        this(service, new ArrayList(), itemRef, null);
    }

    public PrimitiveCollectionInvocationHandler(AbstractService<?> service, Class<T> itemRef, CommonURIBuilder<?> uri) {
        this(service, new ArrayList(), itemRef, uri);
    }

    public PrimitiveCollectionInvocationHandler(AbstractService<?> service, Collection<T> items, Class<T> itemRef, CommonURIBuilder<?> uri) {
        super(service, items, itemRef, uri);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("filter".equals(method.getName()) || "top".equals(method.getName()) || "skip".equals(method.getName()) || "execute".equals(method.getName()) || "executeAsync".equals(method.getName())) {
            this.invokeSelfMethod(method, args);
            return proxy;
        }
        if (this.isSelfMethod(method, args)) {
            return this.invokeSelfMethod(method, args);
        }
        if ("operations".equals(method.getName()) && ArrayUtils.isEmpty((Object[])args)) {
            Class<?> returnType = method.getReturnType();
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{returnType}, (InvocationHandler)OperationInvocationHandler.getInstance((PrimitiveCollectionInvocationHandler)this));
        }
        throw new NoSuchMethodException(method.getName());
    }

    public Triple<List<T>, URI, List<ODataAnnotation>> fetchPartial(URI uri, Class<T> typeRef) {
        ODataPropertyRequest req = this.getClient().getRetrieveRequestFactory().getPropertyRequest(uri);
        if (this.getClient().getServiceVersion().compareTo((Enum)ODataServiceVersion.V30) > 0) {
            req.setPrefer(this.getClient().newPreferences().includeAnnotations("*"));
        }
        ODataRetrieveResponse res = (ODataRetrieveResponse)req.execute();
        ArrayList<Serializable> resItems = new ArrayList<Serializable>();
        ODataProperty property = (ODataProperty)res.getBody();
        if (property != null && !property.hasNullValue()) {
            for (ODataValue item : property.getCollectionValue()) {
                resItems.add((Serializable)item.asPrimitive().toValue());
            }
        }
        return new ImmutableTriple(resItems, null, Collections.emptyList());
    }

    public void delete() {
        if (this.baseURI != null) {
            this.getContext().entityContext().addFurtherDeletes(this.getClient().newURIBuilder(this.baseURI.toASCIIString()).appendValueSegment().build());
        }
    }

    public boolean equals(Object obj) {
        InvocationHandler handler;
        if (obj instanceof Proxy && (handler = Proxy.getInvocationHandler(obj)) instanceof PrimitiveCollectionInvocationHandler) {
            return ((Object)this.items).equals(((PrimitiveCollectionInvocationHandler)PrimitiveCollectionInvocationHandler.class.cast((Object)handler)).items);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.items).hashCode();
    }
}

