/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.client.api.communication.request.ODataBasicRequest;
import org.apache.olingo.client.api.communication.request.ODataBatchableRequest;
import org.apache.olingo.client.api.communication.request.ODataRequest;
import org.apache.olingo.client.api.communication.request.ODataStreamedRequest;
import org.apache.olingo.client.api.communication.response.ODataEntityCreateResponse;
import org.apache.olingo.client.api.communication.response.ODataEntityUpdateResponse;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.commons.api.ODataRuntimeException;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.commons.AbstractPersistenceManager;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.commons.PersistenceChanges;
import org.apache.olingo.ext.proxy.commons.TransactionItems;

public class NonTransactionalPersistenceManagerImpl
extends AbstractPersistenceManager {
    private static final long serialVersionUID = 5082907388513308752L;

    public NonTransactionalPersistenceManagerImpl(AbstractService<?> factory) {
        super(factory);
    }

    protected List<ODataRuntimeException> doFlush(PersistenceChanges changes, TransactionItems items) {
        ArrayList<ODataRuntimeException> result = new ArrayList<ODataRuntimeException>();
        HashMap<Integer, URI> responses = new HashMap<Integer, URI>();
        int virtualContentID = 0;
        for (Map.Entry entry : changes.getChanges().entrySet()) {
            ++virtualContentID;
            try {
                int slashIndex;
                Integer toBeReplaced;
                ODataRequest req = (ODataRequest)ODataRequest.class.cast(entry.getKey());
                String uri = req.getURI().toASCIIString();
                if (uri.startsWith("$") && responses.containsKey(toBeReplaced = Integer.valueOf(uri.substring(1, (slashIndex = uri.indexOf(47)) < 0 ? uri.length() : slashIndex)))) {
                    uri = uri.replace("$" + toBeReplaced, ((URI)responses.get((int)toBeReplaced)).toASCIIString());
                    req.setURI(URI.create(uri));
                }
                ODataResponse response = ODataStreamedRequest.class.isAssignableFrom(req.getClass()) ? ((ODataStreamedRequest)req).payloadManager().getResponse() : ((ODataBasicRequest)req).execute();
                if (entry.getValue() != null && response instanceof ODataEntityCreateResponse && response.getStatusCode() == 201) {
                    ((EntityInvocationHandler)entry.getValue()).setEntity(((ODataEntityCreateResponse)response).getBody());
                    responses.put(virtualContentID, ((EntityInvocationHandler)entry.getValue()).getEntityURI());
                    LOG.debug("Upgrade created object '{}'", entry.getValue());
                } else if (entry.getValue() != null && response instanceof ODataEntityUpdateResponse && response.getStatusCode() == 200) {
                    ((EntityInvocationHandler)entry.getValue()).setEntity(((ODataEntityUpdateResponse)response).getBody());
                    responses.put(virtualContentID, ((EntityInvocationHandler)entry.getValue()).getEntityURI());
                    LOG.debug("Upgrade updated object '{}'", entry.getValue());
                } else {
                    responses.put(virtualContentID, null);
                }
                result.add(null);
            }
            catch (ODataRuntimeException e) {
                LOG.error("While performing {}", (Object)((ODataBatchableRequest)entry.getKey()).getURI(), (Object)e);
                if (this.service.getClient().getConfiguration().isContinueOnError()) {
                    result.add(e);
                    continue;
                }
                throw e;
            }
        }
        return result;
    }
}

