/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.olingo.ext.proxy.api.EntityCollection;
import org.apache.olingo.ext.proxy.api.EntityType;
import org.apache.olingo.ext.proxy.commons.EntitySetInvocationHandler;

class EntitySetIterator<T extends EntityType<?>, KEY extends Serializable, EC extends EntityCollection<T, ?, ?>>
implements Iterator<T> {
    private final EntitySetInvocationHandler<T, KEY, EC> esi;
    private URI next;
    private Iterator<T> current;

    EntitySetIterator(URI uri, EntitySetInvocationHandler<T, KEY, EC> esi) {
        this.esi = esi;
        this.next = uri;
        this.current = Collections.emptyList().iterator();
    }

    @Override
    public boolean hasNext() {
        boolean res;
        if (this.current.hasNext()) {
            res = true;
        } else if (this.next == null) {
            res = false;
        } else {
            this.goOn();
            res = this.current.hasNext();
        }
        return res;
    }

    @Override
    public T next() {
        EntityType res;
        try {
            res = (EntityType)this.current.next();
        }
        catch (NoSuchElementException e) {
            if (this.next == null) {
                throw e;
            }
            this.goOn();
            res = this.next();
        }
        return (T)res;
    }

    @Override
    public void remove() {
        this.current.remove();
    }

    private void goOn() {
        Triple entitySet = this.esi.fetchPartial(this.next, this.esi.getTypeRef());
        this.current = ((List)entitySet.getLeft()).iterator();
        this.next = (URI)entitySet.getMiddle();
    }
}

