/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.ComplexCollection;
import org.apache.olingo.ext.proxy.api.ComplexType;
import org.apache.olingo.ext.proxy.api.EdmStreamValue;
import org.apache.olingo.ext.proxy.api.EntityCollection;
import org.apache.olingo.ext.proxy.api.EntityType;
import org.apache.olingo.ext.proxy.api.PrimitiveCollection;
import org.apache.olingo.ext.proxy.api.annotations.EntityContainer;
import org.apache.olingo.ext.proxy.api.annotations.EntitySet;
import org.apache.olingo.ext.proxy.api.annotations.Namespace;
import org.apache.olingo.ext.proxy.api.annotations.Singleton;
import org.apache.olingo.ext.proxy.commons.AbstractInvocationHandler;
import org.apache.olingo.ext.proxy.commons.ComplexCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.ComplexInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EdmStreamValueHandler;
import org.apache.olingo.ext.proxy.commons.EntityCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntitySetInvocationHandler;
import org.apache.olingo.ext.proxy.commons.OperationInvocationHandler;
import org.apache.olingo.ext.proxy.commons.PrimitiveCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.context.EntityUUID;
import org.apache.olingo.ext.proxy.utils.ClassUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class EntityContainerInvocationHandler
extends AbstractInvocationHandler {
    private static final long serialVersionUID = 7379006755693410764L;
    protected final String namespace;
    private final String name;
    private final boolean defaultEC;

    public static EntityContainerInvocationHandler getInstance(Class<?> ref, AbstractService<?> service) {
        EntityContainerInvocationHandler instance = new EntityContainerInvocationHandler(ref, service);
        return instance;
    }

    private EntityContainerInvocationHandler(Class<?> ref, AbstractService<?> service) {
        super(service);
        EntityContainer annotation = ref.getAnnotation(EntityContainer.class);
        if (!(annotation instanceof EntityContainer)) {
            throw new IllegalArgumentException(ref.getName() + " is not annotated as @" + EntityContainer.class.getSimpleName());
        }
        this.name = annotation.name();
        this.defaultEC = annotation.isDefaultEntityContainer();
        this.namespace = annotation.namespace();
    }

    protected AbstractService<?> getService() {
        return this.service;
    }

    protected boolean isDefaultEntityContainer() {
        return this.defaultEC;
    }

    protected String getEntityContainerName() {
        return this.name;
    }

    protected String getSchemaName() {
        return this.namespace;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isSelfMethod(method, args)) {
            return this.invokeSelfMethod(method, args);
        }
        if ("flush".equals(method.getName()) && ArrayUtils.isEmpty((Object[])args)) {
            return this.service.getPersistenceManager().flush();
        }
        if ("flushAsync".equals(method.getName()) && ArrayUtils.isEmpty((Object[])args)) {
            return this.service.getPersistenceManager().flushAsync();
        }
        if ("operations".equals(method.getName()) && ArrayUtils.isEmpty((Object[])args)) {
            Class<?> returnType = method.getReturnType();
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{returnType}, (InvocationHandler)OperationInvocationHandler.getInstance((EntityContainerInvocationHandler)this));
        }
        Class<?> returnType = method.getReturnType();
        if (returnType.isAnnotationPresent(EntitySet.class)) {
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{returnType}, (InvocationHandler)EntitySetInvocationHandler.getInstance(returnType, (AbstractService)this.service));
        }
        if (returnType.isAnnotationPresent(org.apache.olingo.ext.proxy.api.annotations.EntityType.class)) {
            return this.getSingleton(method);
        }
        throw new NoSuchMethodException(method.getName());
    }

    private Object getSingleton(Method method) throws IllegalArgumentException {
        Class<?> typeRef = method.getReturnType();
        Singleton singleton = method.getAnnotation(Singleton.class);
        URI uri = EntityContainerInvocationHandler.buildEntitySetURI((String)singleton.container(), (String)singleton.name(), (AbstractService)this.service).build();
        EntityUUID uuid = new EntityUUID(uri, typeRef);
        LOG.debug("Ask for singleton '{}'", (Object)typeRef.getSimpleName());
        EntityInvocationHandler handler = this.getContext().entityContext().getEntity(uuid);
        if (handler == null) {
            CommonODataEntity entity = this.getClient().getObjectFactory().newEntity(new FullQualifiedName(typeRef.getAnnotation(Namespace.class).value(), ClassUtils.getEntityTypeName(typeRef)));
            handler = EntityInvocationHandler.getInstance((CommonODataEntity)entity, (URI)uri, (URI)uri, typeRef, (AbstractService)this.service);
        } else if (this.isDeleted(handler)) {
            LOG.debug("Singleton '{}' has been deleted", (Object)typeRef.getSimpleName());
            handler = null;
        }
        return handler == null ? null : Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{typeRef}, (InvocationHandler)handler);
    }

    public <NE extends EntityType> NE newEntityInstance(Class<NE> ref) {
        EntityInvocationHandler handler = EntityInvocationHandler.getInstance(ref, (AbstractService)this.getService());
        return (NE)((EntityType)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ref}, (InvocationHandler)handler));
    }

    public <T extends EntityType<?>, NEC extends EntityCollection<T, ?, ?>> NEC newEntityCollection(Class<NEC> ref) {
        return (NEC)((EntityCollection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ref}, (InvocationHandler)new EntityCollectionInvocationHandler(this.getService(), ref)));
    }

    public <NE extends ComplexType<?>> NE newComplexInstance(Class<NE> ref) {
        return (NE)((ComplexType)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ref}, (InvocationHandler)ComplexInvocationHandler.getInstance(ref, (AbstractService)this.getService())));
    }

    public <T extends ComplexType<?>, NEC extends ComplexCollection<T, ?, ?>> NEC newComplexCollection(Class<NEC> ref) {
        Class itemRef = ClassUtils.extractTypeArg(ref, (Class[])new Class[]{ComplexCollection.class});
        return (NEC)((ComplexCollection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ref}, (InvocationHandler)new ComplexCollectionInvocationHandler(this.getService(), itemRef)));
    }

    public <T extends Serializable, NEC extends PrimitiveCollection<T>> NEC newPrimitiveCollection(Class<T> ref) {
        return (NEC)((PrimitiveCollection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{PrimitiveCollection.class}, (InvocationHandler)new PrimitiveCollectionInvocationHandler(this.getService(), ref)));
    }

    public EdmStreamValue newEdmStreamValue(String contentType, InputStream stream) {
        return (EdmStreamValue)EdmStreamValue.class.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{EdmStreamValue.class}, (InvocationHandler)new EdmStreamValueHandler(contentType, stream, null, this.getService())));
    }
}

