/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.olingo.client.api.CommonEdmEnabledODataClient;
import org.apache.olingo.client.api.uri.CommonURIBuilder;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.domain.ODataComplexValue;
import org.apache.olingo.commons.api.domain.ODataValue;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.ComplexType;
import org.apache.olingo.ext.proxy.api.EntityType;
import org.apache.olingo.ext.proxy.api.annotations.EntitySet;
import org.apache.olingo.ext.proxy.api.annotations.Namespace;
import org.apache.olingo.ext.proxy.api.annotations.Singleton;
import org.apache.olingo.ext.proxy.commons.ComplexInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.context.AttachedEntityStatus;
import org.apache.olingo.ext.proxy.context.Context;
import org.apache.olingo.ext.proxy.context.EntityContext;
import org.apache.olingo.ext.proxy.utils.CoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
abstract class AbstractInvocationHandler
implements InvocationHandler {
    private static final long serialVersionUID = 358520026931462958L;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractInvocationHandler.class);
    protected AbstractService<?> service;

    protected AbstractInvocationHandler(AbstractService<?> service) {
        this.service = service;
    }

    protected CommonEdmEnabledODataClient<?> getClient() {
        return this.service.getClient();
    }

    protected Context getContext() {
        return this.service.getContext();
    }

    protected boolean isSelfMethod(Method method, Object[] args) {
        Method[] selfMethods = this.getClass().getMethods();
        boolean result = false;
        for (int i = 0; i < selfMethods.length && !result; ++i) {
            result = method.getName().equals(selfMethods[i].getName()) && Arrays.equals(method.getParameterTypes(), selfMethods[i].getParameterTypes());
        }
        return result;
    }

    protected Object invokeSelfMethod(Method method, Object[] args) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
    }

    protected ComplexType<?> getComplex(String name, ODataValue value, Class<?> ref, EntityInvocationHandler handler, URI baseURI, boolean collectionItem) {
        ComplexInvocationHandler complexHandler;
        CommonURIBuilder targetURI = collectionItem ? null : (baseURI == null ? null : this.getClient().newURIBuilder(baseURI.toASCIIString()).appendPropertySegment(name));
        Class actualRef = ref;
        if (value == null) {
            complexHandler = ComplexInvocationHandler.getInstance(actualRef, (AbstractService)this.service, (CommonURIBuilder)targetURI);
        } else {
            actualRef = CoreUtils.getComplexTypeRef((AbstractService)this.service, (ODataValue)value);
            complexHandler = ComplexInvocationHandler.getInstance((ODataComplexValue)value.asComplex(), (Class)actualRef, (AbstractService)this.service, (CommonURIBuilder)targetURI);
        }
        complexHandler.setEntityHandler(handler);
        ComplexType res = (ComplexType)ComplexType.class.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{actualRef}, (InvocationHandler)complexHandler));
        return res;
    }

    protected boolean isDeleted(EntityInvocationHandler handler) {
        return this.getContext().entityContext().isAttached(handler) && this.getContext().entityContext().getStatus(handler) == AttachedEntityStatus.DELETED || this.getContext().entityContext().getFurtherDeletes().contains(handler.getEntityURI());
    }

    protected <S extends EntityType<?>> void deleteEntity(EntityInvocationHandler handler, URI entitySetURI) {
        URI entityURI;
        CommonODataEntity template;
        URI baseURI;
        EntityContext entityContext = this.getContext().entityContext();
        URI uRI = baseURI = entitySetURI == null ? handler.getEntitySetURI() : entitySetURI;
        if (baseURI == null) {
            throw new IllegalStateException("Entity base URI not available");
        }
        String name = handler.getUUID().getType().getAnnotation(org.apache.olingo.ext.proxy.api.annotations.EntityType.class).name();
        String namespace = handler.getUUID().getType().getAnnotation(Namespace.class).value();
        if (handler.getEntityURI() == null || handler.getUUID().getKey() == null) {
            template = this.service.getClient().getObjectFactory().newEntity(new FullQualifiedName(namespace, name));
            CoreUtils.addProperties((CommonEdmEnabledODataClient)this.getClient(), (Map)handler.getPropertyChanges(), (CommonODataEntity)template);
            Object key = CoreUtils.getKey((CommonEdmEnabledODataClient)this.getClient(), (EntityInvocationHandler)handler, (Class)handler.getUUID().getType(), (CommonODataEntity)template);
            entityURI = CoreUtils.buildEditLink((CommonEdmEnabledODataClient)this.getClient(), (String)baseURI.toASCIIString(), (CommonODataEntity)template, (Object)key).build();
            template.setEditLink(entityURI);
        } else {
            entityURI = handler.getEntityURI();
            template = handler.getEntity();
        }
        if (entityContext.isAttached(handler)) {
            entityContext.addFurtherDeletes(entityURI);
        } else {
            if (handler.getUUID().getKey() == null) {
                handler.updateEntityUUID(baseURI, handler.getUUID().getType(), template);
            } else {
                handler.updateUUID(baseURI, handler.getUUID().getType(), handler.getUUID().getKey());
            }
            entityContext.attach(handler, AttachedEntityStatus.DELETED, true);
        }
    }

    protected static CommonURIBuilder<?> buildEntitySetURI(Class<?> ref, AbstractService<?> service) {
        String entitySetName;
        String containerNS;
        EntitySet ann = ref.getAnnotation(EntitySet.class);
        if (ann instanceof EntitySet) {
            containerNS = ((EntitySet)EntitySet.class.cast(ann)).container();
            entitySetName = ((EntitySet)EntitySet.class.cast(ann)).name();
        } else {
            ann = ref.getAnnotation(Singleton.class);
            if (ann instanceof Singleton) {
                containerNS = ((Singleton)Singleton.class.cast(ann)).container();
                entitySetName = ((Singleton)Singleton.class.cast(ann)).name();
            } else {
                containerNS = null;
                entitySetName = null;
            }
        }
        return AbstractInvocationHandler.buildEntitySetURI((String)containerNS, (String)entitySetName, service);
    }

    protected static CommonURIBuilder<?> buildEntitySetURI(String containerNS, String entitySetName, AbstractService<?> service) {
        EdmEntityContainer container;
        CommonURIBuilder uriBuilder = service.getClient().newURIBuilder();
        Edm edm = service.getClient().getCachedEdm();
        StringBuilder entitySetSegment = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)containerNS) && !(container = edm.getEntityContainer(new FullQualifiedName(containerNS))).isDefault()) {
            entitySetSegment.append(container.getFullQualifiedName().toString()).append('.');
        }
        entitySetSegment.append(entitySetName);
        uriBuilder.appendEntitySetSegment(entitySetSegment.toString());
        return uriBuilder;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

