/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.olingo.client.api.communication.request.retrieve.ODataEntitySetRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.uri.CommonURIBuilder;
import org.apache.olingo.client.api.v4.ODataClient;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.domain.CommonODataEntitySet;
import org.apache.olingo.commons.api.domain.v4.ODataAnnotation;
import org.apache.olingo.commons.api.domain.v4.ODataEntitySet;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.AbstractEntitySet;
import org.apache.olingo.ext.proxy.api.AbstractSingleton;
import org.apache.olingo.ext.proxy.api.EntityCollection;
import org.apache.olingo.ext.proxy.api.EntityType;
import org.apache.olingo.ext.proxy.commons.AbstractCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntitySetInvocationHandler;
import org.apache.olingo.ext.proxy.utils.ClassUtils;

public abstract class AbstractEntityCollectionInvocationHandler<T extends EntityType<?>, EC extends EntityCollection<T, ?, ?>>
extends AbstractCollectionInvocationHandler<T, EC> {
    private static final long serialVersionUID = 98078202642671727L;
    protected URI targetEntitySetURI;
    private boolean isSingleton = false;
    protected final Class<EC> collItemRef;

    public AbstractEntityCollectionInvocationHandler(Class<?> ref, AbstractService<?> service, CommonURIBuilder<?> uri) {
        super(service, new ArrayList(), ClassUtils.extractTypeArg(ref, (Class[])new Class[]{AbstractEntitySet.class, AbstractSingleton.class, EntityCollection.class}), uri);
        this.targetEntitySetURI = uri.build();
        this.isSingleton = AbstractSingleton.class.isAssignableFrom(ref);
        Type[] entitySetParams = ClassUtils.extractGenericType(ref, (Class[])new Class[]{AbstractEntitySet.class, AbstractSingleton.class});
        this.collItemRef = entitySetParams != null ? (Class)entitySetParams[2] : null;
    }

    public AbstractEntityCollectionInvocationHandler(Class<? extends EntityCollection<T, ?, ?>> ref, AbstractService<?> service, URI targetEntitySetURI, CommonURIBuilder<?> uri) {
        super(service, new ArrayList(), ClassUtils.extractTypeArg(ref, (Class[])new Class[]{EntityCollection.class}), uri);
        this.uri = uri;
        this.targetEntitySetURI = targetEntitySetURI;
        this.collItemRef = ref;
    }

    public Triple<List<T>, URI, List<ODataAnnotation>> fetchPartial(URI uri, Class<T> typeRef) {
        URI next;
        Object res;
        ArrayList<Object> entities = new ArrayList<Object>();
        ArrayList anns = new ArrayList();
        if (this.isSingleton) {
            res = (ODataRetrieveResponse)((ODataClient)this.getClient()).getRetrieveRequestFactory().getSingletonRequest(uri).execute();
            entities.add(res.getBody());
            next = null;
        } else {
            ODataEntitySetRequest req = this.getClient().getRetrieveRequestFactory().getEntitySetRequest(uri);
            if (this.getClient().getServiceVersion().compareTo((Enum)ODataServiceVersion.V30) > 0) {
                req.setPrefer(this.getClient().newPreferences().includeAnnotations("*"));
            }
            ODataRetrieveResponse res2 = (ODataRetrieveResponse)req.execute();
            CommonODataEntitySet commonODataEntitySet = (CommonODataEntitySet)res2.getBody();
            entities.addAll(commonODataEntitySet.getEntities());
            next = commonODataEntitySet.getNext();
            if (commonODataEntitySet instanceof ODataEntitySet) {
                anns.addAll(((ODataEntitySet)commonODataEntitySet).getAnnotations());
            }
        }
        res = new ArrayList(entities.size());
        for (CommonODataEntity commonODataEntity : entities) {
            Class actualRef = null;
            if (commonODataEntity.getTypeName() != null) {
                actualRef = this.service.getEntityTypeClass(commonODataEntity.getTypeName().toString());
            }
            if (actualRef == null) {
                actualRef = typeRef;
            }
            EntityInvocationHandler handler = this instanceof EntitySetInvocationHandler ? EntityInvocationHandler.getInstance((CommonODataEntity)commonODataEntity, (EntitySetInvocationHandler)((EntitySetInvocationHandler)EntitySetInvocationHandler.class.cast(this)), (Class)actualRef) : EntityInvocationHandler.getInstance((CommonODataEntity)commonODataEntity, (URI)this.targetEntitySetURI, (Class)actualRef, (AbstractService)this.service);
            EntityInvocationHandler handlerInTheContext = this.getContext().entityContext().getEntity(handler.getUUID());
            res.add((EntityType)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{actualRef}, (InvocationHandler)(handlerInTheContext == null ? handler : handlerInTheContext)));
        }
        return new ImmutableTriple(res, (Object)next, anns);
    }
}

