/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.olingo.client.api.uri.CommonURIBuilder;
import org.apache.olingo.client.api.uri.URIFilter;
import org.apache.olingo.client.api.uri.v4.URIBuilder;
import org.apache.olingo.commons.api.domain.ODataValue;
import org.apache.olingo.commons.api.domain.v4.ODataAnnotation;
import org.apache.olingo.commons.api.domain.v4.ODataEntity;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.AbstractTerm;
import org.apache.olingo.ext.proxy.api.EntityType;
import org.apache.olingo.ext.proxy.api.Sort;
import org.apache.olingo.ext.proxy.api.annotations.Namespace;
import org.apache.olingo.ext.proxy.api.annotations.Term;
import org.apache.olingo.ext.proxy.commons.AbstractInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.utils.CoreUtils;

public abstract class AbstractCollectionInvocationHandler<T extends Serializable, EC extends Collection<T>>
extends AbstractInvocationHandler
implements Collection<T> {
    private static final long serialVersionUID = 98078202642671726L;
    protected URI nextPageURI = null;
    protected Collection<T> items;
    protected Collection<String> referenceItems;
    protected final URI baseURI;
    protected CommonURIBuilder<?> uri;
    protected final Class<T> itemRef;
    protected final List<ODataAnnotation> annotations = new ArrayList();
    private final Map<Class<? extends AbstractTerm>, Object> annotationsByTerm = new HashMap();
    private boolean changed = false;

    public AbstractCollectionInvocationHandler(AbstractService<?> service, Collection<T> items, Class<T> itemRef, CommonURIBuilder<?> uri) {
        super(service);
        this.itemRef = itemRef;
        this.items = items;
        this.referenceItems = new ArrayList();
        this.uri = uri;
        this.baseURI = this.uri == null ? null : this.uri.build();
    }

    public Future<Collection<T>> executeAsync() {
        return this.service.getClient().getConfiguration().getExecutor().submit(new /* Unavailable Anonymous Inner Class!! */);
    }

    public Collection<T> execute() {
        if (this.uri != null) {
            Triple res = this.fetchPartial(this.uri.build(), this.itemRef);
            this.nextPageURI = (URI)res.getMiddle();
            if (this.items == null) {
                this.items = (Collection)res.getLeft();
            } else {
                this.items.clear();
                this.items.addAll((Collection)res.getLeft());
            }
            this.annotations.clear();
            this.annotations.addAll((Collection)res.getRight());
        }
        return this;
    }

    public abstract Triple<List<T>, URI, List<ODataAnnotation>> fetchPartial(URI var1, Class<T> var2);

    public void setAnnotations(List<ODataAnnotation> annotations) {
        this.annotations.clear();
        this.annotationsByTerm.clear();
        this.annotations.addAll(annotations);
    }

    protected Class<T> getTypeRef() {
        return this.itemRef;
    }

    protected URI getURI() {
        return this.baseURI;
    }

    public void nextPage() {
        if (!this.hasNextPage()) {
            throw new IllegalStateException("Next page URI not found");
        }
        this.uri = this.getClient().newURIBuilder(this.nextPageURI.toASCIIString());
    }

    public boolean hasNextPage() {
        return this.nextPageURI != null;
    }

    public Object getAnnotation(Class<? extends AbstractTerm> term) {
        Object res = null;
        if (this.annotationsByTerm.containsKey(term)) {
            res = this.annotationsByTerm.get(term);
        } else {
            try {
                Term termAnn = term.getAnnotation(Term.class);
                Namespace namespaceAnn = term.getAnnotation(Namespace.class);
                ODataAnnotation annotation = null;
                for (ODataAnnotation _annotation : this.annotations) {
                    if (!(namespaceAnn.value() + "." + termAnn.name()).equals(_annotation.getTerm())) continue;
                    annotation = _annotation;
                }
                Object object = res = annotation == null || annotation.hasNullValue() ? null : CoreUtils.getObjectFromODataValue((ODataValue)annotation.getValue(), null, (AbstractService)this.service);
                if (res != null) {
                    this.annotationsByTerm.put(term, res);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error getting annotation for term '" + term.getName() + "'", e);
            }
        }
        return res;
    }

    @Override
    public boolean add(T element) {
        if (element instanceof Proxy && Proxy.getInvocationHandler(element) instanceof EntityInvocationHandler) {
            EntityInvocationHandler handler = (EntityInvocationHandler)EntityInvocationHandler.class.cast(Proxy.getInvocationHandler(element));
            if (!this.service.getContext().entityContext().isAttached(handler) && this.baseURI != null) {
                handler.updateUUID(this.baseURI, this.itemRef, null);
                this.service.getContext().entityContext().attachNew(handler);
            }
        }
        this.changed = true;
        return this.items.add(element);
    }

    public <ET extends EntityType<?>> boolean addRef(ET element) {
        if (this.getClient().getServiceVersion().compareTo((Enum)ODataServiceVersion.V30) <= 0) {
            return false;
        }
        if (element instanceof Proxy && Proxy.getInvocationHandler(element) instanceof EntityInvocationHandler) {
            EntityInvocationHandler handler = (EntityInvocationHandler)EntityInvocationHandler.class.cast(Proxy.getInvocationHandler(element));
            URI id = ((ODataEntity)handler.getEntity()).getId();
            if (id == null) {
                return false;
            }
            this.changed = true;
            return this.referenceItems.add(id.toASCIIString());
        }
        return false;
    }

    public void refs() {
        if (this.getClient().getServiceVersion().compareTo((Enum)ODataServiceVersion.V40) >= 0) {
            ((URIBuilder)this.uri).appendRefSegment();
        }
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.items.contains(object);
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.items.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.items.toArray(array);
    }

    public Collection<Class<? extends AbstractTerm>> getAnnotationTerms() {
        return CoreUtils.getAnnotationTerms((AbstractService)this.service, (List)this.annotations);
    }

    @Override
    public boolean remove(Object object) {
        return this.items.remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.items.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        this.changed = true;
        return this.items.addAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.items.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.items.retainAll(collection);
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    public void filter(String filter) {
        if (this.uri != null) {
            this.uri.filter(filter);
        }
    }

    public void filter(URIFilter filter) {
        if (this.uri != null) {
            this.uri.filter(filter);
        }
    }

    public void orderBy(Sort ... sort) {
        if (this.uri != null) {
            StringBuilder builder = new StringBuilder();
            for (Sort sortClause : sort) {
                builder.append(sortClause.getKey()).append(' ').append(sortClause.getValue()).append(',');
            }
            builder.deleteCharAt(builder.length() - 1);
            this.uri.orderBy(builder.toString());
        }
    }

    public void orderBy(String orderBy) {
        if (this.uri != null) {
            this.uri.orderBy(orderBy);
        }
    }

    public void top(int top) throws IllegalArgumentException {
        if (this.uri != null) {
            this.uri.top(top);
        }
    }

    public void skip(int skip) throws IllegalArgumentException {
        if (this.uri != null) {
            this.uri.skip(skip);
        }
    }

    public void expand(String ... expand) {
        if (this.uri != null) {
            this.uri.expand(expand);
        }
    }

    public void select(String ... select) {
        if (this.uri != null) {
            this.uri.select(select);
        }
    }

    public void clearQueryOptions() {
        this.uri = this.baseURI == null ? null : this.getClient().newURIBuilder(this.baseURI.toASCIIString());
        this.nextPageURI = null;
    }

    public boolean isChanged() {
        return this.changed;
    }
}

