/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.client.api.CommonEdmEnabledODataClient;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.core.ODataClientFactory;
import org.apache.olingo.client.core.edm.EdmClientImpl;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.ext.proxy.api.AbstractTerm;
import org.apache.olingo.ext.proxy.api.PersistenceManager;
import org.apache.olingo.ext.proxy.commons.EntityContainerInvocationHandler;
import org.apache.olingo.ext.proxy.commons.NonTransactionalPersistenceManagerImpl;
import org.apache.olingo.ext.proxy.commons.TransactionalPersistenceManagerImpl;
import org.apache.olingo.ext.proxy.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractService<C extends CommonEdmEnabledODataClient<?>> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractService.class);
    private final Map<Class<?>, Object> ENTITY_CONTAINERS = new ConcurrentHashMap();
    private final CommonEdmEnabledODataClient<?> client;
    private final Context context;
    private final boolean transactional;
    private PersistenceManager persistenceManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractService(String compressedMetadata, String metadataETag, ODataServiceVersion version, String serviceRoot, boolean transactional) {
        ByteArrayInputStream bais = null;
        GZIPInputStream gzis = null;
        ObjectInputStream ois = null;
        XMLMetadata metadata = null;
        try {
            bais = new ByteArrayInputStream(new Base64().decode(compressedMetadata.getBytes("UTF-8")));
            gzis = new GZIPInputStream(bais);
            ois = new ObjectInputStream(gzis);
            metadata = (XMLMetadata)ois.readObject();
        }
        catch (Exception e) {
            try {
                LOG.error("While deserializing compressed metadata", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                IOUtils.closeQuietly(gzis);
                IOUtils.closeQuietly(bais);
                throw throwable;
            }
            IOUtils.closeQuietly(ois);
            IOUtils.closeQuietly(gzis);
            IOUtils.closeQuietly((InputStream)bais);
        }
        IOUtils.closeQuietly((InputStream)ois);
        IOUtils.closeQuietly((InputStream)gzis);
        IOUtils.closeQuietly((InputStream)bais);
        EdmClientImpl edm = metadata == null ? null : new EdmClientImpl(version, metadata.getSchemaByNsOrAlias());
        this.client = version.compareTo((Enum)ODataServiceVersion.V40) < 0 ? ODataClientFactory.getEdmEnabledV3((String)serviceRoot, (Edm)edm) : ODataClientFactory.getEdmEnabledV4((String)serviceRoot, (Edm)edm, (String)metadataETag);
        this.client.getConfiguration().setDefaultPubFormat(ODataFormat.JSON_FULL_METADATA);
        this.transactional = transactional;
        this.context = new Context();
    }

    public abstract Class<?> getEntityTypeClass(String var1);

    public abstract Class<?> getComplexTypeClass(String var1);

    public abstract Class<?> getEnumTypeClass(String var1);

    public abstract Class<? extends AbstractTerm> getTermClass(String var1);

    public C getClient() {
        return (C)this.client;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceManager getPersistenceManager() {
        AbstractService abstractService = this;
        synchronized (abstractService) {
            if (this.persistenceManager == null) {
                this.persistenceManager = this.transactional ? new TransactionalPersistenceManagerImpl(this) : new NonTransactionalPersistenceManagerImpl(this);
            }
        }
        return this.persistenceManager;
    }

    public <T> T getEntityContainer(Class<T> reference) throws IllegalStateException, IllegalArgumentException {
        if (!this.ENTITY_CONTAINERS.containsKey(reference)) {
            Object entityContainer = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{reference}, (InvocationHandler)EntityContainerInvocationHandler.getInstance(reference, (AbstractService)this));
            this.ENTITY_CONTAINERS.put(reference, entityContainer);
        }
        return reference.cast(this.ENTITY_CONTAINERS.get(reference));
    }
}

