/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.domain.ODataLinkType;
import org.apache.olingo.commons.api.domain.ODataOperation;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.data.AnnotationImpl;
import org.apache.olingo.commons.core.data.EntityImpl;
import org.apache.olingo.commons.core.data.LinkImpl;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.serialization.JsonDeserializer;

public class JsonEntityDeserializer
extends JsonDeserializer {
    public JsonEntityDeserializer(ODataServiceVersion version, boolean serverMode) {
        super(version, serverMode);
    }

    protected ResWrap<Entity> doDeserialize(JsonParser parser) throws IOException {
        LinkImpl link;
        String metadataETag;
        URI contextURL;
        ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
        if (tree.has("value") && tree.get("value").isArray()) {
            throw new JsonParseException("Expected OData Entity, found EntitySet", parser.getCurrentLocation());
        }
        EntityImpl entity = new EntityImpl();
        if (tree.hasNonNull("@odata.context")) {
            contextURL = URI.create(tree.get("@odata.context").textValue());
            tree.remove("@odata.context");
        } else if (tree.hasNonNull("odata.metadata")) {
            contextURL = URI.create(tree.get("odata.metadata").textValue());
            tree.remove("odata.metadata");
        } else {
            contextURL = null;
        }
        if (contextURL != null) {
            entity.setBaseURI(StringUtils.substringBefore((String)contextURL.toASCIIString(), (String)"$metadata"));
        }
        if (tree.hasNonNull("@odata.metadataEtag")) {
            metadataETag = tree.get("@odata.metadataEtag").textValue();
            tree.remove("@odata.metadataEtag");
        } else {
            metadataETag = null;
        }
        if (tree.hasNonNull(this.jsonETag)) {
            entity.setETag(tree.get(this.jsonETag).textValue());
            tree.remove(this.jsonETag);
        }
        if (tree.hasNonNull(this.jsonType)) {
            entity.setType(new EdmTypeInfo.Builder().setTypeExpression(tree.get(this.jsonType).textValue()).build().internal());
            tree.remove(this.jsonType);
        }
        if (tree.hasNonNull(this.jsonId)) {
            entity.setId(URI.create(tree.get(this.jsonId).textValue()));
            tree.remove(this.jsonId);
        }
        if (tree.hasNonNull(this.jsonReadLink)) {
            link = new LinkImpl();
            link.setRel("self");
            link.setHref(tree.get(this.jsonReadLink).textValue());
            entity.setSelfLink((Link)link);
            tree.remove(this.jsonReadLink);
        }
        if (tree.hasNonNull(this.jsonEditLink)) {
            link = new LinkImpl();
            if (this.serverMode) {
                link.setRel("edit");
            }
            link.setHref(tree.get(this.jsonEditLink).textValue());
            entity.setEditLink((Link)link);
            tree.remove(this.jsonEditLink);
        }
        if (tree.hasNonNull(this.jsonMediaReadLink)) {
            entity.setMediaContentSource(URI.create(tree.get(this.jsonMediaReadLink).textValue()));
            tree.remove(this.jsonMediaReadLink);
        }
        if (tree.hasNonNull(this.jsonMediaEditLink)) {
            entity.setMediaContentSource(URI.create(tree.get(this.jsonMediaEditLink).textValue()));
            tree.remove(this.jsonMediaEditLink);
        }
        if (tree.hasNonNull(this.jsonMediaContentType)) {
            entity.setMediaContentType(tree.get(this.jsonMediaContentType).textValue());
            tree.remove(this.jsonMediaContentType);
        }
        if (tree.hasNonNull(this.jsonMediaETag)) {
            entity.setMediaETag(tree.get(this.jsonMediaETag).textValue());
            tree.remove(this.jsonMediaETag);
        }
        HashSet<String> toRemove = new HashSet<String>();
        HashMap annotations = new HashMap();
        Iterator itor = tree.fields();
        while (itor.hasNext()) {
            Map.Entry field = (Map.Entry)itor.next();
            Matcher customAnnotation = this.CUSTOM_ANNOTATION.matcher((CharSequence)field.getKey());
            this.links(field, (Linked)entity, toRemove, (JsonNode)tree, parser.getCodec());
            if (((String)field.getKey()).endsWith(this.getJSONAnnotation(this.jsonMediaEditLink))) {
                LinkImpl link2 = new LinkImpl();
                link2.setTitle(this.getTitle(field));
                link2.setRel(this.version.getNamespace(ODataServiceVersion.NamespaceKey.MEDIA_EDIT_LINK_REL) + this.getTitle(field));
                link2.setHref(((JsonNode)field.getValue()).textValue());
                link2.setType(ODataLinkType.MEDIA_EDIT.toString());
                entity.getMediaEditLinks().add(link2);
                if (tree.has(link2.getTitle() + this.getJSONAnnotation(this.jsonMediaETag))) {
                    link2.setMediaETag(tree.get(link2.getTitle() + this.getJSONAnnotation(this.jsonMediaETag)).asText());
                    toRemove.add(link2.getTitle() + this.getJSONAnnotation(this.jsonMediaETag));
                }
                toRemove.add((String)field.getKey());
                toRemove.add(this.setInline((String)field.getKey(), this.getJSONAnnotation(this.jsonMediaEditLink), (JsonNode)tree, parser.getCodec(), link2));
                continue;
            }
            if (((String)field.getKey()).endsWith(this.getJSONAnnotation(this.jsonMediaContentType))) {
                String linkTitle = this.getTitle(field);
                for (Link link3 : entity.getMediaEditLinks()) {
                    if (!linkTitle.equals(link3.getTitle())) continue;
                    ((LinkImpl)link3).setType(((JsonNode)field.getValue()).asText());
                }
                toRemove.add((String)field.getKey());
                continue;
            }
            if (((String)field.getKey()).charAt(0) == '#') {
                ODataOperation operation = new ODataOperation();
                operation.setMetadataAnchor((String)field.getKey());
                ObjectNode opNode = (ObjectNode)tree.get((String)field.getKey());
                operation.setTitle(opNode.get("title").asText());
                operation.setTarget(URI.create(opNode.get("target").asText()));
                entity.getOperations().add(operation);
                toRemove.add((String)field.getKey());
                continue;
            }
            if (!customAnnotation.matches() || "odata".equals(customAnnotation.group(2))) continue;
            Annotation annotation = new AnnotationImpl();
            annotation.setTerm(customAnnotation.group(2) + "." + customAnnotation.group(3));
            try {
                this.value((Valuable)annotation, (JsonNode)field.getValue(), parser.getCodec());
            }
            catch (EdmPrimitiveTypeException e) {
                throw new IOException(e);
            }
            if (!annotations.containsKey(customAnnotation.group(1))) {
                annotations.put(customAnnotation.group(1), new ArrayList());
            }
            ((List)annotations.get(customAnnotation.group(1))).add(annotation);
        }
        for (Link link4 : entity.getNavigationLinks()) {
            if (!annotations.containsKey(link4.getTitle())) continue;
            link4.getAnnotations().addAll((Collection)annotations.get(link4.getTitle()));
            for (Annotation annotation : (List)annotations.get(link4.getTitle())) {
                toRemove.add(link4.getTitle() + "@" + annotation.getTerm());
            }
        }
        for (Link link4 : entity.getMediaEditLinks()) {
            if (!annotations.containsKey(link4.getTitle())) continue;
            link4.getAnnotations().addAll((Collection)annotations.get(link4.getTitle()));
            for (Annotation annotation : (List)annotations.get(link4.getTitle())) {
                toRemove.add(link4.getTitle() + "@" + annotation.getTerm());
            }
        }
        tree.remove(toRemove);
        try {
            this.populate((Annotatable)entity, entity.getProperties(), tree, parser.getCodec());
        }
        catch (EdmPrimitiveTypeException e) {
            throw new IOException(e);
        }
        return new ResWrap(contextURL, metadataETag, (Object)entity);
    }
}

