/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.data.ContextURL;

public class ContextURLParser {
    public static ContextURL parse(URI contextURL) {
        String[] pathElems;
        String firstToken;
        if (contextURL == null) {
            return null;
        }
        ContextURL.Builder builder = ContextURL.Builder.create();
        String contextURLasString = contextURL.toASCIIString();
        boolean isEntity = false;
        if (contextURLasString.endsWith("/$entity") || contextURLasString.endsWith("/@Element")) {
            isEntity = true;
            builder.suffix(ContextURL.Suffix.ENTITY);
            contextURLasString = contextURLasString.replace("/$entity", "").replace("/@Element", "");
        } else if (contextURLasString.endsWith("/$ref")) {
            builder.suffix(ContextURL.Suffix.REFERENCE);
            contextURLasString = contextURLasString.replace("/$ref", "");
        } else if (contextURLasString.endsWith("/$delta")) {
            builder.suffix(ContextURL.Suffix.DELTA);
            contextURLasString = contextURLasString.replace("/$delta", "");
        } else if (contextURLasString.endsWith("/$deletedEntity")) {
            builder.suffix(ContextURL.Suffix.DELTA_DELETED_ENTITY);
            contextURLasString = contextURLasString.replace("/$deletedEntity", "");
        } else if (contextURLasString.endsWith("/$link")) {
            builder.suffix(ContextURL.Suffix.DELTA_LINK);
            contextURLasString = contextURLasString.replace("/$link", "");
        } else if (contextURLasString.endsWith("/$deletedLink")) {
            builder.suffix(ContextURL.Suffix.DELTA_DELETED_LINK);
            contextURLasString = contextURLasString.replace("/$deletedLink", "");
        }
        builder.serviceRoot(URI.create(StringUtils.substringBefore((String)contextURLasString, (String)"$metadata")));
        String rest = StringUtils.substringAfter((String)contextURLasString, (String)"$metadata#");
        String entitySetOrSingletonOrType = null;
        if (rest.startsWith("Collection(")) {
            entitySetOrSingletonOrType = firstToken = rest.substring(0, rest.indexOf(41) + 1);
        } else {
            int openParIdx = rest.indexOf(40);
            if (openParIdx == -1) {
                entitySetOrSingletonOrType = firstToken = StringUtils.substringBeforeLast((String)rest, (String)"/");
            } else {
                firstToken = isEntity ? rest : StringUtils.substringBeforeLast((String)rest, (String)")") + ")";
                ArrayList<String> parts = new ArrayList<String>();
                for (String split : firstToken.split("\\)/")) {
                    parts.add(split.replaceAll("\\(.*", ""));
                }
                entitySetOrSingletonOrType = StringUtils.join(parts, (char)'/');
                int commaIdx = firstToken.indexOf(44);
                if (commaIdx != -1) {
                    builder.selectList(firstToken.substring(openParIdx + 1, firstToken.length() - 1));
                }
            }
        }
        builder.entitySetOrSingletonOrType(entitySetOrSingletonOrType);
        int slashIdx = entitySetOrSingletonOrType.lastIndexOf(47);
        if (slashIdx != -1 && entitySetOrSingletonOrType.substring(slashIdx + 1).indexOf(46) != -1) {
            String clone = entitySetOrSingletonOrType;
            builder.entitySetOrSingletonOrType(clone.substring(0, slashIdx));
            builder.derivedEntity(clone.substring(slashIdx + 1));
        }
        if (!firstToken.equals(rest) && (pathElems = StringUtils.substringAfter((String)rest, (String)"/").split("/")).length > 0 && pathElems[0].length() > 0) {
            if (pathElems[0].indexOf(46) == -1) {
                builder.navOrPropertyPath(pathElems[0]);
            } else {
                builder.derivedEntity(pathElems[0]);
            }
            if (pathElems.length > 1) {
                builder.navOrPropertyPath(pathElems[1]);
            }
        }
        return builder.build();
    }
}

