/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmTimeOfDay
extends SingletonPrimitiveType {
    private static final Pattern PATTERN = Pattern.compile("(\\p{Digit}{2}):(\\p{Digit}{2})(?::(\\p{Digit}{2})(\\.(\\p{Digit}{0,}?)0*)?)?");
    private static final EdmTimeOfDay INSTANCE = new EdmTimeOfDay();

    public static EdmTimeOfDay getInstance() {
        return INSTANCE;
    }

    public Class<?> getDefaultType() {
        return Calendar.class;
    }

    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value)");
        }
        Calendar dateTimeValue = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        dateTimeValue.clear();
        dateTimeValue.set(11, Byte.parseByte(matcher.group(1)));
        dateTimeValue.set(12, Byte.parseByte(matcher.group(2)));
        dateTimeValue.set(13, matcher.group(3) == null ? 0 : (int)Byte.parseByte(matcher.group(3)));
        int nanoSeconds = 0;
        if (matcher.group(4) != null) {
            if (matcher.group(4).length() == 1 || matcher.group(4).length() > 13) {
                throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value)");
            }
            String decimals = matcher.group(5);
            if (decimals.length() > (precision == null ? 0 : precision)) {
                throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_FACETS_NOT_MATCHED.addContent(value, facets)");
            }
            String milliSeconds = decimals.length() > 3 ? decimals.substring(0, 3) : decimals + "000".substring(decimals.length());
            short millis = Short.parseShort(milliSeconds);
            if (returnType.isAssignableFrom(Timestamp.class)) {
                nanoSeconds = millis * 1000 * 1000;
            } else {
                dateTimeValue.set(14, millis);
            }
        }
        try {
            return (T)EdmDateTimeOffset.convertDateTime((Calendar)dateTimeValue, (int)nanoSeconds, returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value)", (Exception)e);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType)", (Exception)e);
        }
    }

    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        int fractionalSecs;
        Calendar dateTimeValue;
        if (value instanceof Timestamp) {
            Calendar tmp = Calendar.getInstance();
            tmp.setTimeInMillis(((Timestamp)value).getTime());
            dateTimeValue = EdmDateTimeOffset.createDateTime((Object)tmp);
            fractionalSecs = ((Timestamp)value).getNanos();
        } else {
            dateTimeValue = EdmDateTimeOffset.createDateTime(value);
            fractionalSecs = dateTimeValue.get(14);
        }
        StringBuilder result = new StringBuilder();
        EdmDateTimeOffset.appendTwoDigits((StringBuilder)result, (int)dateTimeValue.get(11));
        result.append(':');
        EdmDateTimeOffset.appendTwoDigits((StringBuilder)result, (int)dateTimeValue.get(12));
        result.append(':');
        EdmDateTimeOffset.appendTwoDigits((StringBuilder)result, (int)dateTimeValue.get(13));
        try {
            if (value instanceof Timestamp) {
                EdmDateTimeOffset.appendFractionalSeconds((StringBuilder)result, (int)fractionalSecs, (Integer)precision);
            } else {
                EdmDateTimeOffset.appendMilliseconds((StringBuilder)result, (int)fractionalSecs, (Integer)precision);
            }
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_FACETS_NOT_MATCHED.addContent(value, facets)", (Exception)e);
        }
        return result.toString();
    }
}

