/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.util.regex.Pattern;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmString
extends SingletonPrimitiveType {
    private static final Pattern PATTERN_ASCII = Pattern.compile("\\p{ASCII}*");
    private static final EdmString INSTANCE = new EdmString();

    public EdmString() {
        this.uriPrefix = "'";
        this.uriSuffix = "'";
    }

    public static EdmString getInstance() {
        return INSTANCE;
    }

    public Class<?> getDefaultType() {
        return String.class;
    }

    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        if (isUnicode != null && !isUnicode.booleanValue() && !PATTERN_ASCII.matcher(value).matches() || maxLength != null && maxLength < value.length()) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_FACETS_NOT_MATCHED.addContent(value, facets)");
        }
        if (returnType.isAssignableFrom(String.class)) {
            return returnType.cast(value);
        }
        throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType)");
    }

    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        String result;
        String string = result = value instanceof String ? (String)value : String.valueOf(value);
        if (isUnicode != null && !isUnicode.booleanValue() && !PATTERN_ASCII.matcher(result).matches() || maxLength != null && maxLength < result.length()) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_FACETS_NOT_MATCHED.addContent(value, facets)");
        }
        return result;
    }

    public String toUriLiteral(String literal) {
        if (literal == null) {
            return null;
        }
        int length = literal.length();
        StringBuilder uriLiteral = new StringBuilder(length + 2);
        uriLiteral.append(this.uriPrefix);
        for (int i = 0; i < length; ++i) {
            char c = literal.charAt(i);
            if (c == '\'') {
                uriLiteral.append(c);
            }
            uriLiteral.append(c);
        }
        uriLiteral.append(this.uriSuffix);
        return uriLiteral.toString();
    }

    public String fromUriLiteral(String literal) throws EdmPrimitiveTypeException {
        return literal == null ? null : super.fromUriLiteral(literal).replace("''", "'");
    }
}

